/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.collection.internal;

import org.hibernate.engine.FetchTiming;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.collection.internal.CollectionFetch;
import org.hibernate.sql.results.graph.collection.internal.DelayedCollectionAssembler;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

public class DelayedCollectionFetch
extends CollectionFetch {
    private final DomainResult fkResult;

    public DelayedCollectionFetch(NavigablePath fetchedPath, PluralAttributeMapping fetchedAttribute, FetchParent fetchParent, DomainResult fkResult) {
        super(fetchedPath, fetchedAttribute, fetchParent);
        this.fkResult = fkResult;
    }

    public DomainResultAssembler createAssembler(FetchParentAccess parentAccess, AssemblerCreationState creationState) {
        return new DelayedCollectionAssembler(this.getNavigablePath(), this.getFetchedMapping(), parentAccess, this.fkResult, creationState);
    }

    @Override
    public FetchTiming getTiming() {
        return FetchTiming.DELAYED;
    }

    @Override
    public boolean hasTableGroup() {
        return false;
    }

    @Override
    public JavaTypeDescriptor getResultJavaTypeDescriptor() {
        return this.getFetchedMapping().getJavaTypeDescriptor();
    }
}

