/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.embeddable.internal;

import org.hibernate.LockMode;
import org.hibernate.engine.FetchTiming;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.results.ResultsHelper;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.results.graph.AbstractFetchParent;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.graph.embeddable.EmbeddableInitializer;
import org.hibernate.sql.results.graph.embeddable.EmbeddableResultGraphNode;
import org.hibernate.sql.results.graph.embeddable.EmbeddableValuedFetchable;
import org.hibernate.sql.results.graph.embeddable.internal.EmbeddableAssembler;
import org.hibernate.sql.results.graph.embeddable.internal.EmbeddableFetchInitializer;

public class EmbeddableFetchImpl
extends AbstractFetchParent
implements EmbeddableResultGraphNode,
Fetch {
    private final EmbeddableValuedFetchable embeddedPartDescriptor;
    private final FetchParent fetchParent;
    private final FetchTiming fetchTiming;
    private final boolean hasTableGroup;
    private final boolean nullable;

    public EmbeddableFetchImpl(NavigablePath navigablePath, EmbeddableValuedFetchable embeddedPartDescriptor, FetchParent fetchParent, FetchTiming fetchTiming, boolean hasTableGroup, boolean nullable, DomainResultCreationState creationState) {
        super(embeddedPartDescriptor.getEmbeddableTypeDescriptor(), navigablePath);
        this.embeddedPartDescriptor = embeddedPartDescriptor;
        this.fetchParent = fetchParent;
        this.fetchTiming = fetchTiming;
        this.hasTableGroup = hasTableGroup;
        this.nullable = nullable;
        creationState.getSqlAstCreationState().getFromClauseAccess().resolveTableGroup(this.getNavigablePath(), np -> {
            TableGroup lhsTableGroup = creationState.getSqlAstCreationState().getFromClauseAccess().findTableGroup(fetchParent.getNavigablePath());
            TableGroupJoin tableGroupJoin = this.getReferencedMappingContainer().createTableGroupJoin(this.getNavigablePath(), lhsTableGroup, null, nullable ? SqlAstJoinType.LEFT : SqlAstJoinType.INNER, LockMode.NONE, creationState.getSqlAstCreationState());
            return tableGroupJoin.getJoinedGroup();
        });
        this.afterInitialize(creationState);
    }

    @Override
    public FetchTiming getTiming() {
        return this.fetchTiming;
    }

    @Override
    public boolean hasTableGroup() {
        return this.hasTableGroup;
    }

    @Override
    public FetchParent getFetchParent() {
        return this.fetchParent;
    }

    @Override
    public EmbeddableMappingType getFetchContainer() {
        return (EmbeddableMappingType)super.getFetchContainer();
    }

    @Override
    public EmbeddableValuedModelPart getReferencedMappingContainer() {
        return this.getFetchContainer().getEmbeddedValueMapping();
    }

    @Override
    public Fetchable getFetchedMapping() {
        return this.getReferencedMappingContainer();
    }

    @Override
    public DomainResult<?> asResult(DomainResultCreationState creationState) {
        return this.embeddedPartDescriptor.createDomainResult(this.getNavigablePath(), ResultsHelper.impl(creationState).getFromClauseAccess().getTableGroup(this.fetchParent.getNavigablePath()), null, creationState);
    }

    @Override
    public EmbeddableMappingType getReferencedMappingType() {
        return this.getFetchContainer();
    }

    public DomainResultAssembler createAssembler(FetchParentAccess parentAccess, AssemblerCreationState creationState) {
        EmbeddableInitializer initializer = (EmbeddableInitializer)creationState.resolveInitializer(this.getNavigablePath(), this.getReferencedModePart(), () -> new EmbeddableFetchInitializer(parentAccess, this, creationState));
        return new EmbeddableAssembler(initializer);
    }
}

