/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.entity.internal;

import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.EntityValuedModelPart;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.FetchableContainer;
import org.hibernate.sql.results.graph.entity.AbstractEntityResultGraphNode;
import org.hibernate.sql.results.graph.entity.EntityInitializer;
import org.hibernate.sql.results.graph.entity.EntityResult;
import org.hibernate.sql.results.graph.entity.EntityResultGraphNode;
import org.hibernate.sql.results.graph.entity.internal.EntityAssembler;
import org.hibernate.sql.results.graph.entity.internal.EntityResultInitializer;

public class EntityResultImpl
extends AbstractEntityResultGraphNode
implements EntityResult {
    private final String resultVariable;

    public EntityResultImpl(NavigablePath navigablePath, EntityValuedModelPart entityValuedModelPart, String resultVariable, DomainResultCreationState creationState) {
        this(navigablePath, entityValuedModelPart, resultVariable, null, creationState);
    }

    public EntityResultImpl(NavigablePath navigablePath, EntityValuedModelPart entityValuedModelPart, String resultVariable, EntityMappingType targetType, DomainResultCreationState creationState) {
        super(entityValuedModelPart, creationState.getSqlAstCreationState().determineLockMode(resultVariable), navigablePath, creationState);
        this.resultVariable = resultVariable;
        this.afterInitialize(creationState);
    }

    @Override
    public FetchableContainer getReferencedMappingType() {
        return this.getReferencedMappingContainer();
    }

    @Override
    public EntityValuedModelPart getReferencedModePart() {
        return this.getEntityValuedModelPart();
    }

    @Override
    public String getResultVariable() {
        return this.resultVariable;
    }

    public DomainResultAssembler createResultAssembler(AssemblerCreationState creationState) {
        EntityInitializer initializer = (EntityInitializer)creationState.resolveInitializer(this.getNavigablePath(), this.getReferencedModePart(), () -> new EntityResultInitializer((EntityResultGraphNode)this, this.getNavigablePath(), this.getLockMode(), this.getIdentifierResult(), this.getDiscriminatorResult(), this.getVersionResult(), this.getRowIdResult(), creationState));
        return new EntityAssembler(this.getResultJavaTypeDescriptor(), initializer);
    }

    public String toString() {
        return "EntityResultImpl {" + this.getNavigablePath() + "}";
    }
}

