/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.jdbc.internal;

import java.sql.SQLException;
import org.hibernate.CacheMode;
import org.hibernate.cache.spi.QueryKey;
import org.hibernate.cache.spi.QueryResultsCache;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.exec.ExecutionException;
import org.hibernate.sql.exec.internal.JdbcExecHelper;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.results.caching.QueryCachePutManager;
import org.hibernate.sql.results.caching.internal.QueryCachePutManagerDisabledImpl;
import org.hibernate.sql.results.caching.internal.QueryCachePutManagerEnabledImpl;
import org.hibernate.sql.results.jdbc.internal.AbstractJdbcValues;
import org.hibernate.sql.results.jdbc.internal.ResultSetAccess;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMapping;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;
import org.hibernate.type.descriptor.WrapperOptions;

public class JdbcValuesResultSetImpl
extends AbstractJdbcValues {
    private final ResultSetAccess resultSetAccess;
    private final JdbcValuesMapping valuesMapping;
    private final ExecutionContext executionContext;
    private final SqlSelection[] sqlSelections;
    private final Object[] currentRowJdbcValues;

    public JdbcValuesResultSetImpl(ResultSetAccess resultSetAccess, QueryKey queryCacheKey, QueryOptions queryOptions, JdbcValuesMapping valuesMapping, ExecutionContext executionContext) {
        super(JdbcValuesResultSetImpl.resolveQueryCachePutManager(executionContext, queryOptions, queryCacheKey));
        this.resultSetAccess = resultSetAccess;
        this.valuesMapping = valuesMapping;
        this.executionContext = executionContext;
        this.sqlSelections = valuesMapping.getSqlSelections().toArray(new SqlSelection[0]);
        this.currentRowJdbcValues = new Object[this.sqlSelections.length];
    }

    private static QueryCachePutManager resolveQueryCachePutManager(ExecutionContext executionContext, QueryOptions queryOptions, QueryKey queryCacheKey) {
        boolean queryCacheEnabled = executionContext.getSession().getFactory().getSessionFactoryOptions().isQueryCacheEnabled();
        CacheMode cacheMode = JdbcExecHelper.resolveCacheMode(executionContext);
        if (queryCacheEnabled && cacheMode.isPutEnabled()) {
            QueryResultsCache queryCache = executionContext.getSession().getFactory().getCache().getQueryResultsCache(queryOptions.getResultCacheRegionName());
            return new QueryCachePutManagerEnabledImpl(queryCache, queryCacheKey);
        }
        return QueryCachePutManagerDisabledImpl.INSTANCE;
    }

    @Override
    protected final boolean processNext(RowProcessingState rowProcessingState) {
        return this.advance(() -> {
            try {
                return this.resultSetAccess.getResultSet().next();
            }
            catch (SQLException e) {
                throw this.makeExecutionException("Error advancing (next) ResultSet position", e);
            }
        });
    }

    @Override
    protected boolean processPrevious(RowProcessingState rowProcessingState) {
        return this.advance(() -> {
            try {
                return this.resultSetAccess.getResultSet().previous();
            }
            catch (SQLException e) {
                throw this.makeExecutionException("Error advancing (previous) ResultSet position", e);
            }
        });
    }

    @Override
    protected boolean processScroll(int numberOfRows, RowProcessingState rowProcessingState) {
        return this.advance(() -> {
            try {
                return this.resultSetAccess.getResultSet().relative(numberOfRows);
            }
            catch (SQLException e) {
                throw this.makeExecutionException("Error advancing (scroll) ResultSet position", e);
            }
        });
    }

    @Override
    public int getPosition() {
        try {
            return this.resultSetAccess.getResultSet().getRow() - 1;
        }
        catch (SQLException e) {
            throw this.makeExecutionException("Error calling ResultSet#getRow", e);
        }
    }

    @Override
    protected boolean processPosition(int position, RowProcessingState rowProcessingState) {
        return this.advance(() -> {
            try {
                return this.resultSetAccess.getResultSet().absolute(position);
            }
            catch (SQLException e) {
                throw this.makeExecutionException("Error advancing (scroll) ResultSet position", e);
            }
        });
    }

    @Override
    public boolean isBeforeFirst(RowProcessingState rowProcessingState) {
        try {
            return this.resultSetAccess.getResultSet().isBeforeFirst();
        }
        catch (SQLException e) {
            throw this.makeExecutionException("Error calling ResultSet#isBeforeFirst", e);
        }
    }

    @Override
    public boolean first(RowProcessingState rowProcessingState) {
        return this.advance(() -> {
            try {
                return this.resultSetAccess.getResultSet().first();
            }
            catch (SQLException e) {
                throw this.makeExecutionException("Error advancing (first) ResultSet position", e);
            }
        });
    }

    @Override
    public boolean isAfterLast(RowProcessingState rowProcessingState) {
        try {
            return this.resultSetAccess.getResultSet().isAfterLast();
        }
        catch (SQLException e) {
            throw this.makeExecutionException("Error calling ResultSet#isAfterLast", e);
        }
    }

    @Override
    public boolean last(RowProcessingState rowProcessingState) {
        return this.advance(() -> {
            try {
                return this.resultSetAccess.getResultSet().last();
            }
            catch (SQLException e) {
                throw this.makeExecutionException("Error advancing (last) ResultSet position", e);
            }
        });
    }

    private boolean advance(Advancer advancer) {
        boolean hasResult = advancer.advance();
        if (!hasResult) {
            return false;
        }
        try {
            this.readCurrentRowValues();
            return true;
        }
        catch (SQLException e) {
            throw this.makeExecutionException("Error reading ResultSet row values", e);
        }
    }

    private ExecutionException makeExecutionException(String message, SQLException cause) {
        return new ExecutionException(message, (Throwable)((Object)this.executionContext.getSession().getJdbcServices().getSqlExceptionHelper().convert(cause, message)));
    }

    private void readCurrentRowValues() throws SQLException {
        for (SqlSelection sqlSelection : this.sqlSelections) {
            this.currentRowJdbcValues[sqlSelection.getValuesArrayPosition()] = sqlSelection.getJdbcValueExtractor().extract(this.resultSetAccess.getResultSet(), sqlSelection.getJdbcResultSetIndex(), (WrapperOptions)this.executionContext.getSession());
        }
    }

    @Override
    protected void release() {
        this.resultSetAccess.release();
    }

    @Override
    public JdbcValuesMapping getValuesMapping() {
        return this.valuesMapping;
    }

    @Override
    public Object[] getCurrentRowValuesArray() {
        return this.currentRowJdbcValues;
    }

    @FunctionalInterface
    private static interface Advancer {
        public boolean advance();
    }
}

