/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.schema.internal.exec;

import java.io.Reader;
import java.util.List;
import java.util.function.Function;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.tool.schema.internal.SchemaCreatorImpl;
import org.hibernate.tool.schema.spi.ScriptSourceInput;

public abstract class AbstractScriptSourceInput
implements ScriptSourceInput {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(SchemaCreatorImpl.class);

    protected abstract String getScriptDescription();

    protected abstract Reader prepareReader();

    protected abstract void releaseReader(Reader var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> extract(Function<Reader, List<String>> extracter) {
        log.executingImportScript(this.getScriptDescription());
        Reader inputReader = this.prepareReader();
        try {
            List<String> list = extracter.apply(inputReader);
            return list;
        }
        finally {
            this.releaseReader(inputReader);
        }
    }
}

