/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import org.hibernate.type.AbstractSingleColumnStandardBasicType;
import org.hibernate.type.BasicType;
import org.hibernate.type.CharacterArrayClobType;
import org.hibernate.type.CharacterArrayNClobType;
import org.hibernate.type.SqlTypeDescriptorIndicatorCapable;
import org.hibernate.type.descriptor.java.CharacterArrayTypeDescriptor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptorIndicators;
import org.hibernate.type.descriptor.sql.VarcharTypeDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public class CharacterArrayType
extends AbstractSingleColumnStandardBasicType<Character[]>
implements SqlTypeDescriptorIndicatorCapable<Character[]> {
    public static final CharacterArrayType INSTANCE = new CharacterArrayType();

    public CharacterArrayType() {
        super(VarcharTypeDescriptor.INSTANCE, CharacterArrayTypeDescriptor.INSTANCE);
    }

    @Override
    public String getName() {
        return "wrapper-characters";
    }

    @Override
    public String[] getRegistrationKeys() {
        return new String[]{this.getName(), Character[].class.getName(), "Character[]"};
    }

    @Override
    public <X> BasicType<X> resolveIndicatedType(SqlTypeDescriptorIndicators indicators) {
        if (indicators.isNationalized()) {
            TypeConfiguration typeConfiguration = indicators.getTypeConfiguration();
            if (indicators.isLob()) {
                return CharacterArrayNClobType.INSTANCE;
            }
            SqlTypeDescriptor nvarcharType = typeConfiguration.getSqlTypeDescriptorRegistry().getDescriptor(-9);
            return typeConfiguration.getBasicTypeRegistry().resolve(this.getJavaTypeDescriptor(), nvarcharType);
        }
        if (indicators.isLob()) {
            return CharacterArrayClobType.INSTANCE;
        }
        return this;
    }
}

