/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.util.Comparator;
import java.util.SortedMap;
import java.util.TreeMap;
import org.hibernate.collection.internal.PersistentSortedMap;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.type.MapType;
import org.hibernate.type.spi.TypeConfiguration;

public class SortedMapType
extends MapType {
    private final Comparator comparator;

    public SortedMapType(TypeConfiguration typeConfiguration, String role, String propertyRef, Comparator comparator) {
        super(typeConfiguration, role, propertyRef);
        this.comparator = comparator;
    }

    @Override
    public PersistentCollection instantiate(SharedSessionContractImplementor session, CollectionPersister persister, Object key) {
        return new PersistentSortedMap(session, this.comparator);
    }

    @Override
    public Class getReturnedClass() {
        return SortedMap.class;
    }

    @Override
    public Object instantiate(int anticipatedSize) {
        return new TreeMap(this.comparator);
    }

    @Override
    public PersistentCollection wrap(SharedSessionContractImplementor session, Object collection) {
        return new PersistentSortedMap(session, (SortedMap)collection);
    }
}

