/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.converter;

import java.io.Serializable;
import org.hibernate.metamodel.model.convert.spi.JpaAttributeConverter;
import org.hibernate.type.descriptor.java.MutableMutabilityPlan;

public class AttributeConverterMutabilityPlanImpl<T>
extends MutableMutabilityPlan<T> {
    private final JpaAttributeConverter converter;
    private final boolean mutable;

    public AttributeConverterMutabilityPlanImpl(JpaAttributeConverter converter, boolean mutable) {
        this.converter = converter;
        this.mutable = mutable;
    }

    @Override
    public boolean isMutable() {
        return this.mutable;
    }

    @Override
    protected T deepCopyNotNull(T value) {
        return (T)this.converter.toDomainValue(this.converter.toRelationalValue(value));
    }

    @Override
    public Serializable disassemble(T value) {
        if (this.mutable) {
            return (Serializable)this.converter.toRelationalValue(value);
        }
        return (Serializable)value;
    }

    @Override
    public T assemble(Serializable cached) {
        if (this.mutable) {
            return (T)this.converter.toDomainValue(cached);
        }
        return (T)cached;
    }
}

