/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.converter;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.persistence.AttributeConverter;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.model.convert.spi.JpaAttributeConverter;
import org.hibernate.type.AbstractSingleColumnStandardBasicType;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.converter.AttributeConverterMutabilityPlanImpl;
import org.hibernate.type.descriptor.java.ImmutableMutabilityPlan;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;
import org.jboss.logging.Logger;

public class AttributeConverterTypeAdapter<T>
extends AbstractSingleColumnStandardBasicType<T> {
    private static final Logger log = Logger.getLogger(AttributeConverterTypeAdapter.class);
    public static final String NAME_PREFIX = "converted::";
    private final String name;
    private final String description;
    private final JavaTypeDescriptor<T> domainJtd;
    private final JavaTypeDescriptor<?> relationalJtd;
    private final JpaAttributeConverter<? extends T, ?> attributeConverter;
    private final MutabilityPlan<T> mutabilityPlan;

    public AttributeConverterTypeAdapter(String name, String description, JpaAttributeConverter<? extends T, ?> attributeConverter, SqlTypeDescriptor std, JavaTypeDescriptor<?> relationalJtd, JavaTypeDescriptor<T> domainJtd, MutabilityPlan<T> mutabilityPlan) {
        super(std, relationalJtd);
        this.name = name;
        this.description = description;
        this.domainJtd = domainJtd;
        this.relationalJtd = relationalJtd;
        this.attributeConverter = attributeConverter;
        this.mutabilityPlan = mutabilityPlan == null ? (domainJtd.getMutabilityPlan().isMutable() ? new AttributeConverterMutabilityPlanImpl(attributeConverter, true) : ImmutableMutabilityPlan.INSTANCE) : mutabilityPlan;
        log.debugf("Created AttributeConverterTypeAdapter -> %s", (Object)name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public JavaTypeDescriptor<T> getDomainJtd() {
        return this.domainJtd;
    }

    public JavaTypeDescriptor<?> getRelationalJtd() {
        return this.relationalJtd;
    }

    public JpaAttributeConverter<? extends T, ?> getAttributeConverter() {
        return this.attributeConverter;
    }

    @Override
    public void nullSafeSet(CallableStatement st, Object value, String name, SharedSessionContractImplementor session) throws SQLException {
        AttributeConverter<? extends T, ?> converter = this.attributeConverter.getConverterBean().getBeanInstance();
        Object converted = converter.convertToDatabaseColumn(value);
        super.nullSafeSet(st, converted, name, session);
    }

    @Override
    protected void nullSafeSet(PreparedStatement st, Object value, int index, WrapperOptions options) throws SQLException {
        AttributeConverter<? extends T, ?> converter = this.attributeConverter.getConverterBean().getBeanInstance();
        Object converted = converter.convertToDatabaseColumn(value);
        super.nullSafeSet(st, converted, index, options);
    }

    @Override
    protected MutabilityPlan<T> getMutabilityPlan() {
        return this.mutabilityPlan;
    }

    public String toString() {
        return this.description;
    }
}

