/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.persistence.TemporalType;
import org.hibernate.HibernateException;
import org.hibernate.dialect.Dialect;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractTemporalTypeDescriptor;
import org.hibernate.type.descriptor.java.CalendarTypeDescriptor;
import org.hibernate.type.descriptor.java.JdbcTimeTypeDescriptor;
import org.hibernate.type.descriptor.java.JdbcTimestampTypeDescriptor;
import org.hibernate.type.descriptor.java.MutableMutabilityPlan;
import org.hibernate.type.descriptor.java.TemporalJavaTypeDescriptor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptorIndicators;
import org.hibernate.type.descriptor.sql.TimestampTypeDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public class DateTypeDescriptor
extends AbstractTemporalTypeDescriptor<java.util.Date> {
    public static final DateTypeDescriptor INSTANCE = new DateTypeDescriptor();
    public static final String DATE_FORMAT = "dd MMMM yyyy";

    public DateTypeDescriptor() {
        super(java.util.Date.class, DateMutabilityPlan.INSTANCE);
    }

    @Override
    public TemporalType getPrecision() {
        return TemporalType.TIMESTAMP;
    }

    @Override
    public int getDefaultSqlPrecision(Dialect dialect) {
        return dialect.getDefaultTimestampPrecision();
    }

    @Override
    public SqlTypeDescriptor getJdbcRecommendedSqlType(SqlTypeDescriptorIndicators context) {
        return TimestampTypeDescriptor.INSTANCE;
    }

    @Override
    protected <X> TemporalJavaTypeDescriptor<X> forDatePrecision(TypeConfiguration typeConfiguration) {
        return this;
    }

    @Override
    protected <X> TemporalJavaTypeDescriptor<X> forTimestampPrecision(TypeConfiguration typeConfiguration) {
        return JdbcTimestampTypeDescriptor.INSTANCE;
    }

    @Override
    protected <X> TemporalJavaTypeDescriptor<X> forTimePrecision(TypeConfiguration typeConfiguration) {
        return JdbcTimeTypeDescriptor.INSTANCE;
    }

    @Override
    public String toString(java.util.Date value) {
        return new SimpleDateFormat(DATE_FORMAT).format(value);
    }

    @Override
    public java.util.Date fromString(String string) {
        try {
            return new SimpleDateFormat(DATE_FORMAT).parse(string);
        }
        catch (ParseException pe) {
            throw new HibernateException("could not parse date string" + string, pe);
        }
    }

    @Override
    public boolean areEqual(java.util.Date one, java.util.Date another) {
        if (one == another) {
            return true;
        }
        return one != null && another != null && one.getTime() == another.getTime();
    }

    @Override
    public int extractHashCode(java.util.Date value) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(value);
        return CalendarTypeDescriptor.INSTANCE.extractHashCode(calendar);
    }

    @Override
    public <X> X unwrap(java.util.Date value, Class<X> type, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (Date.class.isAssignableFrom(type)) {
            Date rtn = Date.class.isInstance(value) ? (Date)value : new Date(value.getTime());
            return (X)rtn;
        }
        if (Time.class.isAssignableFrom(type)) {
            Time rtn = Time.class.isInstance(value) ? (Time)value : new Time(value.getTime());
            return (X)rtn;
        }
        if (Timestamp.class.isAssignableFrom(type)) {
            Timestamp rtn = Timestamp.class.isInstance(value) ? (Timestamp)value : new Timestamp(value.getTime());
            return (X)rtn;
        }
        if (java.util.Date.class.isAssignableFrom(type)) {
            return (X)value;
        }
        if (Calendar.class.isAssignableFrom(type)) {
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTimeInMillis(value.getTime());
            return (X)cal;
        }
        if (Long.class.isAssignableFrom(type)) {
            return (X)Long.valueOf(value.getTime());
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> java.util.Date wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (java.util.Date.class.isInstance(value)) {
            return (java.util.Date)value;
        }
        if (Long.class.isInstance(value)) {
            return new java.util.Date((Long)value);
        }
        if (Calendar.class.isInstance(value)) {
            return new java.util.Date(((Calendar)value).getTimeInMillis());
        }
        throw this.unknownWrap(value.getClass());
    }

    public static class DateMutabilityPlan
    extends MutableMutabilityPlan<java.util.Date> {
        public static final DateMutabilityPlan INSTANCE = new DateMutabilityPlan();

        @Override
        public java.util.Date deepCopyNotNull(java.util.Date value) {
            return new java.util.Date(value.getTime());
        }
    }
}

