/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import javax.persistence.EnumType;
import org.hibernate.dialect.Dialect;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractClassTypeDescriptor;
import org.hibernate.type.descriptor.java.ImmutableMutabilityPlan;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptorIndicators;

public class EnumJavaTypeDescriptor<T extends Enum<T>>
extends AbstractClassTypeDescriptor<T> {
    public EnumJavaTypeDescriptor(Class<T> type) {
        super(type, ImmutableMutabilityPlan.INSTANCE);
    }

    @Override
    public SqlTypeDescriptor getJdbcRecommendedSqlType(SqlTypeDescriptorIndicators context) {
        if (context.getEnumeratedType() != null && context.getEnumeratedType() == EnumType.STRING) {
            if (context.getColumnLength() == 1L) {
                return context.isNationalized() ? context.getTypeConfiguration().getSqlTypeDescriptorRegistry().getDescriptor(-15) : context.getTypeConfiguration().getSqlTypeDescriptorRegistry().getDescriptor(1);
            }
            return context.isNationalized() ? context.getTypeConfiguration().getSqlTypeDescriptorRegistry().getDescriptor(-9) : context.getTypeConfiguration().getSqlTypeDescriptorRegistry().getDescriptor(12);
        }
        return context.getTypeConfiguration().getSqlTypeDescriptorRegistry().getDescriptor(-6);
    }

    @Override
    public String toString(T value) {
        return value == null ? "<null>" : ((Enum)value).name();
    }

    @Override
    public T fromString(String string) {
        return string == null ? null : (T)Enum.valueOf(this.getJavaTypeClass(), string);
    }

    @Override
    public <X> X unwrap(T value, Class<X> type, WrapperOptions options) {
        if (String.class.equals(type)) {
            return (X)this.toName(value);
        }
        if (Long.class.equals(type)) {
            return (X)this.toLong(value);
        }
        if (Integer.class.equals(type)) {
            return (X)this.toInteger(value);
        }
        if (Short.class.equals(type)) {
            return (X)this.toShort(value);
        }
        if (Byte.class.equals(type)) {
            return (X)this.toByte(value);
        }
        return (X)value;
    }

    @Override
    public <X> T wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return this.fromName((String)value);
        }
        if (value instanceof Long) {
            return this.fromLong((Long)value);
        }
        if (value instanceof Integer) {
            return this.fromInteger((Integer)value);
        }
        if (value instanceof Short) {
            return this.fromShort((Short)value);
        }
        if (value instanceof Byte) {
            return this.fromByte((Byte)value);
        }
        return (T)((Enum)value);
    }

    public Byte toByte(T domainForm) {
        if (domainForm == null) {
            return null;
        }
        return (byte)((Enum)domainForm).ordinal();
    }

    public Short toShort(T domainForm) {
        if (domainForm == null) {
            return null;
        }
        return (short)((Enum)domainForm).ordinal();
    }

    public Integer toInteger(T domainForm) {
        if (domainForm == null) {
            return null;
        }
        return ((Enum)domainForm).ordinal();
    }

    public Long toLong(T domainForm) {
        if (domainForm == null) {
            return null;
        }
        return ((Enum)domainForm).ordinal();
    }

    public Integer toOrdinal(T domainForm) {
        return this.toInteger(domainForm);
    }

    public T fromByte(Byte relationalForm) {
        if (relationalForm == null) {
            return null;
        }
        return (T)((Enum[])this.getJavaTypeClass().getEnumConstants())[relationalForm];
    }

    public T fromShort(Short relationalForm) {
        if (relationalForm == null) {
            return null;
        }
        return (T)((Enum[])this.getJavaTypeClass().getEnumConstants())[relationalForm];
    }

    public T fromInteger(Integer relationalForm) {
        if (relationalForm == null) {
            return null;
        }
        return (T)((Enum[])this.getJavaTypeClass().getEnumConstants())[relationalForm];
    }

    public T fromLong(Long relationalForm) {
        if (relationalForm == null) {
            return null;
        }
        return (T)((Enum[])this.getJavaTypeClass().getEnumConstants())[relationalForm.intValue()];
    }

    public T fromOrdinal(Integer relationalForm) {
        return this.fromInteger(relationalForm);
    }

    public String toName(T domainForm) {
        if (domainForm == null) {
            return null;
        }
        return ((Enum)domainForm).name();
    }

    public T fromName(String relationalForm) {
        if (relationalForm == null) {
            return null;
        }
        return Enum.valueOf(this.getJavaTypeClass(), relationalForm.trim());
    }

    @Override
    public String getCheckCondition(String columnName, SqlTypeDescriptor sqlTypeDescriptor, Dialect dialect) {
        switch (sqlTypeDescriptor.getSqlType()) {
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                StringBuilder sb = new StringBuilder();
                sb.append(columnName).append(" in (");
                String separator = "";
                for (Enum value : (Enum[])this.getJavaTypeClass().getEnumConstants()) {
                    sb.append(separator);
                    sb.append('\'').append(value.name()).append('\'');
                    separator = ",";
                }
                return sb.append(')').toString();
            }
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                int last = ((Enum[])this.getJavaTypeClass().getEnumConstants()).length - 1;
                return columnName + " between 0 and " + last;
            }
        }
        return null;
    }
}

