/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java.spi;

import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.hibernate.type.descriptor.java.AbstractClassTypeDescriptor;
import org.hibernate.type.descriptor.java.EnumJavaTypeDescriptor;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.java.SerializableTypeDescriptor;
import org.hibernate.type.descriptor.java.spi.DynamicModelJtd;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptorBaseline;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptorBasicAdaptor;
import org.hibernate.type.spi.TypeConfiguration;
import org.hibernate.type.spi.TypeConfigurationAware;
import org.jboss.logging.Logger;

public class JavaTypeDescriptorRegistry
implements JavaTypeDescriptorBaseline.BaselineTarget,
Serializable {
    private static final Logger log = Logger.getLogger(JavaTypeDescriptorRegistry.class);
    private final TypeConfiguration typeConfiguration;
    private final ConcurrentHashMap<Type, JavaTypeDescriptor<?>> descriptorsByType = new ConcurrentHashMap();

    public JavaTypeDescriptorRegistry(TypeConfiguration typeConfiguration) {
        this.typeConfiguration = typeConfiguration;
        JavaTypeDescriptorBaseline.prime(this);
    }

    @Override
    public void addBaselineDescriptor(JavaTypeDescriptor<?> descriptor) {
        if (descriptor.getJavaType() == null) {
            throw new IllegalStateException("Illegal to add BasicJavaTypeDescriptor with null Java type");
        }
        this.addBaselineDescriptor(descriptor.getJavaType(), descriptor);
    }

    @Override
    public void addBaselineDescriptor(Type describedJavaType, JavaTypeDescriptor<?> descriptor) {
        this.performInjections(descriptor);
        this.descriptorsByType.put(describedJavaType, descriptor);
    }

    private void performInjections(JavaTypeDescriptor<?> descriptor) {
        if (descriptor instanceof TypeConfigurationAware) {
            ((TypeConfigurationAware)((Object)descriptor)).setTypeConfiguration(this.typeConfiguration);
        }
    }

    public <T> JavaTypeDescriptor<T> getDescriptor(Type javaType) {
        return this.resolveDescriptor(javaType);
    }

    public void addDescriptor(JavaTypeDescriptor<?> descriptor) {
        JavaTypeDescriptor<?> old = this.descriptorsByType.put(descriptor.getJavaType(), descriptor);
        if (old != null) {
            log.debugf("JavaTypeDescriptorRegistry entry replaced : %s -> %s (was %s)", (Object)descriptor.getJavaType(), descriptor, old);
        }
        this.performInjections(descriptor);
    }

    public <J> JavaTypeDescriptor<J> resolveDescriptor(Type javaType, Supplier<JavaTypeDescriptor<J>> creator) {
        JavaTypeDescriptor<?> cached = this.descriptorsByType.get(javaType);
        if (cached != null) {
            return cached;
        }
        JavaTypeDescriptor<J> created = creator.get();
        this.descriptorsByType.put(javaType, created);
        return created;
    }

    public <J> JavaTypeDescriptor<J> resolveDescriptor(Type javaType) {
        return this.resolveDescriptor(javaType, () -> {
            Class javaTypeClass;
            if (javaType instanceof Class) {
                javaTypeClass = (Class)javaType;
            } else {
                ParameterizedType parameterizedType = (ParameterizedType)javaType;
                javaTypeClass = (Class)parameterizedType.getRawType();
            }
            AbstractClassTypeDescriptor fallbackDescriptor = javaTypeClass.isEnum() ? new EnumJavaTypeDescriptor(javaTypeClass) : (Serializable.class.isAssignableFrom(javaTypeClass) ? new SerializableTypeDescriptor(javaTypeClass) : new JavaTypeDescriptorBasicAdaptor(javaTypeClass));
            return fallbackDescriptor;
        });
    }

    public JavaTypeDescriptor<?> resolveDynamicEntityDescriptor(String typeName) {
        return new DynamicModelJtd();
    }
}

