/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.sql;

import java.io.Serializable;
import org.hibernate.query.CastType;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.java.BasicJavaDescriptor;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.sql.JdbcLiteralFormatter;
import org.hibernate.type.descriptor.sql.JdbcTypeJavaClassMappings;
import org.hibernate.type.spi.TypeConfiguration;

public interface SqlTypeDescriptor
extends Serializable {
    default public String getFriendlyName() {
        return Integer.toString(this.getSqlType());
    }

    public int getSqlType();

    default public int getJdbcTypeCode() {
        return this.getSqlType();
    }

    public boolean canBeRemapped();

    default public <T> BasicJavaDescriptor<T> getJdbcRecommendedJavaTypeMapping(TypeConfiguration typeConfiguration) {
        return (BasicJavaDescriptor)typeConfiguration.getJavaTypeDescriptorRegistry().getDescriptor(JdbcTypeJavaClassMappings.INSTANCE.determineJavaClassForJdbcTypeCode(this.getSqlType()));
    }

    default public <T> JdbcLiteralFormatter<T> getJdbcLiteralFormatter(JavaTypeDescriptor<T> javaTypeDescriptor) {
        return (value, dialect, wrapperOptions) -> value.toString();
    }

    public <X> ValueBinder<X> getBinder(JavaTypeDescriptor<X> var1);

    public <X> ValueExtractor<X> getExtractor(JavaTypeDescriptor<X> var1);

    default public boolean isInteger() {
        switch (this.getSqlType()) {
            case -7: 
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    default public boolean isNumber() {
        switch (this.getSqlType()) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    default public boolean isString() {
        switch (this.getSqlType()) {
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    default public CastType getCastType() {
        switch (this.getSqlType()) {
            case -6: 
            case 4: 
            case 5: {
                return CastType.INTEGER;
            }
            case -5: {
                return CastType.LONG;
            }
            case 6: 
            case 7: {
                return CastType.FLOAT;
            }
            case 8: {
                return CastType.DOUBLE;
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                return CastType.STRING;
            }
            case 16: {
                return CastType.BOOLEAN;
            }
            case 2: 
            case 3: {
                return CastType.FIXED;
            }
            case 91: {
                return CastType.DATE;
            }
            case 92: {
                return CastType.TIME;
            }
            case 93: {
                return CastType.TIMESTAMP;
            }
            case 2014: {
                return CastType.OFFSET_TIMESTAMP;
            }
            case 0: {
                return CastType.NULL;
            }
        }
        return CastType.OTHER;
    }
}

