/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.sql.internal;

import org.hibernate.dialect.Dialect;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.sql.spi.BasicJdbcLiteralFormatter;

public class JdbcLiteralFormatterCharacterData
extends BasicJdbcLiteralFormatter {
    public static final String NATIONALIZED_PREFIX = "n";
    private final boolean isNationalized;

    public JdbcLiteralFormatterCharacterData(JavaTypeDescriptor javaTypeDescriptor) {
        this(javaTypeDescriptor, false);
    }

    public JdbcLiteralFormatterCharacterData(JavaTypeDescriptor javaTypeDescriptor, boolean isNationalized) {
        super(javaTypeDescriptor);
        this.isNationalized = isNationalized;
    }

    public String toJdbcLiteral(Object value, Dialect dialect, WrapperOptions wrapperOptions) {
        String literalValue = this.unwrap(value, String.class, wrapperOptions);
        String inlineLiteral = dialect.inlineLiteral(literalValue);
        if (this.isNationalized) {
            return NATIONALIZED_PREFIX.concat(inlineLiteral);
        }
        return inlineLiteral;
    }
}

