/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.internal;

import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.query.CastType;
import org.hibernate.type.AbstractSingleColumnStandardBasicType;
import org.hibernate.type.BasicType;
import org.hibernate.type.SqlTypeDescriptorIndicatorCapable;
import org.hibernate.type.descriptor.java.BooleanTypeDescriptor;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptorIndicators;

public class StandardBasicTypeImpl<J>
extends AbstractSingleColumnStandardBasicType
implements SqlTypeDescriptorIndicatorCapable {
    public static final String[] NO_REG_KEYS = ArrayHelper.EMPTY_STRING_ARRAY;

    public StandardBasicTypeImpl(JavaTypeDescriptor<J> jtd, SqlTypeDescriptor std) {
        super(std, jtd);
    }

    @Override
    public String[] getRegistrationKeys() {
        return NO_REG_KEYS;
    }

    @Override
    public String getName() {
        return null;
    }

    public BasicType resolveIndicatedType(SqlTypeDescriptorIndicators indicators) {
        SqlTypeDescriptor recommendedSqlType = this.getJavaTypeDescriptor().getJdbcRecommendedSqlType(indicators);
        if (recommendedSqlType == this.getSqlTypeDescriptor()) {
            return this;
        }
        return indicators.getTypeConfiguration().getBasicTypeRegistry().resolve(this.getJavaTypeDescriptor(), recommendedSqlType);
    }

    @Override
    public CastType getCastType() {
        if (this.getJavaTypeDescriptor() == BooleanTypeDescriptor.INSTANCE) {
            switch (this.sqlType()) {
                case -7: 
                case -6: 
                case 4: 
                case 5: {
                    return CastType.INTEGER_BOOLEAN;
                }
                case 1: {
                    return CastType.YN_BOOLEAN;
                }
            }
        }
        return super.getCastType();
    }
}

