/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.hibernate.boot.model.TypeDefinition;
import org.hibernate.boot.model.TypeDefinitionRegistry;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.type.descriptor.java.BasicJavaDescriptor;
import org.jboss.logging.Logger;

public class TypeDefinitionRegistryStandardImpl
implements TypeDefinitionRegistry {
    private static final Logger log = Logger.getLogger(TypeDefinitionRegistryStandardImpl.class);
    private final TypeDefinitionRegistry parent;
    private final Map<String, TypeDefinition> typeDefinitionMap = new HashMap<String, TypeDefinition>();

    public TypeDefinitionRegistryStandardImpl() {
        this(null);
    }

    public TypeDefinitionRegistryStandardImpl(TypeDefinitionRegistry parent) {
        this.parent = parent;
    }

    @Override
    public TypeDefinition resolve(String typeName) {
        TypeDefinition localDefinition = this.typeDefinitionMap.get(typeName);
        if (localDefinition != null) {
            return localDefinition;
        }
        if (this.parent != null) {
            return this.parent.resolve(typeName);
        }
        return null;
    }

    @Override
    public TypeDefinition resolveAutoApplied(BasicJavaDescriptor<?> jtd) {
        if (jtd.getJavaType() == null) {
            return null;
        }
        return this.typeDefinitionMap.get(jtd.getJavaType().getTypeName());
    }

    @Override
    public TypeDefinitionRegistry register(TypeDefinition typeDefinition) {
        return this.register(typeDefinition, TypeDefinitionRegistry.DuplicationStrategy.OVERWRITE);
    }

    @Override
    public TypeDefinitionRegistry register(TypeDefinition typeDefinition, TypeDefinitionRegistry.DuplicationStrategy duplicationStrategy) {
        if (typeDefinition == null) {
            throw new IllegalArgumentException("TypeDefinition to register cannot be null");
        }
        if (typeDefinition.getTypeImplementorClass() == null) {
            throw new IllegalArgumentException("TypeDefinition to register cannot define null #typeImplementorClass");
        }
        if (!StringHelper.isEmpty(typeDefinition.getName())) {
            this.register(typeDefinition.getName(), typeDefinition, duplicationStrategy);
        }
        if (typeDefinition.getRegistrationKeys() != null) {
            for (String registrationKey : typeDefinition.getRegistrationKeys()) {
                this.register(registrationKey, typeDefinition, duplicationStrategy);
            }
        }
        return this;
    }

    private void register(String name, TypeDefinition typeDefinition, TypeDefinitionRegistry.DuplicationStrategy duplicationStrategy) {
        if (duplicationStrategy == TypeDefinitionRegistry.DuplicationStrategy.KEEP) {
            if (!this.typeDefinitionMap.containsKey(name)) {
                this.typeDefinitionMap.put(name, typeDefinition);
            }
        } else {
            TypeDefinition existing = this.typeDefinitionMap.put(name, typeDefinition);
            if (existing != null && existing != typeDefinition) {
                if (duplicationStrategy == TypeDefinitionRegistry.DuplicationStrategy.OVERWRITE) {
                    log.debugf("Overwrote existing registration [%s] for type definition.", (Object)name);
                } else {
                    throw new IllegalArgumentException(String.format(Locale.ROOT, "Attempted to overwrite registration [%s] for type definition.", name));
                }
            }
        }
    }

    @Override
    public Map<String, TypeDefinition> copyRegistrationMap() {
        return new HashMap<String, TypeDefinition>(this.typeDefinitionMap);
    }
}

