/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.process.internal;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.model.convert.spi.BasicValueConverter;
import org.hibernate.type.AbstractSingleColumnStandardBasicType;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.jdbc.JdbcTypeDescriptorIndicators;

public class ValueConverterTypeAdapter<J>
extends AbstractSingleColumnStandardBasicType<J> {
    private final String description;
    private final BasicValueConverter<J, ?> converter;
    private final ValueBinder valueBinder;

    public ValueConverterTypeAdapter(String description, BasicValueConverter<J, ?> converter, JdbcTypeDescriptorIndicators indicators) {
        super(converter.getRelationalJavaDescriptor().getRecommendedJdbcType(indicators), converter.getRelationalJavaDescriptor());
        this.description = description;
        this.converter = converter;
        this.valueBinder = this.getJdbcTypeDescriptor().getBinder(converter.getRelationalJavaDescriptor());
    }

    @Override
    public String getName() {
        return this.converter.getClass().getName();
    }

    @Override
    public void nullSafeSet(CallableStatement st, Object value, String name, SharedSessionContractImplementor session) throws SQLException {
        Object converted = this.converter.toRelationalValue(value);
        this.valueBinder.bind(st, converted, name, (WrapperOptions)session);
    }

    @Override
    protected void nullSafeSet(PreparedStatement st, Object value, int index, WrapperOptions options) throws SQLException {
        Object converted = this.converter.toRelationalValue(value);
        this.valueBinder.bind(st, converted, index, options);
    }

    @Override
    protected MutabilityPlan<J> getMutabilityPlan() {
        return this.converter.getDomainJavaDescriptor().getMutabilityPlan();
    }

    @Override
    public boolean isEqual(Object one, Object another) {
        return this.converter.getDomainJavaDescriptor().areEqual(one, another);
    }

    public String toString() {
        return this.description;
    }
}

