/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.process.internal;

import java.lang.reflect.Type;
import java.util.function.Function;
import javax.persistence.TemporalType;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.mapping.BasicValue;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.model.convert.spi.BasicValueConverter;
import org.hibernate.type.BasicType;
import org.hibernate.type.RowVersionType;
import org.hibernate.type.descriptor.java.BasicJavaDescriptor;
import org.hibernate.type.descriptor.java.ImmutableMutabilityPlan;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.java.PrimitiveByteArrayTypeDescriptor;
import org.hibernate.type.descriptor.jdbc.JdbcTypeDescriptor;
import org.hibernate.type.descriptor.jdbc.JdbcTypeDescriptorIndicators;
import org.hibernate.type.spi.TypeConfiguration;

public class VersionResolution<E>
implements BasicValue.Resolution<E> {
    private final JavaTypeDescriptor jtd;
    private final JdbcTypeDescriptor jdbcTypeDescriptor;
    private final JdbcMapping jdbcMapping;
    private final BasicType legacyType;

    public static <E> VersionResolution<E> from(Function<TypeConfiguration, Type> implicitJavaTypeAccess, Function<TypeConfiguration, BasicJavaDescriptor> explicitJtdAccess, Function<TypeConfiguration, JdbcTypeDescriptor> explicitStdAccess, final TypeConfiguration typeConfiguration, MetadataBuildingContext context) {
        Type implicitJavaType = implicitJavaTypeAccess.apply(typeConfiguration);
        JavaTypeDescriptor registered = typeConfiguration.getJavaTypeDescriptorRegistry().resolveDescriptor(implicitJavaType);
        if (registered instanceof PrimitiveByteArrayTypeDescriptor) {
            return new VersionResolution<E>(RowVersionType.INSTANCE.getJavaTypeDescriptor(), RowVersionType.INSTANCE.getJdbcTypeDescriptor(), RowVersionType.INSTANCE, RowVersionType.INSTANCE);
        }
        BasicJavaDescriptor jtd = (BasicJavaDescriptor)registered;
        JdbcTypeDescriptor recommendedJdbcType = jtd.getRecommendedJdbcType(new JdbcTypeDescriptorIndicators(){

            @Override
            public TypeConfiguration getTypeConfiguration() {
                return typeConfiguration;
            }

            @Override
            public TemporalType getTemporalPrecision() {
                return TemporalType.TIMESTAMP;
            }
        });
        BasicType basicType = typeConfiguration.getBasicTypeRegistry().resolve(jtd, recommendedJdbcType);
        BasicType legacyType = typeConfiguration.getBasicTypeRegistry().getRegisteredType(jtd.getJavaType());
        assert (legacyType.getJdbcTypeDescriptor().equals(recommendedJdbcType));
        return new VersionResolution<E>(jtd, recommendedJdbcType, basicType, legacyType);
    }

    public VersionResolution(JavaTypeDescriptor javaTypeDescriptor, JdbcTypeDescriptor jdbcTypeDescriptor, JdbcMapping jdbcMapping, BasicType legacyType) {
        this.jtd = javaTypeDescriptor;
        this.jdbcTypeDescriptor = jdbcTypeDescriptor;
        this.jdbcMapping = jdbcMapping;
        this.legacyType = legacyType;
    }

    @Override
    public JdbcMapping getJdbcMapping() {
        return this.jdbcMapping;
    }

    @Override
    public BasicType getLegacyResolvedBasicType() {
        return this.legacyType;
    }

    @Override
    public JavaTypeDescriptor<E> getDomainJavaDescriptor() {
        return this.jtd;
    }

    @Override
    public JavaTypeDescriptor<?> getRelationalJavaDescriptor() {
        return this.jtd;
    }

    @Override
    public JdbcTypeDescriptor getJdbcTypeDescriptor() {
        return this.jdbcTypeDescriptor;
    }

    @Override
    public BasicValueConverter<E, E> getValueConverter() {
        return null;
    }

    @Override
    public MutabilityPlan<E> getMutabilityPlan() {
        return ImmutableMutabilityPlan.instance();
    }
}

