/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.annotations;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.MapKeyEnumerated;
import javax.persistence.MapKeyTemporal;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.MappingException;
import org.hibernate.annotations.CollectionId;
import org.hibernate.annotations.Immutable;
import org.hibernate.annotations.JavaType;
import org.hibernate.annotations.JdbcType;
import org.hibernate.annotations.JdbcTypeCode;
import org.hibernate.annotations.MapKeyJavaType;
import org.hibernate.annotations.MapKeyJdbcType;
import org.hibernate.annotations.MapKeyJdbcTypeCode;
import org.hibernate.annotations.MapKeyType;
import org.hibernate.annotations.Mutability;
import org.hibernate.annotations.Nationalized;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.boot.model.convert.spi.ConverterDescriptor;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.selector.spi.StrategySelector;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.cfg.AccessType;
import org.hibernate.cfg.Ejb3Column;
import org.hibernate.cfg.Ejb3JoinColumn;
import org.hibernate.cfg.NotYetImplementedException;
import org.hibernate.cfg.PkDrivenByDefaultMapsIdSecondPass;
import org.hibernate.cfg.SetBasicValueTypeSecondPass;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.NationalizationSupport;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.mapping.BasicValue;
import org.hibernate.mapping.Table;
import org.hibernate.type.descriptor.java.BasicJavaDescriptor;
import org.hibernate.type.descriptor.java.ImmutableMutabilityPlan;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.jdbc.JdbcTypeDescriptor;
import org.hibernate.type.descriptor.jdbc.JdbcTypeDescriptorIndicators;
import org.hibernate.type.spi.TypeConfiguration;
import org.jboss.logging.Logger;

public class BasicValueBinder<T>
implements JdbcTypeDescriptorIndicators {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)BasicValueBinder.class.getName());
    private final Kind kind;
    private final MetadataBuildingContext buildingContext;
    private final ClassLoaderService classLoaderService;
    private final StrategySelector strategySelector;
    private String explicitBasicTypeName;
    private Map explicitLocalTypeParams;
    private Function<TypeConfiguration, JdbcTypeDescriptor> explicitSqlTypeAccess;
    private Function<TypeConfiguration, BasicJavaDescriptor> explicitJtdAccess;
    private Function<TypeConfiguration, MutabilityPlan> explicitMutabilityAccess;
    private Function<TypeConfiguration, java.lang.reflect.Type> implicitJavaTypeAccess;
    private AccessType accessType;
    private ConverterDescriptor converterDescriptor;
    private boolean isVersion;
    private boolean isNationalized;
    private boolean isLob;
    private EnumType enumType;
    private TemporalType temporalPrecision;
    private Table table;
    private Ejb3Column[] columns;
    private BasicValue basicValue;
    private String timeStampVersionType;
    private String persistentClassName;
    private String propertyName;
    private String returnedClassName;
    private String referencedEntityName;

    public BasicValueBinder(Kind kind, MetadataBuildingContext buildingContext) {
        assert (kind != null);
        assert (buildingContext != null);
        this.kind = kind;
        this.buildingContext = buildingContext;
        this.classLoaderService = buildingContext.getBootstrapContext().getServiceRegistry().getService(ClassLoaderService.class);
        this.strategySelector = buildingContext.getBootstrapContext().getServiceRegistry().getService(StrategySelector.class);
    }

    @Override
    public TypeConfiguration getTypeConfiguration() {
        return this.buildingContext.getBootstrapContext().getTypeConfiguration();
    }

    @Override
    public EnumType getEnumeratedType() {
        return this.enumType;
    }

    @Override
    public boolean isLob() {
        return this.isLob;
    }

    @Override
    public TemporalType getTemporalPrecision() {
        return this.temporalPrecision;
    }

    @Override
    public int getPreferredSqlTypeCodeForBoolean() {
        return this.buildingContext.getPreferredSqlTypeCodeForBoolean();
    }

    @Override
    public boolean isNationalized() {
        return this.isNationalized;
    }

    public void setVersion(boolean isVersion) {
        this.isVersion = isVersion;
        if (isVersion && this.basicValue != null) {
            this.basicValue.makeVersion();
        }
    }

    public void setTimestampVersionType(String versionType) {
        this.timeStampVersionType = versionType;
    }

    public void setReferencedEntityName(String referencedEntityName) {
        this.referencedEntityName = referencedEntityName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public void setReturnedClassName(String returnedClassName) {
        this.returnedClassName = returnedClassName;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public void setColumns(Ejb3Column[] columns) {
        this.columns = columns;
    }

    public void setPersistentClassName(String persistentClassName) {
        this.persistentClassName = persistentClassName;
    }

    public void setAccessType(AccessType accessType) {
        this.accessType = accessType;
    }

    public void setType(XProperty modelXProperty, XClass modelPropertyTypeXClass, String declaringClassName, ConverterDescriptor converterDescriptor) {
        Type explicitTypeAnn;
        boolean isArray = modelXProperty.isArray();
        if (modelPropertyTypeXClass == null && !isArray) {
            return;
        }
        if (this.columns == null) {
            throw new AssertionFailure("`BasicValueBinder#setColumns` should be called before `BasicValueBinder#setType`");
        }
        assert (this.columns.length == 1);
        XClass modelTypeXClass = isArray ? modelXProperty.getElementClass() : modelPropertyTypeXClass;
        Class modelJavaType = BasicValueBinder.resolveJavaType(modelTypeXClass, this.buildingContext);
        if (modelJavaType == null) {
            throw new IllegalStateException("BasicType requires Java type");
        }
        Class modelPropertyJavaType = this.buildingContext.getBootstrapContext().getReflectionManager().toClass(modelXProperty.getType());
        boolean isMap = Map.class.isAssignableFrom(modelPropertyJavaType);
        if (this.kind != Kind.LIST_INDEX && this.kind != Kind.MAP_KEY) {
            this.isLob = modelXProperty.isAnnotationPresent(Lob.class);
        }
        if (this.getDialect().getNationalizationSupport() == NationalizationSupport.EXPLICIT) {
            this.isNationalized = modelXProperty.isAnnotationPresent(Nationalized.class) || this.buildingContext.getBuildingOptions().useNationalizedCharacterData();
        }
        this.applyJpaConverter(modelXProperty, converterDescriptor);
        if (this.kind == Kind.MAP_KEY) {
            assert (isMap);
            MapKeyType mapKeyTypeAnn = (MapKeyType)modelXProperty.getAnnotation(MapKeyType.class);
            explicitTypeAnn = mapKeyTypeAnn != null ? mapKeyTypeAnn.value() : null;
        } else if (this.kind == Kind.COLLECTION_ID) {
            CollectionId collectionIdAnn = (CollectionId)modelXProperty.getAnnotation(CollectionId.class);
            assert (collectionIdAnn != null);
            explicitTypeAnn = collectionIdAnn.type();
        } else {
            explicitTypeAnn = (Type)modelXProperty.getAnnotation(Type.class);
        }
        if (explicitTypeAnn != null) {
            this.setExplicitType(explicitTypeAnn);
        } else {
            switch (this.kind) {
                case ATTRIBUTE: {
                    this.prepareBasicAttribute(declaringClassName, modelXProperty, modelPropertyTypeXClass);
                    break;
                }
                case COLLECTION_ID: {
                    this.prepareCollectionId(modelXProperty);
                    break;
                }
                case LIST_INDEX: {
                    this.prepareListIndex(modelXProperty);
                    break;
                }
                case MAP_KEY: {
                    this.prepareMapKey(modelXProperty, modelPropertyTypeXClass);
                    break;
                }
                case COLLECTION_ELEMENT: {
                    this.prepareCollectionElement(modelXProperty, modelPropertyTypeXClass);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected binder type : " + (Object)((Object)this.kind));
                }
            }
        }
    }

    private void prepareCollectionId(XProperty modelXProperty) {
        CollectionId collectionIdAnn = (CollectionId)modelXProperty.getAnnotation(CollectionId.class);
        if (collectionIdAnn == null) {
            throw new MappingException("idbag mapping missing @CollectionId");
        }
        this.explicitBasicTypeName = collectionIdAnn.type().type();
        this.implicitJavaTypeAccess = typeConfiguration -> null;
        String generator = collectionIdAnn.generator();
    }

    private void prepareMapKey(XProperty mapAttribute, XClass modelPropertyTypeXClass) {
        XClass mapKeyClass = modelPropertyTypeXClass == null ? mapAttribute.getMapKey() : modelPropertyTypeXClass;
        Class implicitJavaType = this.buildingContext.getBootstrapContext().getReflectionManager().toClass(mapKeyClass);
        this.implicitJavaTypeAccess = typeConfiguration -> implicitJavaType;
        MapKeyType mapKeyTypeAnn = (MapKeyType)mapAttribute.getAnnotation(MapKeyType.class);
        if (mapKeyTypeAnn != null) {
            throw new NotYetImplementedException("see comment at throw site");
        }
        MapKeyTemporal mapKeyTemporalAnn = (MapKeyTemporal)mapAttribute.getAnnotation(MapKeyTemporal.class);
        this.temporalPrecision = mapKeyTemporalAnn != null ? mapKeyTemporalAnn.value() : null;
        if (implicitJavaType.isEnum()) {
            MapKeyEnumerated enumeratedAnn = (MapKeyEnumerated)mapAttribute.getAnnotation(MapKeyEnumerated.class);
            if (enumeratedAnn == null) {
                this.enumType = EnumType.ORDINAL;
            } else {
                this.enumType = enumeratedAnn.value();
                if (this.enumType == null) {
                    throw new IllegalStateException("javax.persistence.EnumType was null on @javax.persistence.MapKeyEnumerated  associated with attribute " + mapAttribute.getDeclaringClass().getName() + '.' + mapAttribute.getName());
                }
            }
        } else {
            this.enumType = null;
        }
        this.mapKeySupplementalDetails(mapAttribute);
    }

    private void prepareListIndex(XProperty listAttribute) {
        this.implicitJavaTypeAccess = typeConfiguration -> Integer.class;
    }

    private void prepareCollectionElement(XProperty attributeXProperty, XClass elementTypeXClass) {
        Class javaType = elementTypeXClass == null && attributeXProperty.isArray() ? this.buildingContext.getBootstrapContext().getReflectionManager().toClass(attributeXProperty.getElementClass()) : this.buildingContext.getBootstrapContext().getReflectionManager().toClass(elementTypeXClass);
        this.implicitJavaTypeAccess = typeConfiguration -> javaType;
        Temporal temporalAnn = (Temporal)attributeXProperty.getAnnotation(Temporal.class);
        if (temporalAnn != null) {
            this.temporalPrecision = temporalAnn.value();
            if (this.temporalPrecision == null) {
                throw new IllegalStateException("No javax.persistence.TemporalType defined for @javax.persistence.Temporal associated with attribute " + attributeXProperty.getDeclaringClass().getName() + '.' + attributeXProperty.getName());
            }
        } else {
            this.temporalPrecision = null;
        }
        if (javaType.isEnum()) {
            Enumerated enumeratedAnn = (Enumerated)attributeXProperty.getAnnotation(Enumerated.class);
            if (enumeratedAnn == null) {
                this.enumType = EnumType.ORDINAL;
            } else {
                this.enumType = enumeratedAnn.value();
                if (this.enumType == null) {
                    throw new IllegalStateException("javax.persistence.EnumType was null on @javax.persistence.Enumerated  associated with attribute " + attributeXProperty.getDeclaringClass().getName() + '.' + attributeXProperty.getName());
                }
            }
        } else {
            this.enumType = null;
        }
        this.normalSupplementalDetails(attributeXProperty, this.buildingContext);
    }

    private void prepareBasicAttribute(String declaringClassName, XProperty attributeDescriptor, XClass attributeType) {
        Class javaType = this.buildingContext.getBootstrapContext().getReflectionManager().toClass(attributeType);
        this.implicitJavaTypeAccess = typeConfiguration -> javaType;
        Temporal temporalAnn = (Temporal)attributeDescriptor.getAnnotation(Temporal.class);
        if (temporalAnn != null) {
            this.temporalPrecision = temporalAnn.value();
            if (this.temporalPrecision == null) {
                throw new IllegalStateException("No javax.persistence.TemporalType defined for @javax.persistence.Temporal associated with attribute " + attributeDescriptor.getDeclaringClass().getName() + '.' + attributeDescriptor.getName());
            }
        } else {
            this.temporalPrecision = null;
        }
        if (javaType.isEnum()) {
            Enumerated enumeratedAnn = (Enumerated)attributeDescriptor.getAnnotation(Enumerated.class);
            if (enumeratedAnn == null) {
                this.enumType = EnumType.ORDINAL;
            } else {
                this.enumType = enumeratedAnn.value();
                if (this.enumType == null) {
                    throw new IllegalStateException("javax.persistence.EnumType was null on @javax.persistence.Enumerated  associated with attribute " + attributeDescriptor.getDeclaringClass().getName() + '.' + attributeDescriptor.getName());
                }
            }
        } else {
            if (attributeDescriptor.isAnnotationPresent(Enumerated.class)) {
                throw new AnnotationException(String.format("Attribute [%s.%s] was annotated as enumerated, but its java type is not an enum [%s]", declaringClassName, attributeDescriptor.getName(), attributeType.getName()));
            }
            this.enumType = null;
        }
        this.normalSupplementalDetails(attributeDescriptor, this.buildingContext);
    }

    private void mapKeySupplementalDetails(XProperty attributeXProperty) {
        MapKeyTemporal mapKeyTemporalAnn;
        MapKeyEnumerated mapKeyEnumeratedAnn = (MapKeyEnumerated)attributeXProperty.getAnnotation(MapKeyEnumerated.class);
        if (mapKeyEnumeratedAnn != null) {
            this.enumType = mapKeyEnumeratedAnn.value();
        }
        if ((mapKeyTemporalAnn = (MapKeyTemporal)attributeXProperty.getAnnotation(MapKeyTemporal.class)) != null) {
            this.temporalPrecision = mapKeyTemporalAnn.value();
        }
        this.explicitSqlTypeAccess = typeConfiguration -> {
            MapKeyJdbcType explicitDescriptorAnn = (MapKeyJdbcType)attributeXProperty.getAnnotation(MapKeyJdbcType.class);
            if (explicitDescriptorAnn != null) {
                JdbcType explicitStdAnn = explicitDescriptorAnn.value();
                Class<? extends JdbcTypeDescriptor> stdImplJavaType = explicitStdAnn.value();
                try {
                    return stdImplJavaType.newInstance();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new MappingException("Could not instantiate explicit SqlTypeDescriptor - " + stdImplJavaType.getName(), e);
                }
            }
            MapKeyJdbcTypeCode explicitCodeAnn = (MapKeyJdbcTypeCode)attributeXProperty.getAnnotation(MapKeyJdbcTypeCode.class);
            if (explicitCodeAnn != null) {
                JdbcTypeCode explicitSqlTypeAnn = explicitCodeAnn.value();
                return typeConfiguration.getJdbcTypeDescriptorRegistry().getDescriptor(explicitSqlTypeAnn.value());
            }
            return null;
        };
        this.explicitJtdAccess = typeConfiguration -> {
            MapKeyJavaType mapKeyJtdAnn = (MapKeyJavaType)attributeXProperty.getAnnotation(MapKeyJavaType.class);
            if (mapKeyJtdAnn == null) {
                return null;
            }
            JavaType jtdAnn = mapKeyJtdAnn.value();
            Class<BasicJavaDescriptor<?>> jtdJavaType = jtdAnn.value();
            try {
                return jtdJavaType.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new MappingException("Could not instantiate explicit JavaTypeDescriptor - " + jtdJavaType.getName(), e);
            }
        };
    }

    private void normalSupplementalDetails(XProperty attributeXProperty, MetadataBuildingContext buildingContext) {
        Temporal temporalAnn;
        this.explicitSqlTypeAccess = typeConfiguration -> {
            JdbcType explicitStdAnn = (JdbcType)attributeXProperty.getAnnotation(JdbcType.class);
            if (explicitStdAnn != null) {
                Class<? extends JdbcTypeDescriptor> stdImplJavaType = explicitStdAnn.value();
                try {
                    return stdImplJavaType.newInstance();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new MappingException("Could not instantiate explicit SqlTypeDescriptor - " + stdImplJavaType.getName(), e);
                }
            }
            JdbcTypeCode explicitSqlTypeAnn = (JdbcTypeCode)attributeXProperty.getAnnotation(JdbcTypeCode.class);
            if (explicitSqlTypeAnn != null) {
                return typeConfiguration.getJdbcTypeDescriptorRegistry().getDescriptor(explicitSqlTypeAnn.value());
            }
            return null;
        };
        this.explicitJtdAccess = typeConfiguration -> {
            JavaType explicitJtdAnn = (JavaType)attributeXProperty.getAnnotation(JavaType.class);
            if (explicitJtdAnn != null) {
                Class<BasicJavaDescriptor<?>> jtdImplJavaType = explicitJtdAnn.value();
                try {
                    return jtdImplJavaType.newInstance();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new MappingException("Could not instantiate explicit JavaTypeDescriptor - " + jtdImplJavaType.getName(), e);
                }
            }
            return null;
        };
        this.explicitMutabilityAccess = typeConfiguration -> {
            Mutability mutabilityAnn = (Mutability)attributeXProperty.getAnnotation(Mutability.class);
            if (mutabilityAnn != null) {
                Class<MutabilityPlan<?>> planJavaType = mutabilityAnn.value();
                try {
                    return planJavaType.newInstance();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new MappingException("Could not instantiate explicit MutabilityPlan - " + planJavaType.getName(), e);
                }
            }
            Immutable immutableAnn = (Immutable)attributeXProperty.getAnnotation(Immutable.class);
            if (immutableAnn != null) {
                return ImmutableMutabilityPlan.instance();
            }
            Class attributeType = ReflectHelper.getClass(this.implicitJavaTypeAccess.apply((TypeConfiguration)typeConfiguration));
            if (attributeType.isAnnotationPresent(Immutable.class)) {
                return ImmutableMutabilityPlan.instance();
            }
            if (this.converterDescriptor != null && this.converterDescriptor.getAttributeConverterClass().isAnnotationPresent(Immutable.class)) {
                return ImmutableMutabilityPlan.instance();
            }
            return null;
        };
        Enumerated enumeratedAnn = (Enumerated)attributeXProperty.getAnnotation(Enumerated.class);
        if (enumeratedAnn != null) {
            this.enumType = enumeratedAnn.value();
        }
        if ((temporalAnn = (Temporal)attributeXProperty.getAnnotation(Temporal.class)) != null) {
            this.temporalPrecision = temporalAnn.value();
        }
    }

    private static Class resolveJavaType(XClass returnedClassOrElement, MetadataBuildingContext buildingContext) {
        return buildingContext.getBootstrapContext().getReflectionManager().toClass(returnedClassOrElement);
    }

    private Dialect getDialect() {
        return this.buildingContext.getBuildingOptions().getServiceRegistry().getService(JdbcServices.class).getJdbcEnvironment().getDialect();
    }

    private void applyJpaConverter(XProperty property, ConverterDescriptor attributeConverterDescriptor) {
        if (attributeConverterDescriptor == null) {
            return;
        }
        LOG.debugf("Applying JPA converter [%s:%s]", this.persistentClassName, property.getName());
        if (property.isAnnotationPresent(Id.class)) {
            LOG.debugf("Skipping AttributeConverter checks for Id attribute [%s]", property.getName());
            return;
        }
        if (property.isAnnotationPresent(Version.class)) {
            LOG.debugf("Skipping AttributeConverter checks for version attribute [%s]", property.getName());
            return;
        }
        if (this.kind == Kind.MAP_KEY) {
            if (property.isAnnotationPresent(MapKeyTemporal.class)) {
                LOG.debugf("Skipping AttributeConverter checks for map-key annotated as MapKeyTemporal [%s]", property.getName());
                return;
            }
            if (property.isAnnotationPresent(MapKeyEnumerated.class)) {
                LOG.debugf("Skipping AttributeConverter checks for map-key annotated as MapKeyEnumerated [%s]", property.getName());
                return;
            }
        } else {
            if (property.isAnnotationPresent(Temporal.class)) {
                LOG.debugf("Skipping AttributeConverter checks for Temporal attribute [%s]", property.getName());
                return;
            }
            if (property.isAnnotationPresent(Enumerated.class)) {
                LOG.debugf("Skipping AttributeConverter checks for Enumerated attribute [%s]", property.getName());
                return;
            }
        }
        if (this.isAssociation()) {
            LOG.debugf("Skipping AttributeConverter checks for association attribute [%s]", property.getName());
            return;
        }
        this.converterDescriptor = attributeConverterDescriptor;
    }

    private boolean isAssociation() {
        return this.referencedEntityName != null;
    }

    public void setExplicitType(String explicitType) {
        this.explicitBasicTypeName = explicitType;
    }

    public void setExplicitType(Type typeAnn) {
        this.setExplicitType(typeAnn.type());
        this.explicitLocalTypeParams = this.extractTypeParams(typeAnn.parameters());
    }

    private Map extractTypeParams(Parameter[] parameters) {
        if (parameters == null || parameters.length == 0) {
            return Collections.emptyMap();
        }
        if (parameters.length == 1) {
            return Collections.singletonMap(parameters[0].name(), parameters[0].value());
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (Parameter parameter : parameters) {
            map.put(parameter.name(), parameter.value());
        }
        return map;
    }

    private void validate() {
        Ejb3Column.checkPropertyConsistency(this.columns, this.propertyName);
    }

    public BasicValue make() {
        if (this.basicValue != null) {
            return this.basicValue;
        }
        this.validate();
        LOG.debugf("building BasicValue for %s", this.propertyName);
        if (this.table == null) {
            this.table = this.columns[0].getTable();
        }
        this.basicValue = new BasicValue(this.buildingContext, this.table);
        if (this.isNationalized) {
            this.basicValue.makeNationalized();
        }
        if (this.isLob) {
            this.basicValue.makeLob();
        }
        if (this.enumType != null) {
            this.basicValue.setEnumerationStyle(this.enumType);
        }
        if (this.temporalPrecision != null) {
            this.basicValue.setTemporalPrecision(this.temporalPrecision);
        }
        this.linkWithValue();
        boolean isInSecondPass = this.buildingContext.getMetadataCollector().isInSecondPass();
        if (!isInSecondPass) {
            this.buildingContext.getMetadataCollector().addSecondPass(new SetBasicValueTypeSecondPass(this));
        } else {
            this.fillSimpleValue();
        }
        return this.basicValue;
    }

    public void linkWithValue() {
        if (this.columns[0].isNameDeferred() && !this.buildingContext.getMetadataCollector().isInSecondPass() && this.referencedEntityName != null) {
            this.buildingContext.getMetadataCollector().addSecondPass(new PkDrivenByDefaultMapsIdSecondPass(this.referencedEntityName, (Ejb3JoinColumn[])this.columns, this.basicValue));
        } else {
            for (Ejb3Column column : this.columns) {
                column.linkWithValue(this.basicValue);
            }
        }
    }

    public void fillSimpleValue() {
        LOG.debugf("Starting `BasicValueBinder#fillSimpleValue` for %s", this.propertyName);
        this.basicValue.setExplicitTypeName(this.explicitBasicTypeName);
        this.basicValue.setExplicitTypeParams(this.explicitLocalTypeParams);
        this.basicValue.setJpaAttributeConverterDescriptor(this.converterDescriptor);
        this.basicValue.setImplicitJavaTypeAccess(this.implicitJavaTypeAccess);
        this.basicValue.setExplicitJavaTypeAccess(this.explicitJtdAccess);
        this.basicValue.setExplicitMutabilityPlanAccess(this.explicitMutabilityAccess);
        this.basicValue.setExplicitSqlTypeAccess(this.explicitSqlTypeAccess);
        if (this.enumType != null) {
            this.basicValue.setEnumerationStyle(this.enumType);
        }
        if (this.temporalPrecision != null) {
            this.basicValue.setTemporalPrecision(this.temporalPrecision);
        }
        if (this.isLob) {
            this.basicValue.makeLob();
        }
        if (this.isNationalized) {
            this.basicValue.makeNationalized();
        }
    }

    public static enum Kind {
        ATTRIBUTE,
        COLLECTION_ID,
        COLLECTION_ELEMENT,
        LIST_INDEX,
        MAP_KEY;

    }
}

