/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.annotations;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.SqlResultSetMapping;
import org.hibernate.MappingException;
import org.hibernate.boot.query.SqlResultSetMappingDescriptor;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.cfg.QuerySecondPass;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.Value;

public class ResultsetMappingSecondPass
implements QuerySecondPass {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(ResultsetMappingSecondPass.class);
    private final SqlResultSetMapping ann;
    private final MetadataBuildingContext context;
    private final boolean isDefault;

    public ResultsetMappingSecondPass(SqlResultSetMapping ann, MetadataBuildingContext context, boolean isDefault) {
        this.ann = ann;
        this.context = context;
        this.isDefault = isDefault;
    }

    @Override
    public void doSecondPass(Map persistentClasses) throws MappingException {
        if (this.ann == null) {
            return;
        }
        SqlResultSetMappingDescriptor mappingDefinition = SqlResultSetMappingDescriptor.from(this.ann, this.context);
        if (this.isDefault) {
            this.context.getMetadataCollector().addDefaultResultSetMapping(mappingDefinition);
        } else {
            this.context.getMetadataCollector().addResultSetMapping(mappingDefinition);
        }
    }

    private String normalizeColumnQuoting(String name) {
        return this.context.getMetadataCollector().getDatabase().toIdentifier(name).render();
    }

    private List<String> getFollowers(Iterator parentPropIter, String reducedName, String name) {
        boolean hasFollowers = false;
        ArrayList<String> followers = new ArrayList<String>();
        while (parentPropIter.hasNext()) {
            String currentPropertyName = ((Property)parentPropIter.next()).getName();
            String currentName = reducedName + '.' + currentPropertyName;
            if (hasFollowers) {
                followers.add(currentName);
            }
            if (!name.equals(currentName)) continue;
            hasFollowers = true;
        }
        return followers;
    }

    private Iterator getSubPropertyIterator(PersistentClass pc, String reducedName) {
        Iterator<Property> parentPropIter;
        Value value = pc.getRecursiveProperty(reducedName).getValue();
        if (value instanceof Component) {
            Component comp = (Component)value;
            parentPropIter = comp.getPropertyIterator();
        } else if (value instanceof ToOne) {
            ToOne toOne = (ToOne)value;
            PersistentClass referencedPc = this.context.getMetadataCollector().getEntityBinding(toOne.getReferencedEntityName());
            if (toOne.getReferencedPropertyName() != null) {
                try {
                    parentPropIter = ((Component)referencedPc.getRecursiveProperty(toOne.getReferencedPropertyName()).getValue()).getPropertyIterator();
                }
                catch (ClassCastException e) {
                    throw new MappingException("dotted notation references neither a component nor a many/one to one", e);
                }
            } else {
                try {
                    if (referencedPc.getIdentifierMapper() == null) {
                        parentPropIter = ((Component)referencedPc.getIdentifierProperty().getValue()).getPropertyIterator();
                    }
                    parentPropIter = referencedPc.getIdentifierMapper().getPropertyIterator();
                }
                catch (ClassCastException e) {
                    throw new MappingException("dotted notation references neither a component nor a many/one to one", e);
                }
            }
        } else {
            throw new MappingException("dotted notation references neither a component nor a many/one to one");
        }
        return parentPropIter;
    }

    private static int getIndexOfFirstMatchingProperty(List propertyNames, String follower) {
        int propertySize = propertyNames.size();
        for (int propIndex = 0; propIndex < propertySize; ++propIndex) {
            if (!((String)propertyNames.get(propIndex)).startsWith(follower)) continue;
            return propIndex;
        }
        return -1;
    }
}

