/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import javax.persistence.TemporalType;
import org.hibernate.HibernateException;
import org.hibernate.dialect.CUBRIDSqlAstTranslator;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.OracleDialect;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.identity.CUBRIDIdentityColumnSupport;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.pagination.LimitLimitHandler;
import org.hibernate.dialect.sequence.CUBRIDSequenceSupport;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.SemanticException;
import org.hibernate.query.TemporalUnit;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.tool.schema.extract.internal.SequenceInformationExtractorCUBRIDDatabaseImpl;
import org.hibernate.tool.schema.extract.spi.SequenceInformationExtractor;
import org.hibernate.type.descriptor.jdbc.JdbcTypeDescriptor;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeDescriptorRegistry;

public class CUBRIDDialect
extends Dialect {
    public CUBRIDDialect() {
        this.registerColumnType(16, "bit");
        this.registerColumnType(-6, "smallint");
        this.registerColumnType(93, "datetime");
        this.registerColumnType(93, "datetimetz");
        this.registerColumnType(-2, "bit($l)");
        this.registerColumnType(-3, "bit varying($l)");
        this.getDefaultProperties().setProperty("hibernate.jdbc.use_streams_for_binary", "true");
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", "15");
        this.registerKeyword("TYPE");
        this.registerKeyword("YEAR");
        this.registerKeyword("MONTH");
        this.registerKeyword("ALIAS");
        this.registerKeyword("VALUE");
        this.registerKeyword("FIRST");
        this.registerKeyword("ROLE");
        this.registerKeyword("CLASS");
        this.registerKeyword("BIT");
        this.registerKeyword("TIME");
        this.registerKeyword("QUERY");
        this.registerKeyword("DATE");
        this.registerKeyword("USER");
        this.registerKeyword("ACTION");
        this.registerKeyword("SYS_USER");
        this.registerKeyword("ZONE");
        this.registerKeyword("LANGUAGE");
        this.registerKeyword("DICTIONARY");
        this.registerKeyword("DATA");
        this.registerKeyword("TEST");
        this.registerKeyword("SUPERCLASS");
        this.registerKeyword("SECTION");
        this.registerKeyword("LOWER");
        this.registerKeyword("LIST");
        this.registerKeyword("OID");
        this.registerKeyword("DAY");
        this.registerKeyword("IF");
        this.registerKeyword("ATTRIBUTE");
        this.registerKeyword("STRING");
        this.registerKeyword("SEARCH");
    }

    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    public JdbcTypeDescriptor resolveSqlTypeDescriptor(int jdbcTypeCode, int precision, int scale, JdbcTypeDescriptorRegistry jdbcTypeDescriptorRegistry) {
        if (jdbcTypeCode == -7) {
            return jdbcTypeDescriptorRegistry.getDescriptor(16);
        }
        return super.resolveSqlTypeDescriptor(jdbcTypeCode, precision, scale, jdbcTypeDescriptorRegistry);
    }

    @Override
    public int getPreferredSqlTypeCodeForBoolean() {
        return -7;
    }

    @Override
    public int getDefaultTimestampPrecision() {
        return 3;
    }

    @Override
    public String getTypeName(int code, Size size) throws HibernateException {
        return super.getTypeName(code, CUBRIDDialect.binaryToDecimalPrecision(code, size));
    }

    @Override
    public int getFloatPrecision() {
        return 21;
    }

    @Override
    public void initializeFunctionRegistry(QueryEngine queryEngine) {
        super.initializeFunctionRegistry(queryEngine);
        CommonFunctionFactory.trim2(queryEngine);
        CommonFunctionFactory.space(queryEngine);
        CommonFunctionFactory.reverse(queryEngine);
        CommonFunctionFactory.repeat(queryEngine);
        CommonFunctionFactory.crc32(queryEngine);
        CommonFunctionFactory.cot(queryEngine);
        CommonFunctionFactory.log2(queryEngine);
        CommonFunctionFactory.log10(queryEngine);
        CommonFunctionFactory.pi(queryEngine);
        CommonFunctionFactory.radians(queryEngine);
        CommonFunctionFactory.degrees(queryEngine);
        CommonFunctionFactory.systimestamp(queryEngine);
        CommonFunctionFactory.localtimeLocaltimestamp(queryEngine);
        CommonFunctionFactory.hourMinuteSecond(queryEngine);
        CommonFunctionFactory.yearMonthDay(queryEngine);
        CommonFunctionFactory.dayofweekmonthyear(queryEngine);
        CommonFunctionFactory.lastDay(queryEngine);
        CommonFunctionFactory.weekQuarter(queryEngine);
        CommonFunctionFactory.octetLength(queryEngine);
        CommonFunctionFactory.md5(queryEngine);
        CommonFunctionFactory.trunc(queryEngine);
        CommonFunctionFactory.truncate(queryEngine);
        CommonFunctionFactory.toCharNumberDateTimestamp(queryEngine);
        CommonFunctionFactory.substr(queryEngine);
        CommonFunctionFactory.instr(queryEngine);
        CommonFunctionFactory.translate(queryEngine);
        CommonFunctionFactory.ceiling_ceil(queryEngine);
        CommonFunctionFactory.sha1(queryEngine);
        CommonFunctionFactory.sha2(queryEngine);
        CommonFunctionFactory.ascii(queryEngine);
        CommonFunctionFactory.char_chr(queryEngine);
        CommonFunctionFactory.position(queryEngine);
        CommonFunctionFactory.insert(queryEngine);
        CommonFunctionFactory.nowCurdateCurtime(queryEngine);
        CommonFunctionFactory.makedateMaketime(queryEngine);
        CommonFunctionFactory.bitandorxornot_bitAndOrXorNot(queryEngine);
        CommonFunctionFactory.median(queryEngine);
        CommonFunctionFactory.stddev(queryEngine);
        CommonFunctionFactory.stddevPopSamp(queryEngine);
        CommonFunctionFactory.variance(queryEngine);
        CommonFunctionFactory.varPopSamp(queryEngine);
        CommonFunctionFactory.datediff(queryEngine);
        CommonFunctionFactory.adddateSubdateAddtimeSubtime(queryEngine);
        CommonFunctionFactory.addMonths(queryEngine);
        CommonFunctionFactory.monthsBetween(queryEngine);
        CommonFunctionFactory.rownumInstOrderbyGroupbyNum(queryEngine);
    }

    @Override
    public boolean supportsColumnCheck() {
        return false;
    }

    @Override
    public SequenceSupport getSequenceSupport() {
        return CUBRIDSequenceSupport.INSTANCE;
    }

    @Override
    public String getDropForeignKeyString() {
        return " drop foreign key ";
    }

    @Override
    public boolean qualifyIndexName() {
        return false;
    }

    @Override
    public boolean supportsExistsInSelect() {
        return false;
    }

    @Override
    public String getQuerySequencesString() {
        return "select * from db_serial";
    }

    @Override
    public SequenceInformationExtractor getSequenceInformationExtractor() {
        return SequenceInformationExtractorCUBRIDDatabaseImpl.INSTANCE;
    }

    @Override
    public String getFromDual() {
        return "from db_root";
    }

    @Override
    public boolean supportsSelectQueryWithoutFromClause() {
        return false;
    }

    @Override
    public char openQuote() {
        return '[';
    }

    @Override
    public char closeQuote() {
        return ']';
    }

    @Override
    public String getForUpdateString() {
        return "";
    }

    @Override
    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    @Override
    public String getCurrentTimestampSelectString() {
        return "select now()";
    }

    @Override
    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    @Override
    public boolean supportsEmptyInList() {
        return false;
    }

    @Override
    public boolean supportsIfExistsBeforeTableName() {
        return true;
    }

    @Override
    public boolean supportsTupleDistinctCounts() {
        return false;
    }

    @Override
    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            @Override
            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
                return new CUBRIDSqlAstTranslator(sessionFactory, statement);
            }
        };
    }

    @Override
    public LimitHandler getLimitHandler() {
        return LimitLimitHandler.INSTANCE;
    }

    @Override
    public IdentityColumnSupport getIdentityColumnSupport() {
        return new CUBRIDIdentityColumnSupport();
    }

    @Override
    public boolean supportsPartitionBy() {
        return true;
    }

    @Override
    public String translateDatetimeFormat(String format) {
        return OracleDialect.datetimeFormat(format, true, false).replace("SSSSSS", "FF").replace("SSSSS", "FF").replace("SSSS", "FF").replace("SSS", "FF").replace("SS", "FF").replace("S", "FF").result();
    }

    @Override
    public long getFractionalSecondPrecisionInNanos() {
        return 1000000L;
    }

    @Override
    public String extractPattern(TemporalUnit unit) {
        switch (unit) {
            case SECOND: {
                return "(second(?2)+extract(millisecond from ?2)/1e3)";
            }
            case DAY_OF_WEEK: {
                return "dayofweek(?2)";
            }
            case DAY_OF_MONTH: {
                return "dayofmonth(?2)";
            }
            case DAY_OF_YEAR: {
                return "dayofyear(?2)";
            }
            case WEEK: {
                return "week(?2,3)";
            }
        }
        return "?1(?2)";
    }

    @Override
    public boolean supportsTimezoneTypes() {
        return true;
    }

    @Override
    public String timestampaddPattern(TemporalUnit unit, TemporalType temporalType) {
        switch (unit) {
            case NANOSECOND: {
                return "adddate(?3, interval (?2)/1e6 millisecond)";
            }
            case NATIVE: {
                return "adddate(?3, interval ?2 millisecond)";
            }
        }
        return "adddate(?3, interval ?2 ?1)";
    }

    @Override
    public String timestampdiffPattern(TemporalUnit unit, TemporalType fromTemporalType, TemporalType toTemporalType) {
        StringBuilder pattern = new StringBuilder();
        switch (unit) {
            case DAY: {
                return "datediff(?3,?2)";
            }
            case HOUR: {
                this.timediff(pattern, TemporalUnit.HOUR, unit);
                break;
            }
            case MINUTE: {
                pattern.append("(");
                this.timediff(pattern, TemporalUnit.MINUTE, unit);
                pattern.append("+");
                this.timediff(pattern, TemporalUnit.HOUR, unit);
                pattern.append(")");
                break;
            }
            case SECOND: {
                pattern.append("(");
                this.timediff(pattern, TemporalUnit.SECOND, unit);
                pattern.append("+");
                this.timediff(pattern, TemporalUnit.MINUTE, unit);
                pattern.append("+");
                this.timediff(pattern, TemporalUnit.HOUR, unit);
                pattern.append(")");
                break;
            }
            case NANOSECOND: 
            case NATIVE: {
                pattern.append("(");
                this.timediff(pattern, unit, unit);
                pattern.append("+");
                this.timediff(pattern, TemporalUnit.SECOND, unit);
                pattern.append("+");
                this.timediff(pattern, TemporalUnit.MINUTE, unit);
                pattern.append("+");
                this.timediff(pattern, TemporalUnit.HOUR, unit);
                pattern.append(")");
                break;
            }
            default: {
                throw new SemanticException("unsupported temporal unit for CUBRID: " + (Object)((Object)unit));
            }
        }
        return pattern.toString();
    }

    private void timediff(StringBuilder sqlAppender, TemporalUnit diffUnit, TemporalUnit toUnit) {
        if (diffUnit == TemporalUnit.NANOSECOND) {
            sqlAppender.append("1e6*");
        }
        sqlAppender.append("extract(");
        if (diffUnit == TemporalUnit.NANOSECOND || diffUnit == TemporalUnit.NATIVE) {
            sqlAppender.append("millisecond");
        } else {
            sqlAppender.append("?1");
        }
        sqlAppender.append(",timediff(?3,?2))");
        sqlAppender.append(diffUnit.conversionFactor(toUnit, this));
    }
}

