/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.collections.Stack;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.query.ComparisonOperator;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.spi.AbstractSqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.cte.CteStatement;
import org.hibernate.sql.ast.tree.expression.CastTarget;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.FunctionExpression;
import org.hibernate.sql.ast.tree.expression.JdbcLiteral;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.sql.ast.tree.expression.QueryLiteral;
import org.hibernate.sql.ast.tree.expression.SelfRenderingExpression;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.expression.Summarization;
import org.hibernate.sql.ast.tree.predicate.SelfRenderingPredicate;
import org.hibernate.sql.ast.tree.select.QueryGroup;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectClause;
import org.hibernate.sql.exec.spi.JdbcOperation;

public class FirebirdSqlAstTranslator<T extends JdbcOperation>
extends AbstractSqlAstTranslator<T> {
    private boolean inFunction;

    public FirebirdSqlAstTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
        super(sessionFactory, statement);
    }

    protected boolean shouldEmulateFetchClause(QueryPart queryPart) {
        return this.useOffsetFetchClause(queryPart) && this.getQueryPartForRowNumbering() != queryPart && this.getDialect().getVersion() >= 300 && !this.isRowsOnlyFetchClauseType(queryPart);
    }

    @Override
    public void visitQueryGroup(QueryGroup queryGroup) {
        if (this.shouldEmulateFetchClause(queryGroup)) {
            this.emulateFetchOffsetWithWindowFunctions(queryGroup, true);
        } else {
            super.visitQueryGroup(queryGroup);
        }
    }

    @Override
    public void visitQuerySpec(QuerySpec querySpec) {
        if (this.shouldEmulateFetchClause(querySpec)) {
            this.emulateFetchOffsetWithWindowFunctions(querySpec, true);
        } else {
            super.visitQuerySpec(querySpec);
        }
    }

    @Override
    public void visitSelectClause(SelectClause selectClause) {
        Stack<Clause> clauseStack = this.getClauseStack();
        clauseStack.push(Clause.SELECT);
        try {
            this.appendSql("select ");
            this.visitSqlSelections(selectClause);
        }
        finally {
            clauseStack.pop();
        }
    }

    @Override
    protected void visitSqlSelections(SelectClause selectClause) {
        if (!this.supportsOffsetFetchClause()) {
            this.renderFirstSkipClause((QuerySpec)this.getQueryPartStack().getCurrent());
        }
        if (selectClause.isDistinct()) {
            this.appendSql("distinct ");
        }
        super.visitSqlSelections(selectClause);
    }

    @Override
    public void visitOffsetFetchClause(QueryPart queryPart) {
        if (this.supportsOffsetFetchClause() && !this.isRowNumberingCurrentQueryPart()) {
            this.renderOffsetFetchClause(queryPart, true);
        }
    }

    @Override
    protected void renderSearchClause(CteStatement cte) {
    }

    @Override
    protected void renderCycleClause(CteStatement cte) {
    }

    @Override
    protected boolean supportsSimpleQueryGrouping() {
        return false;
    }

    @Override
    protected void renderSelectExpression(Expression expression) {
        this.renderSelectExpressionWithCastedOrInlinedPlainParameters(expression);
    }

    @Override
    protected void renderSelectTupleComparison(List<SqlSelection> lhsExpressions, SqlTuple tuple, ComparisonOperator operator) {
        this.emulateTupleComparison(lhsExpressions, tuple.getExpressions(), operator, true);
    }

    @Override
    protected void renderPartitionItem(Expression expression) {
        if (expression instanceof Literal) {
            this.appendSql("'0' || '0'");
        } else {
            if (expression instanceof Summarization) {
                throw new UnsupportedOperationException("Summarization is not supported by DBMS!");
            }
            expression.accept(this);
        }
    }

    @Override
    protected boolean supportsRowValueConstructorSyntax() {
        return false;
    }

    @Override
    protected boolean supportsRowValueConstructorSyntaxInInList() {
        return false;
    }

    @Override
    protected boolean supportsRowValueConstructorSyntaxInQuantifiedPredicates() {
        return false;
    }

    @Override
    protected String getFromDual() {
        return " from rdb$database";
    }

    @Override
    protected String getFromDualForSelectOnly() {
        return this.getFromDual();
    }

    private boolean supportsOffsetFetchClause() {
        return this.getDialect().getVersion() >= 300;
    }

    @Override
    public void visitSelfRenderingPredicate(SelfRenderingPredicate selfRenderingPredicate) {
        boolean inFunction = this.inFunction;
        this.inFunction = true;
        try {
            super.visitSelfRenderingPredicate(selfRenderingPredicate);
        }
        finally {
            this.inFunction = inFunction;
        }
    }

    @Override
    public void visitSelfRenderingExpression(SelfRenderingExpression expression) {
        boolean inFunction = this.inFunction;
        this.inFunction = !(expression instanceof FunctionExpression) || !"cast".equals(((FunctionExpression)((Object)expression)).getFunctionName());
        try {
            super.visitSelfRenderingExpression(expression);
        }
        finally {
            this.inFunction = inFunction;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitParameter(JdbcParameter jdbcParameter) {
        if (this.inFunction) {
            this.inFunction = false;
            try {
                JdbcMapping jdbcMapping = jdbcParameter.getExpressionType().getJdbcMappings().get(0);
                ArrayList<SqlAstNode> arguments = new ArrayList<SqlAstNode>(2);
                arguments.add(jdbcParameter);
                arguments.add(new CastTarget(jdbcMapping));
                this.castFunction().render(this, arguments, this);
            }
            finally {
                this.inFunction = true;
            }
        } else {
            super.visitParameter(jdbcParameter);
        }
    }

    @Override
    public void visitJdbcLiteral(JdbcLiteral jdbcLiteral) {
        this.visitLiteral(jdbcLiteral);
    }

    @Override
    public void visitQueryLiteral(QueryLiteral queryLiteral) {
        this.visitLiteral(queryLiteral);
    }

    private void visitLiteral(Literal literal) {
        if (literal.getLiteralValue() == null) {
            this.appendSql("null");
        } else {
            this.renderLiteral(literal, this.inFunction);
        }
    }
}

