/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import javax.persistence.TemporalType;
import org.hibernate.HibernateException;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.MimerSQLSqlAstTranslator;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.pagination.OffsetFetchLimitHandler;
import org.hibernate.dialect.sequence.MimerSequenceSupport;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.SemanticException;
import org.hibernate.query.TemporalUnit;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.tool.schema.extract.internal.SequenceInformationExtractorMimerSQLDatabaseImpl;
import org.hibernate.tool.schema.extract.spi.SequenceInformationExtractor;

public class MimerSQLDialect
extends Dialect {
    public MimerSQLDialect() {
        this.registerColumnType(-6, "integer(3)");
        this.registerColumnType(1, "nchar($l)");
        this.registerColumnType(12, 5000L, "nvarchar($l)");
        this.registerColumnType(12, "nclob($l)");
        this.registerColumnType(-9, 5000L, "nvarchar($l)");
        this.registerColumnType(-9, "nclob($l)");
        this.registerColumnType(-3, 15000L, "varbinary($l)");
        this.registerColumnType(-3, "blob($l)");
        this.registerColumnType(2004, "blob($l)");
        this.registerColumnType(2005, "nclob($l)");
        this.registerColumnType(2011, "nclob($l)");
        this.registerColumnType(2014, "timestamp($p)");
        this.getDefaultProperties().setProperty("hibernate.jdbc.use_streams_for_binary", "true");
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", "50");
    }

    @Override
    public String getTypeName(int code, Size size) throws HibernateException {
        return super.getTypeName(code, MimerSQLDialect.binaryToDecimalPrecision(code, size));
    }

    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    public void initializeFunctionRegistry(QueryEngine queryEngine) {
        super.initializeFunctionRegistry(queryEngine);
        CommonFunctionFactory.soundex(queryEngine);
        CommonFunctionFactory.octetLength(queryEngine);
        CommonFunctionFactory.truncate(queryEngine);
        CommonFunctionFactory.repeat(queryEngine);
        CommonFunctionFactory.pad_repeat(queryEngine);
        CommonFunctionFactory.dayofweekmonthyear(queryEngine);
        CommonFunctionFactory.concat_pipeOperator(queryEngine);
        CommonFunctionFactory.position(queryEngine);
        CommonFunctionFactory.localtimeLocaltimestamp(queryEngine);
    }

    @Override
    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            @Override
            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
                return new MimerSQLSqlAstTranslator(sessionFactory, statement);
            }
        };
    }

    @Override
    public String currentTimestamp() {
        return "localtimestamp";
    }

    @Override
    public String currentTime() {
        return "localtime";
    }

    @Override
    public String extractPattern(TemporalUnit unit) {
        switch (unit) {
            case WEEK: {
                return "week(?2)";
            }
            case DAY_OF_WEEK: {
                return "dayofweek(?2)";
            }
            case DAY_OF_YEAR: {
                return "dayofyear(?2)";
            }
            case DAY_OF_MONTH: {
                return "day(?2)";
            }
        }
        return super.extractPattern(unit);
    }

    @Override
    public String timestampdiffPattern(TemporalUnit unit, TemporalType fromTemporalType, TemporalType toTemporalType) {
        StringBuilder pattern = new StringBuilder();
        pattern.append("cast((?3 - ?2) ");
        switch (unit) {
            case NATIVE: 
            case NANOSECOND: 
            case SECOND: {
                pattern.append("second(12,9)");
                break;
            }
            case MINUTE: {
                pattern.append("minute(10)");
                break;
            }
            case HOUR: {
                pattern.append("hour(8)");
                break;
            }
            case WEEK: 
            case DAY: {
                pattern.append("day(7)");
                break;
            }
            case MONTH: 
            case QUARTER: {
                pattern.append("month(7)");
                break;
            }
            case YEAR: {
                pattern.append("year(7)");
                break;
            }
            default: {
                throw new SemanticException("unsupported duration unit: " + (Object)((Object)unit));
            }
        }
        pattern.append(" as bigint)");
        switch (unit) {
            case WEEK: {
                pattern.append("/7");
                break;
            }
            case QUARTER: {
                pattern.append("/3");
                break;
            }
            case NATIVE: 
            case NANOSECOND: {
                pattern.append("*1e9");
            }
        }
        return pattern.toString();
    }

    @Override
    public String timestampaddPattern(TemporalUnit unit, TemporalType temporalType) {
        switch (unit) {
            case NATIVE: 
            case NANOSECOND: {
                return "(?3 + (?2)/1e9 * interval '1' second)";
            }
            case QUARTER: {
                return "(?3 + (?2) * interval '3' month)";
            }
            case WEEK: {
                return "(?3 + (?2) * interval '7' day)";
            }
        }
        return "(?3 + (?2) * interval '1' ?1)";
    }

    @Override
    public boolean dropConstraints() {
        return false;
    }

    @Override
    public String getCascadeConstraintsString() {
        return " cascade";
    }

    @Override
    public SequenceSupport getSequenceSupport() {
        return MimerSequenceSupport.INSTANCE;
    }

    @Override
    public String getQuerySequencesString() {
        return "select * from information_schema.ext_sequences";
    }

    @Override
    public SequenceInformationExtractor getSequenceInformationExtractor() {
        return SequenceInformationExtractorMimerSQLDatabaseImpl.INSTANCE;
    }

    @Override
    public LimitHandler getLimitHandler() {
        return OffsetFetchLimitHandler.INSTANCE;
    }

    @Override
    public String getFromDual() {
        return "from (values(0))";
    }

    @Override
    public boolean supportsSelectQueryWithoutFromClause() {
        return false;
    }

    @Override
    public boolean supportsOuterJoinForUpdate() {
        return false;
    }

    @Override
    public String translateDatetimeFormat(String format) {
        throw new NotYetImplementedFor6Exception("format() function not supported on Mimer SQL");
    }

    @Override
    public boolean useInputStreamToInsertBlob() {
        return false;
    }
}

