/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.util.List;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.collections.Stack;
import org.hibernate.query.ComparisonOperator;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.spi.AbstractSqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.expression.CaseSearchedExpression;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.expression.Summarization;
import org.hibernate.sql.ast.tree.insert.Values;
import org.hibernate.sql.ast.tree.select.QueryGroup;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectClause;
import org.hibernate.sql.exec.spi.JdbcOperation;

public class OracleSqlAstTranslator<T extends JdbcOperation>
extends AbstractSqlAstTranslator<T> {
    public OracleSqlAstTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
        super(sessionFactory, statement);
    }

    protected boolean shouldEmulateFetchClause(QueryPart queryPart) {
        return this.getQueryPartForRowNumbering() != queryPart && !this.supportsOffsetFetchClause() && (queryPart.isRoot() && this.hasLimit() || queryPart.getFetchClauseExpression() != null || queryPart.getOffsetClauseExpression() != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void visitValuesList(List<Values> valuesList) {
        if (valuesList.size() < 2) {
            super.visitValuesList(valuesList);
        } else {
            String separator = "";
            Stack<Clause> clauseStack = this.getClauseStack();
            try {
                clauseStack.push(Clause.VALUES);
                for (Values values : valuesList) {
                    this.appendSql(separator);
                    this.renderExpressionsAsSubquery(values.getExpressions());
                    separator = " union all ";
                }
            }
            finally {
                clauseStack.pop();
            }
        }
    }

    @Override
    public void visitQueryGroup(QueryGroup queryGroup) {
        if (this.shouldEmulateFetchClause(queryGroup)) {
            this.emulateFetchOffsetWithWindowFunctions(queryGroup, true);
        } else {
            super.visitQueryGroup(queryGroup);
        }
    }

    @Override
    public void visitQuerySpec(QuerySpec querySpec) {
        if (this.shouldEmulateFetchClause(querySpec)) {
            this.emulateFetchOffsetWithWindowFunctions(querySpec, true);
        } else {
            super.visitQuerySpec(querySpec);
        }
    }

    @Override
    public void visitOffsetFetchClause(QueryPart queryPart) {
        if (!this.isRowNumberingCurrentQueryPart()) {
            if (this.supportsOffsetFetchClause()) {
                this.renderOffsetFetchClause(queryPart, true);
            } else {
                this.assertRowsOnlyFetchClauseType(queryPart);
            }
        }
    }

    @Override
    protected void renderRowNumber(SelectClause selectClause, QueryPart queryPart) {
        if (this.supportsOffsetFetchClause() || selectClause.isDistinct()) {
            super.renderRowNumber(selectClause, queryPart);
        } else {
            this.appendSql("rownum");
        }
    }

    @Override
    protected void renderComparison(Expression lhs, ComparisonOperator operator, Expression rhs) {
        this.renderComparisonEmulateDecode(lhs, operator, rhs);
    }

    @Override
    protected void renderSelectTupleComparison(List<SqlSelection> lhsExpressions, SqlTuple tuple, ComparisonOperator operator) {
        this.emulateTupleComparison(lhsExpressions, tuple.getExpressions(), operator, true);
    }

    @Override
    protected void visitCaseSearchedExpression(CaseSearchedExpression caseSearchedExpression, boolean inSelect) {
        if (this.getDialect().getVersion() < 900) {
            this.visitDecodeCaseSearchedExpression(caseSearchedExpression);
        } else {
            this.visitAnsiCaseSearchedExpression(caseSearchedExpression);
        }
    }

    @Override
    protected void renderPartitionItem(Expression expression) {
        if (expression instanceof Literal) {
            this.appendSql("()");
        } else if (expression instanceof Summarization) {
            Summarization summarization = (Summarization)expression;
            this.appendSql(summarization.getKind().name().toLowerCase());
            this.appendSql("(");
            this.renderCommaSeparated(summarization.getGroupings());
            this.appendSql(")");
        } else {
            expression.accept(this);
        }
    }

    @Override
    protected boolean supportsRowValueConstructorSyntax() {
        return false;
    }

    @Override
    protected boolean supportsRowValueConstructorSyntaxInInList() {
        return this.getDialect().getVersion() >= 820;
    }

    @Override
    protected boolean supportsRowValueConstructorSyntaxInQuantifiedPredicates() {
        return false;
    }

    @Override
    protected boolean supportsRowValueConstructorSyntaxInInSubQuery() {
        return this.getDialect().getVersion() >= 900;
    }

    @Override
    protected String getFromDual() {
        return " from dual";
    }

    @Override
    protected String getFromDualForSelectOnly() {
        return this.getFromDual();
    }

    private boolean supportsOffsetFetchClause() {
        return this.getDialect().getVersion() >= 1200;
    }
}

