/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.dialect.PostgreSQLDialect;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.query.spi.QueryEngine;

public class PostgresPlusDialect
extends PostgreSQLDialect {
    public PostgresPlusDialect() {
    }

    public PostgresPlusDialect(DialectResolutionInfo info) {
        super(info);
    }

    public PostgresPlusDialect(int version) {
        super(version);
    }

    @Override
    public void initializeFunctionRegistry(QueryEngine queryEngine) {
        super.initializeFunctionRegistry(queryEngine);
        CommonFunctionFactory.soundex(queryEngine);
        CommonFunctionFactory.rownumRowid(queryEngine);
        CommonFunctionFactory.sysdate(queryEngine);
        CommonFunctionFactory.systimestamp(queryEngine);
    }

    @Override
    public String getCurrentTimestampSelectString() {
        return "select sysdate";
    }

    @Override
    public String getCurrentTimestampSQLFunctionName() {
        return "sysdate";
    }

    @Override
    public int registerResultSetOutParameter(CallableStatement statement, int col) throws SQLException {
        statement.registerOutParameter(col, 2006);
        return ++col;
    }

    @Override
    public ResultSet getResultSet(CallableStatement ps) throws SQLException {
        ps.execute();
        return (ResultSet)ps.getObject(1);
    }

    @Override
    public String getSelectGUIDString() {
        return "select uuid_generate_v1";
    }
}

