/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.util.Map;
import org.hibernate.LockOptions;
import org.hibernate.dialect.SybaseASESqlAstTranslator;
import org.hibernate.dialect.SybaseDialect;
import org.hibernate.dialect.function.QuantifiedLeastGreatestEmulation;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.pagination.TopLimitHandler;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.exception.LockTimeoutException;
import org.hibernate.exception.spi.SQLExceptionConversionDelegate;
import org.hibernate.internal.util.JdbcExceptionHelper;
import org.hibernate.query.TrimSpec;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.sql.ForUpdateFragment;
import org.hibernate.sql.JoinFragment;
import org.hibernate.sql.Sybase11JoinFragment;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.type.descriptor.jdbc.JdbcTypeDescriptor;
import org.hibernate.type.descriptor.jdbc.TinyIntTypeDescriptor;

public class SybaseASEDialect
extends SybaseDialect {
    public SybaseASEDialect(DialectResolutionInfo info) {
        this(info.getDatabaseMajorVersion() * 100 + info.getDatabaseMinorVersion() * 10);
    }

    public SybaseASEDialect() {
        this(1100);
    }

    public SybaseASEDialect(int version) {
        super(version);
        this.registerColumnType(16, "tinyint");
        if (this.getVersion() >= 1500) {
            this.registerColumnType(-5, "bigint");
        }
        if (this.getVersion() >= 1200) {
            this.registerColumnType(91, "date");
            this.registerColumnType(92, "time");
        }
        this.registerColumnType(-4, "image");
        this.registerColumnType(-1, "text");
        this.registerSybaseKeywords();
    }

    @Override
    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            @Override
            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
                return new SybaseASESqlAstTranslator(sessionFactory, statement);
            }
        };
    }

    @Override
    public boolean supportsBitType() {
        return false;
    }

    @Override
    protected JdbcTypeDescriptor getSqlTypeDescriptorOverride(int sqlCode) {
        return sqlCode == 16 ? TinyIntTypeDescriptor.INSTANCE : super.getSqlTypeDescriptorOverride(sqlCode);
    }

    @Override
    public String currentDate() {
        return "current_date()";
    }

    @Override
    public String currentTime() {
        return "current_time()";
    }

    @Override
    public String currentTimestamp() {
        return "current_bigdatetime()";
    }

    private void registerSybaseKeywords() {
        this.registerKeyword("add");
        this.registerKeyword("all");
        this.registerKeyword("alter");
        this.registerKeyword("and");
        this.registerKeyword("any");
        this.registerKeyword("arith_overflow");
        this.registerKeyword("as");
        this.registerKeyword("asc");
        this.registerKeyword("at");
        this.registerKeyword("authorization");
        this.registerKeyword("avg");
        this.registerKeyword("begin");
        this.registerKeyword("between");
        this.registerKeyword("break");
        this.registerKeyword("browse");
        this.registerKeyword("bulk");
        this.registerKeyword("by");
        this.registerKeyword("cascade");
        this.registerKeyword("case");
        this.registerKeyword("char_convert");
        this.registerKeyword("check");
        this.registerKeyword("checkpoint");
        this.registerKeyword("close");
        this.registerKeyword("clustered");
        this.registerKeyword("coalesce");
        this.registerKeyword("commit");
        this.registerKeyword("compute");
        this.registerKeyword("confirm");
        this.registerKeyword("connect");
        this.registerKeyword("constraint");
        this.registerKeyword("continue");
        this.registerKeyword("controlrow");
        this.registerKeyword("convert");
        this.registerKeyword("count");
        this.registerKeyword("count_big");
        this.registerKeyword("create");
        this.registerKeyword("current");
        this.registerKeyword("cursor");
        this.registerKeyword("database");
        this.registerKeyword("dbcc");
        this.registerKeyword("deallocate");
        this.registerKeyword("declare");
        this.registerKeyword("decrypt");
        this.registerKeyword("default");
        this.registerKeyword("delete");
        this.registerKeyword("desc");
        this.registerKeyword("determnistic");
        this.registerKeyword("disk");
        this.registerKeyword("distinct");
        this.registerKeyword("drop");
        this.registerKeyword("dummy");
        this.registerKeyword("dump");
        this.registerKeyword("else");
        this.registerKeyword("encrypt");
        this.registerKeyword("end");
        this.registerKeyword("endtran");
        this.registerKeyword("errlvl");
        this.registerKeyword("errordata");
        this.registerKeyword("errorexit");
        this.registerKeyword("escape");
        this.registerKeyword("except");
        this.registerKeyword("exclusive");
        this.registerKeyword("exec");
        this.registerKeyword("execute");
        this.registerKeyword("exist");
        this.registerKeyword("exit");
        this.registerKeyword("exp_row_size");
        this.registerKeyword("external");
        this.registerKeyword("fetch");
        this.registerKeyword("fillfactor");
        this.registerKeyword("for");
        this.registerKeyword("foreign");
        this.registerKeyword("from");
        this.registerKeyword("goto");
        this.registerKeyword("grant");
        this.registerKeyword("group");
        this.registerKeyword("having");
        this.registerKeyword("holdlock");
        this.registerKeyword("identity");
        this.registerKeyword("identity_gap");
        this.registerKeyword("identity_start");
        this.registerKeyword("if");
        this.registerKeyword("in");
        this.registerKeyword("index");
        this.registerKeyword("inout");
        this.registerKeyword("insensitive");
        this.registerKeyword("insert");
        this.registerKeyword("install");
        this.registerKeyword("intersect");
        this.registerKeyword("into");
        this.registerKeyword("is");
        this.registerKeyword("isolation");
        this.registerKeyword("jar");
        this.registerKeyword("join");
        this.registerKeyword("key");
        this.registerKeyword("kill");
        this.registerKeyword("level");
        this.registerKeyword("like");
        this.registerKeyword("lineno");
        this.registerKeyword("load");
        this.registerKeyword("lock");
        this.registerKeyword("materialized");
        this.registerKeyword("max");
        this.registerKeyword("max_rows_per_page");
        this.registerKeyword("min");
        this.registerKeyword("mirror");
        this.registerKeyword("mirrorexit");
        this.registerKeyword("modify");
        this.registerKeyword("national");
        this.registerKeyword("new");
        this.registerKeyword("noholdlock");
        this.registerKeyword("nonclustered");
        this.registerKeyword("nonscrollable");
        this.registerKeyword("non_sensitive");
        this.registerKeyword("not");
        this.registerKeyword("null");
        this.registerKeyword("nullif");
        this.registerKeyword("numeric_truncation");
        this.registerKeyword("of");
        this.registerKeyword("off");
        this.registerKeyword("offsets");
        this.registerKeyword("on");
        this.registerKeyword("once");
        this.registerKeyword("online");
        this.registerKeyword("only");
        this.registerKeyword("open");
        this.registerKeyword("option");
        this.registerKeyword("or");
        this.registerKeyword("order");
        this.registerKeyword("out");
        this.registerKeyword("output");
        this.registerKeyword("over");
        this.registerKeyword("artition");
        this.registerKeyword("perm");
        this.registerKeyword("permanent");
        this.registerKeyword("plan");
        this.registerKeyword("prepare");
        this.registerKeyword("primary");
        this.registerKeyword("print");
        this.registerKeyword("privileges");
        this.registerKeyword("proc");
        this.registerKeyword("procedure");
        this.registerKeyword("processexit");
        this.registerKeyword("proxy_table");
        this.registerKeyword("public");
        this.registerKeyword("quiesce");
        this.registerKeyword("raiserror");
        this.registerKeyword("read");
        this.registerKeyword("readpast");
        this.registerKeyword("readtext");
        this.registerKeyword("reconfigure");
        this.registerKeyword("references");
        this.registerKeyword("remove");
        this.registerKeyword("reorg");
        this.registerKeyword("replace");
        this.registerKeyword("replication");
        this.registerKeyword("reservepagegap");
        this.registerKeyword("return");
        this.registerKeyword("returns");
        this.registerKeyword("revoke");
        this.registerKeyword("role");
        this.registerKeyword("rollback");
        this.registerKeyword("rowcount");
        this.registerKeyword("rows");
        this.registerKeyword("rule");
        this.registerKeyword("save");
        this.registerKeyword("schema");
        this.registerKeyword("scroll");
        this.registerKeyword("scrollable");
        this.registerKeyword("select");
        this.registerKeyword("semi_sensitive");
        this.registerKeyword("set");
        this.registerKeyword("setuser");
        this.registerKeyword("shared");
        this.registerKeyword("shutdown");
        this.registerKeyword("some");
        this.registerKeyword("statistics");
        this.registerKeyword("stringsize");
        this.registerKeyword("stripe");
        this.registerKeyword("sum");
        this.registerKeyword("syb_identity");
        this.registerKeyword("syb_restree");
        this.registerKeyword("syb_terminate");
        this.registerKeyword("top");
        this.registerKeyword("table");
        this.registerKeyword("temp");
        this.registerKeyword("temporary");
        this.registerKeyword("textsize");
        this.registerKeyword("to");
        this.registerKeyword("tracefile");
        this.registerKeyword("tran");
        this.registerKeyword("transaction");
        this.registerKeyword("trigger");
        this.registerKeyword("truncate");
        this.registerKeyword("tsequal");
        this.registerKeyword("union");
        this.registerKeyword("unique");
        this.registerKeyword("unpartition");
        this.registerKeyword("update");
        this.registerKeyword("use");
        this.registerKeyword("user");
        this.registerKeyword("user_option");
        this.registerKeyword("using");
        this.registerKeyword("values");
        this.registerKeyword("varying");
        this.registerKeyword("view");
        this.registerKeyword("waitfor");
        this.registerKeyword("when");
        this.registerKeyword("where");
        this.registerKeyword("while");
        this.registerKeyword("with");
        this.registerKeyword("work");
        this.registerKeyword("writetext");
        this.registerKeyword("xmlextract");
        this.registerKeyword("xmlparse");
        this.registerKeyword("xmltest");
        this.registerKeyword("xmlvalidate");
    }

    @Override
    public void initializeFunctionRegistry(QueryEngine queryEngine) {
        super.initializeFunctionRegistry(queryEngine);
        queryEngine.getSqmFunctionRegistry().register("least", new QuantifiedLeastGreatestEmulation(true));
        queryEngine.getSqmFunctionRegistry().register("greatest", new QuantifiedLeastGreatestEmulation(false));
    }

    @Override
    public JoinFragment createOuterJoinFragment() {
        return this.getVersion() < 1400 ? new Sybase11JoinFragment() : super.createOuterJoinFragment();
    }

    @Override
    public boolean supportsCascadeDelete() {
        return false;
    }

    @Override
    public int getMaxAliasLength() {
        return 30;
    }

    @Override
    public boolean areStringComparisonsCaseInsensitive() {
        return true;
    }

    @Override
    public String getCurrentTimestampSQLFunctionName() {
        return "getdate()";
    }

    @Override
    public String getCrossJoinSeparator() {
        return ", ";
    }

    @Override
    public boolean supportsLockTimeouts() {
        return false;
    }

    @Override
    public String getTableTypeString() {
        return this.getVersion() < 1570 ? super.getTableTypeString() : " lock datarows";
    }

    @Override
    public boolean supportsExpectedLobUsagePattern() {
        return this.getVersion() >= 1570;
    }

    @Override
    public boolean supportsLobValueChangePropagation() {
        return false;
    }

    @Override
    public boolean forUpdateOfColumns() {
        return this.getVersion() >= 1570;
    }

    @Override
    public String getForUpdateString() {
        return this.getVersion() < 1570 ? super.getForUpdateString() : " for update";
    }

    @Override
    public String getForUpdateString(String aliases) {
        return this.getVersion() < 1570 ? super.getForUpdateString(aliases) : this.getForUpdateString() + " of " + aliases;
    }

    @Override
    public String appendLockHint(LockOptions mode, String tableName) {
        return this.getVersion() < 1570 ? super.appendLockHint(mode, tableName) : tableName;
    }

    @Override
    public String applyLocksToSql(String sql, LockOptions aliasedLockOptions, Map<String, String[]> keyColumnNames) {
        return this.getVersion() < 1570 ? super.applyLocksToSql(sql, aliasedLockOptions, (Map)keyColumnNames) : sql + new ForUpdateFragment(this, aliasedLockOptions, keyColumnNames).toFragmentString();
    }

    @Override
    public SQLExceptionConversionDelegate buildSQLExceptionConversionDelegate() {
        if (this.getVersion() < 1570) {
            return null;
        }
        return (sqlException, message, sql) -> {
            String sqlState = JdbcExceptionHelper.extractSqlState(sqlException);
            int errorCode = JdbcExceptionHelper.extractErrorCode(sqlException);
            switch (sqlState) {
                case "JZ0TO": 
                case "JZ006": {
                    throw new LockTimeoutException(message, sqlException, sql);
                }
                case "ZZZZZ": {
                    if (515 != errorCode) break;
                    String constraintName = this.getViolatedConstraintNameExtractor().extractConstraintName(sqlException);
                    return new ConstraintViolationException(message, sqlException, sql, constraintName);
                }
            }
            return null;
        };
    }

    @Override
    public LimitHandler getLimitHandler() {
        if (this.getVersion() < 1250) {
            return super.getLimitHandler();
        }
        return new TopLimitHandler(false);
    }

    @Override
    public String trimPattern(TrimSpec specification, char character) {
        return super.trimPattern(specification, character).replace("replace", "str_replace");
    }
}

