/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import org.hibernate.dialect.GroupByConstantRenderingStrategy;
import org.hibernate.dialect.SybaseAnywhereSqlAstTranslator;
import org.hibernate.dialect.SybaseDialect;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.identity.SybaseAnywhereIdentityColumnSupport;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.pagination.TopLimitHandler;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.exec.spi.JdbcOperation;

public class SybaseAnywhereDialect
extends SybaseDialect {
    public SybaseAnywhereDialect() {
        this(8);
    }

    public SybaseAnywhereDialect(DialectResolutionInfo info) {
        this(info.getDatabaseMajorVersion() * 100 + info.getDatabaseMinorVersion() * 10);
    }

    public SybaseAnywhereDialect(int version) {
        super(version);
        this.registerColumnType(-5, "bigint");
        this.registerColumnType(91, "date");
        this.registerColumnType(92, "time");
        this.registerColumnType(93, "timestamp");
        this.registerColumnType(2014, "timestamp with time zone");
        int maxStringLength = Short.MAX_VALUE;
        this.registerColumnType(1, 32767L, "char($l)");
        this.registerColumnType(12, 32767L, "varchar($l)");
        this.registerColumnType(12, "long varchar)");
        this.registerColumnType(-15, 32767L, "nchar($l)");
        this.registerColumnType(-9, 32767L, "nvarchar($l)");
        this.registerColumnType(-9, "long nvarchar)");
        this.registerColumnType(-2, 32767L, "binary($l)");
        this.registerColumnType(-3, 32767L, "varbinary($l)");
        this.registerColumnType(-3, "long binary)");
    }

    @Override
    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            @Override
            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
                return new SybaseAnywhereSqlAstTranslator(sessionFactory, statement);
            }
        };
    }

    @Override
    public boolean supportsTimezoneTypes() {
        return true;
    }

    @Override
    public String currentDate() {
        return "current date";
    }

    @Override
    public String currentTime() {
        return "current time";
    }

    @Override
    public String currentTimestamp() {
        return "current timestamp";
    }

    @Override
    public String getNoColumnsInsertString() {
        return "values (default)";
    }

    @Override
    public boolean dropConstraints() {
        return false;
    }

    @Override
    public String getFromDual() {
        return "from sys.dummy";
    }

    @Override
    public boolean supportsSelectQueryWithoutFromClause() {
        return false;
    }

    @Override
    public IdentityColumnSupport getIdentityColumnSupport() {
        return new SybaseAnywhereIdentityColumnSupport();
    }

    @Override
    public LimitHandler getLimitHandler() {
        return TopLimitHandler.INSTANCE;
    }

    @Override
    public GroupByConstantRenderingStrategy getGroupByConstantRenderingStrategy() {
        return GroupByConstantRenderingStrategy.EMPTY_GROUPING;
    }
}

