/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.util.List;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.ComparisonOperator;
import org.hibernate.sql.ast.spi.AbstractSqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.cte.CteStatement;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.expression.Summarization;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectClause;
import org.hibernate.sql.exec.spi.JdbcOperation;

public class SybaseAnywhereSqlAstTranslator<T extends JdbcOperation>
extends AbstractSqlAstTranslator<T> {
    public SybaseAnywhereSqlAstTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
        super(sessionFactory, statement);
    }

    @Override
    protected boolean needsRowsToSkip() {
        return this.getDialect().getVersion() < 900;
    }

    @Override
    protected void renderFetchPlusOffsetExpression(Expression fetchClauseExpression, Expression offsetClauseExpression, int offset) {
        this.renderFetchPlusOffsetExpressionAsSingleParameter(fetchClauseExpression, offsetClauseExpression, offset);
    }

    @Override
    protected void visitSqlSelections(SelectClause selectClause) {
        if (this.getDialect().getVersion() < 900) {
            this.renderTopClause((QuerySpec)this.getQueryPartStack().getCurrent(), true);
        } else {
            this.renderTopStartAtClause((QuerySpec)this.getQueryPartStack().getCurrent());
        }
        super.visitSqlSelections(selectClause);
    }

    @Override
    protected void renderTopClause(QuerySpec querySpec, boolean addOffset) {
        this.assertRowsOnlyFetchClauseType(querySpec);
        super.renderTopClause(querySpec, addOffset);
    }

    @Override
    protected void renderTopStartAtClause(QuerySpec querySpec) {
        this.assertRowsOnlyFetchClauseType(querySpec);
        super.renderTopStartAtClause(querySpec);
    }

    @Override
    public void visitOffsetFetchClause(QueryPart queryPart) {
        if (this.getDialect().getVersion() < 900 && !queryPart.isRoot() && this.useOffsetFetchClause(queryPart) && queryPart.getOffsetClauseExpression() != null) {
            throw new IllegalArgumentException("Can't emulate offset clause in subquery");
        }
    }

    @Override
    protected void renderSearchClause(CteStatement cte) {
    }

    @Override
    protected void renderCycleClause(CteStatement cte) {
    }

    @Override
    protected void renderComparison(Expression lhs, ComparisonOperator operator, Expression rhs) {
        this.renderComparisonEmulateIntersect(lhs, operator, rhs);
    }

    @Override
    protected void renderSelectTupleComparison(List<SqlSelection> lhsExpressions, SqlTuple tuple, ComparisonOperator operator) {
        this.emulateTupleComparison(lhsExpressions, tuple.getExpressions(), operator, true);
    }

    @Override
    protected void renderPartitionItem(Expression expression) {
        if (expression instanceof Literal) {
            this.appendSql("()");
        } else {
            if (expression instanceof Summarization) {
                throw new UnsupportedOperationException("Summarization is not supported by DBMS!");
            }
            expression.accept(this);
        }
    }

    @Override
    protected boolean supportsRowValueConstructorSyntax() {
        return false;
    }

    @Override
    protected boolean supportsRowValueConstructorSyntaxInInList() {
        return false;
    }

    @Override
    protected boolean supportsRowValueConstructorSyntaxInQuantifiedPredicates() {
        return false;
    }

    @Override
    protected String getFromDual() {
        return " from sys.dummy";
    }

    @Override
    protected String getFromDualForSelectOnly() {
        return this.getFromDual();
    }
}

