/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.pagination;

import java.util.regex.Matcher;
import org.hibernate.dialect.pagination.AbstractLimitHandler;
import org.hibernate.engine.spi.RowSelection;
import org.hibernate.query.Limit;

public class LegacyOracleLimitHandler
extends AbstractLimitHandler {
    private final int version;

    public LegacyOracleLimitHandler(int version) {
        this.version = version;
    }

    @Override
    public String processSql(String sql, RowSelection selection) {
        boolean hasOffset = LegacyOracleLimitHandler.hasFirstRow(selection);
        sql = sql.trim();
        String forUpdateClause = null;
        Matcher forUpdateMatcher = this.getForUpdatePattern().matcher(sql);
        if (forUpdateMatcher.find()) {
            int forUpdateIndex = forUpdateMatcher.start();
            forUpdateClause = sql.substring(forUpdateIndex);
            sql = sql.substring(0, forUpdateIndex);
        }
        StringBuilder pagingSelect = new StringBuilder(sql.length() + 100);
        if (hasOffset) {
            pagingSelect.append("select * from (select row_.*, rownum rownum_ from (").append(sql);
            if (this.version < 900) {
                pagingSelect.append(") row_) where rownum_ <= ? and rownum_ > ?");
            } else {
                pagingSelect.append(") row_ where rownum <= ?) where rownum_ > ?");
            }
        } else {
            pagingSelect.append("select * from (").append(sql).append(") where rownum <= ?");
        }
        if (forUpdateClause != null) {
            pagingSelect.append(forUpdateClause);
        }
        return pagingSelect.toString();
    }

    @Override
    public String processSql(String sql, Limit limit) {
        boolean hasOffset = LegacyOracleLimitHandler.hasFirstRow(limit);
        sql = sql.trim();
        String forUpdateClause = null;
        Matcher forUpdateMatcher = this.getForUpdatePattern().matcher(sql);
        if (forUpdateMatcher.find()) {
            int forUpdateIndex = forUpdateMatcher.start();
            forUpdateClause = sql.substring(forUpdateIndex);
            sql = sql.substring(0, forUpdateIndex);
        }
        StringBuilder pagingSelect = new StringBuilder(sql.length() + 100);
        if (hasOffset) {
            pagingSelect.append("select * from (select row_.*, rownum rownum_ from (").append(sql);
            if (this.version < 900) {
                pagingSelect.append(") row_) where rownum_ <= ? and rownum_ > ?");
            } else {
                pagingSelect.append(") row_ where rownum <= ?) where rownum_ > ?");
            }
        } else {
            pagingSelect.append("select * from (").append(sql).append(") where rownum <= ?");
        }
        if (forUpdateClause != null) {
            pagingSelect.append(forUpdateClause);
        }
        return pagingSelect.toString();
    }

    @Override
    public boolean supportsLimit() {
        return true;
    }

    @Override
    public boolean bindLimitParametersInReverseOrder() {
        return true;
    }

    @Override
    public boolean useMaxForLimit() {
        return true;
    }
}

