/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import org.hibernate.HibernateException;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.AbstractScrollableResults;
import org.hibernate.sql.results.internal.RowProcessingStateStandardImpl;
import org.hibernate.sql.results.jdbc.internal.JdbcValuesSourceProcessingStateStandardImpl;
import org.hibernate.sql.results.jdbc.spi.JdbcValues;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesSourceProcessingOptions;
import org.hibernate.sql.results.spi.RowReader;

public class ScrollableResultsImpl<R>
extends AbstractScrollableResults<R> {
    private R currentRow;

    public ScrollableResultsImpl(JdbcValues jdbcValues, JdbcValuesSourceProcessingOptions processingOptions, JdbcValuesSourceProcessingStateStandardImpl jdbcValuesSourceProcessingState, RowProcessingStateStandardImpl rowProcessingState, RowReader<R> rowReader, SharedSessionContractImplementor persistenceContext) {
        super(jdbcValues, processingOptions, jdbcValuesSourceProcessingState, rowProcessingState, rowReader, persistenceContext);
    }

    @Override
    protected R getCurrentRow() {
        return this.currentRow;
    }

    @Override
    public boolean next() {
        boolean result = this.getRowProcessingState().next();
        this.prepareCurrentRow(result);
        return result;
    }

    @Override
    public boolean previous() {
        boolean result = this.getRowProcessingState().previous();
        this.prepareCurrentRow(result);
        return result;
    }

    @Override
    public boolean scroll(int i) {
        boolean hasResult = this.getRowProcessingState().scroll(i);
        this.prepareCurrentRow(hasResult);
        return hasResult;
    }

    @Override
    public boolean position(int position) {
        boolean hasResult = this.getRowProcessingState().position(position);
        this.prepareCurrentRow(hasResult);
        return hasResult;
    }

    @Override
    public boolean first() {
        boolean hasResult = this.getRowProcessingState().first();
        this.prepareCurrentRow(hasResult);
        return hasResult;
    }

    @Override
    public boolean last() {
        boolean hasResult = this.getRowProcessingState().last();
        this.prepareCurrentRow(hasResult);
        return hasResult;
    }

    @Override
    public void afterLast() {
        throw new NotYetImplementedFor6Exception();
    }

    @Override
    public void beforeFirst() {
        throw new NotYetImplementedFor6Exception();
    }

    @Override
    public boolean isFirst() {
        throw new NotYetImplementedFor6Exception();
    }

    @Override
    public boolean isLast() {
        throw new NotYetImplementedFor6Exception();
    }

    @Override
    public int getRowNumber() throws HibernateException {
        return this.getRowProcessingState().getPosition();
    }

    @Override
    public boolean setRowNumber(int rowNumber) throws HibernateException {
        return this.position(rowNumber);
    }

    private void prepareCurrentRow(boolean underlyingScrollSuccessful) {
        if (!underlyingScrollSuccessful) {
            this.currentRow = null;
            return;
        }
        this.currentRow = this.getRowReader().readRow(this.getRowProcessingState(), this.getProcessingOptions());
        this.afterScrollOperation();
    }
}

