/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.ast.internal;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.CollectionKey;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.loader.ast.internal.LoaderSelectBuilder;
import org.hibernate.loader.ast.internal.SingleIdLoadPlan;
import org.hibernate.loader.ast.spi.CollectionLoader;
import org.hibernate.loader.ast.spi.Loadable;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.spi.Callback;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcSelect;
import org.hibernate.sql.results.internal.RowTransformerPassThruImpl;
import org.jboss.logging.Logger;

public class CollectionLoaderBatchKey
implements CollectionLoader {
    private static final Logger log = Logger.getLogger(CollectionLoaderBatchKey.class);
    private final PluralAttributeMapping attributeMapping;
    private final int batchSize;
    private final int keyJdbcCount;
    private SelectStatement batchSizeSqlAst;
    private List<JdbcParameter> batchSizeJdbcParameters;

    public CollectionLoaderBatchKey(PluralAttributeMapping attributeMapping, int batchSize, LoadQueryInfluencers influencers, SessionFactoryImplementor sessionFactory) {
        this.attributeMapping = attributeMapping;
        this.batchSize = batchSize;
        this.keyJdbcCount = attributeMapping.getKeyDescriptor().getJdbcTypeCount();
        this.batchSizeJdbcParameters = new ArrayList<JdbcParameter>();
        this.batchSizeSqlAst = LoaderSelectBuilder.createSelect((Loadable)attributeMapping, null, attributeMapping.getKeyDescriptor(), null, batchSize, influencers, LockOptions.READ, this.batchSizeJdbcParameters::add, sessionFactory);
    }

    @Override
    public PluralAttributeMapping getLoadable() {
        return this.attributeMapping;
    }

    @Override
    public PersistentCollection load(Object key, SharedSessionContractImplementor session) {
        Object[] batchIds = session.getPersistenceContextInternal().getBatchFetchQueue().getCollectionBatch(this.getLoadable().getCollectionDescriptor(), key, this.batchSize);
        int numberOfIds = ArrayHelper.countNonNull(batchIds);
        if (numberOfIds == 1) {
            ArrayList<JdbcParameter> jdbcParameters = new ArrayList<JdbcParameter>(this.keyJdbcCount);
            SelectStatement sqlAst = LoaderSelectBuilder.createSelect((Loadable)this.attributeMapping, null, this.attributeMapping.getKeyDescriptor(), null, this.batchSize, session.getLoadQueryInfluencers(), LockOptions.READ, jdbcParameters::add, session.getFactory());
            new SingleIdLoadPlan(this.attributeMapping.getKeyDescriptor(), sqlAst, jdbcParameters).load(key, LockOptions.READ, session);
        } else {
            this.batchLoad(batchIds, session);
        }
        CollectionKey collectionKey = new CollectionKey(this.attributeMapping.getCollectionDescriptor(), key);
        return session.getPersistenceContext().getCollection(collectionKey);
    }

    private void batchLoad(Object[] batchIds, final SharedSessionContractImplementor session) {
        if (log.isDebugEnabled()) {
            log.debugf("Batch loading collection [%s] : %s", (Object)this.getLoadable().getCollectionDescriptor().getRole(), (Object)batchIds);
        }
        int smallBatchStart = 0;
        int smallBatchLength = Math.min(batchIds.length, this.batchSize);
        while (true) {
            SelectStatement sqlAst;
            List<JdbcParameter> jdbcParameters;
            if (smallBatchLength == this.batchSize) {
                jdbcParameters = this.batchSizeJdbcParameters;
                sqlAst = this.batchSizeSqlAst;
            } else {
                jdbcParameters = new ArrayList<JdbcParameter>();
                sqlAst = LoaderSelectBuilder.createSelect((Loadable)this.getLoadable(), null, this.getLoadable().getKeyDescriptor(), null, batchIds.length, session.getLoadQueryInfluencers(), LockOptions.READ, jdbcParameters::add, session.getFactory());
            }
            SessionFactoryImplementor sessionFactory = session.getFactory();
            JdbcServices jdbcServices = sessionFactory.getJdbcServices();
            JdbcEnvironment jdbcEnvironment = jdbcServices.getJdbcEnvironment();
            SqlAstTranslatorFactory sqlAstTranslatorFactory = jdbcEnvironment.getSqlAstTranslatorFactory();
            JdbcSelect jdbcSelect = sqlAstTranslatorFactory.buildSelectTranslator(sessionFactory, sqlAst).translate(null, QueryOptions.NONE);
            JdbcParameterBindingsImpl jdbcParameterBindings = new JdbcParameterBindingsImpl(this.keyJdbcCount * smallBatchLength);
            jdbcSelect.bindFilterJdbcParameters(jdbcParameterBindings);
            int offset = 0;
            for (int i = smallBatchStart; i < smallBatchStart + smallBatchLength; ++i) {
                offset += jdbcParameterBindings.registerParametersForEachJdbcValue(batchIds[i], Clause.WHERE, offset, this.getLoadable().getKeyDescriptor(), jdbcParameters, session);
                jdbcServices.getJdbcSelectExecutor().list(jdbcSelect, jdbcParameterBindings, new ExecutionContext(){

                    @Override
                    public SharedSessionContractImplementor getSession() {
                        return session;
                    }

                    @Override
                    public QueryOptions getQueryOptions() {
                        return QueryOptions.NONE;
                    }

                    @Override
                    public QueryParameterBindings getQueryParameterBindings() {
                        return QueryParameterBindings.NO_PARAM_BINDINGS;
                    }

                    @Override
                    public Callback getCallback() {
                        return null;
                    }
                }, RowTransformerPassThruImpl.instance(), true);
            }
            assert (offset == jdbcParameters.size());
            if ((smallBatchStart += smallBatchLength) >= batchIds.length) break;
            smallBatchLength = Math.min(batchIds.length - smallBatchStart, this.batchSize);
        }
    }
}

