/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.ast.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.loader.ast.internal.LoaderSqlAstCreationState;
import org.hibernate.metamodel.mapping.EntityAssociationMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.SingularAttributeMapping;
import org.hibernate.query.ComparisonOperator;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.sqm.sql.FromClauseIndex;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.SqlAliasBaseManager;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.expression.QueryLiteral;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.internal.JdbcParameterImpl;
import org.hibernate.sql.exec.internal.JdbcSelectExecutorStandardImpl;
import org.hibernate.sql.exec.spi.Callback;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcSelect;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.sql.results.internal.RowTransformerDatabaseSnapshotImpl;
import org.hibernate.type.IntegerType;
import org.jboss.logging.Logger;

class DatabaseSnapshotExecutor {
    private static final Logger log = Logger.getLogger(DatabaseSnapshotExecutor.class);
    private final EntityMappingType entityDescriptor;
    private final JdbcSelect jdbcSelect;
    private final List<JdbcParameter> jdbcParameters;

    DatabaseSnapshotExecutor(EntityMappingType entityDescriptor, SessionFactoryImplementor sessionFactory) {
        this.entityDescriptor = entityDescriptor;
        this.jdbcParameters = new ArrayList<JdbcParameter>(entityDescriptor.getIdentifierMapping().getJdbcTypeCount());
        QuerySpec rootQuerySpec = new QuerySpec(true);
        SqlAliasBaseManager sqlAliasBaseManager = new SqlAliasBaseManager();
        LoaderSqlAstCreationState state = new LoaderSqlAstCreationState(rootQuerySpec, sqlAliasBaseManager, new FromClauseIndex(null), LockOptions.READ, (fetchParent, ast, creationState) -> Collections.emptyList(), true, sessionFactory);
        NavigablePath rootPath = new NavigablePath(entityDescriptor.getEntityName());
        TableGroup rootTableGroup = entityDescriptor.createRootTableGroup(rootPath, null, LockMode.NONE, () -> rootQuerySpec::applyPredicate, state, sessionFactory);
        rootQuerySpec.getFromClause().addRoot(rootTableGroup);
        state.getFromClauseAccess().registerTableGroup(rootPath, rootTableGroup);
        ArrayList domainResults = new ArrayList();
        SqlExpressionResolver sqlExpressionResolver = state.getSqlExpressionResolver();
        domainResults.add(new QueryLiteral<Object>(null, IntegerType.INSTANCE).createDomainResult(null, state));
        NavigablePath idNavigablePath = rootPath.append(entityDescriptor.getIdentifierMapping().getNavigableRole().getNavigableName());
        entityDescriptor.getIdentifierMapping().forEachSelectable((columnIndex, selection) -> {
            TableReference tableReference = rootTableGroup.resolveTableReference(idNavigablePath, selection.getContainingTableExpression());
            JdbcParameterImpl jdbcParameter = new JdbcParameterImpl(selection.getJdbcMapping());
            this.jdbcParameters.add(jdbcParameter);
            ColumnReference columnReference = (ColumnReference)sqlExpressionResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableReference, selection.getSelectionExpression()), s -> new ColumnReference(tableReference, selection, sessionFactory));
            rootQuerySpec.applyPredicate(new ComparisonPredicate(columnReference, ComparisonOperator.EQUAL, jdbcParameter));
        });
        entityDescriptor.visitStateArrayContributors(contributorMapping -> {
            NavigablePath navigablePath = rootPath.append(contributorMapping.getAttributeName());
            if (contributorMapping instanceof SingularAttributeMapping) {
                if (contributorMapping instanceof EntityAssociationMapping) {
                    domainResults.add(((EntityAssociationMapping)((Object)contributorMapping)).createDelayedDomainResult(navigablePath, rootTableGroup, null, state));
                } else {
                    domainResults.add(contributorMapping.createDomainResult(navigablePath, rootTableGroup, null, state));
                }
            } else {
                domainResults.add(new BasicResult(0, null, contributorMapping.getJavaTypeDescriptor()));
            }
        });
        SelectStatement selectStatement = new SelectStatement(rootQuerySpec, domainResults);
        JdbcServices jdbcServices = sessionFactory.getJdbcServices();
        JdbcEnvironment jdbcEnvironment = jdbcServices.getJdbcEnvironment();
        SqlAstTranslatorFactory sqlAstTranslatorFactory = jdbcEnvironment.getSqlAstTranslatorFactory();
        this.jdbcSelect = sqlAstTranslatorFactory.buildSelectTranslator(sessionFactory, selectStatement).translate(null, QueryOptions.NONE);
    }

    Object[] loadDatabaseSnapshot(Object id, final SharedSessionContractImplementor session) {
        if (log.isTraceEnabled()) {
            log.tracef("Getting current persistent state for `%s#%s`", (Object)this.entityDescriptor.getEntityName(), id);
        }
        JdbcParameterBindingsImpl jdbcParameterBindings = new JdbcParameterBindingsImpl(this.entityDescriptor.getIdentifierMapping().getJdbcTypeCount());
        int offset = jdbcParameterBindings.registerParametersForEachJdbcValue(id, Clause.WHERE, this.entityDescriptor.getIdentifierMapping(), this.jdbcParameters, session);
        assert (offset == this.jdbcParameters.size());
        List list = JdbcSelectExecutorStandardImpl.INSTANCE.list(this.jdbcSelect, jdbcParameterBindings, new ExecutionContext(){

            @Override
            public SharedSessionContractImplementor getSession() {
                return session;
            }

            @Override
            public QueryOptions getQueryOptions() {
                return QueryOptions.NONE;
            }

            @Override
            public QueryParameterBindings getQueryParameterBindings() {
                return QueryParameterBindings.NO_PARAM_BINDINGS;
            }

            @Override
            public Callback getCallback() {
                return null;
            }
        }, RowTransformerDatabaseSnapshotImpl.instance(), true);
        int size = list.size();
        assert (size <= 1);
        if (size == 0) {
            return null;
        }
        Object[] entitySnapshot = (Object[])list.get(0);
        if (entitySnapshot.length == 1) {
            return ArrayHelper.EMPTY_OBJECT_ARRAY;
        }
        Object[] state = new Object[entitySnapshot.length - 1];
        System.arraycopy(entitySnapshot, 1, state, 0, state.length);
        return state;
    }
}

