/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.ast.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.LockOptions;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.loader.ast.internal.LoaderSelectBuilder;
import org.hibernate.loader.ast.spi.SingleUniqueKeyEntityLoader;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.SingularAttributeMapping;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryOptionsAdapter;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.spi.Callback;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcSelect;

public class SingleUniqueKeyEntityLoaderStandard<T>
implements SingleUniqueKeyEntityLoader<T> {
    private final EntityMappingType entityDescriptor;
    private final ModelPart uniqueKeyAttribute;

    public SingleUniqueKeyEntityLoaderStandard(EntityMappingType entityDescriptor, SingularAttributeMapping uniqueKeyAttribute) {
        this.entityDescriptor = entityDescriptor;
        this.uniqueKeyAttribute = uniqueKeyAttribute instanceof ToOneAttributeMapping ? ((ToOneAttributeMapping)uniqueKeyAttribute).getForeignKeyDescriptor() : uniqueKeyAttribute;
    }

    @Override
    public EntityMappingType getLoadable() {
        return this.entityDescriptor;
    }

    @Override
    public T load(Object ukValue, LockOptions lockOptions, final Boolean readOnly, final SharedSessionContractImplementor session) {
        SessionFactoryImplementor sessionFactory = session.getFactory();
        ArrayList<JdbcParameter> jdbcParameters = new ArrayList<JdbcParameter>();
        SelectStatement sqlAst = LoaderSelectBuilder.createSelectByUniqueKey(this.entityDescriptor, Collections.emptyList(), this.uniqueKeyAttribute, null, 1, LoadQueryInfluencers.NONE, LockOptions.READ, jdbcParameters::add, sessionFactory);
        JdbcServices jdbcServices = sessionFactory.getJdbcServices();
        JdbcEnvironment jdbcEnvironment = jdbcServices.getJdbcEnvironment();
        SqlAstTranslatorFactory sqlAstTranslatorFactory = jdbcEnvironment.getSqlAstTranslatorFactory();
        JdbcParameterBindingsImpl jdbcParameterBindings = new JdbcParameterBindingsImpl(jdbcParameters.size());
        int offset = jdbcParameterBindings.registerParametersForEachJdbcValue(ukValue, Clause.WHERE, this.uniqueKeyAttribute, jdbcParameters, session);
        assert (offset == jdbcParameters.size());
        JdbcSelect jdbcSelect = sqlAstTranslatorFactory.buildSelectTranslator(sessionFactory, sqlAst).translate(jdbcParameterBindings, QueryOptions.NONE);
        List<Object> list = sessionFactory.getJdbcServices().getJdbcSelectExecutor().list(jdbcSelect, jdbcParameterBindings, new ExecutionContext(){

            @Override
            public SharedSessionContractImplementor getSession() {
                return session;
            }

            @Override
            public QueryOptions getQueryOptions() {
                return new QueryOptionsAdapter(){

                    @Override
                    public Boolean isReadOnly() {
                        return readOnly;
                    }
                };
            }

            @Override
            public QueryParameterBindings getQueryParameterBindings() {
                return QueryParameterBindings.NO_PARAM_BINDINGS;
            }

            @Override
            public Callback getCallback() {
                return afterLoadAction -> {};
            }
        }, row -> row[0], true);
        switch (list.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (T)list.get(0);
            }
        }
        throw new HibernateException("More than one row with the given identifier was found: " + ukValue + ", for class: " + this.entityDescriptor.getEntityName());
    }

    @Override
    public Object resolveId(Object ukValue, final SharedSessionContractImplementor session) {
        SessionFactoryImplementor sessionFactory = session.getFactory();
        ArrayList<JdbcParameter> jdbcParameters = new ArrayList<JdbcParameter>();
        SelectStatement sqlAst = LoaderSelectBuilder.createSelectByUniqueKey(this.entityDescriptor, Collections.singletonList(this.entityDescriptor.getIdentifierMapping()), this.uniqueKeyAttribute, null, 1, LoadQueryInfluencers.NONE, LockOptions.READ, jdbcParameters::add, sessionFactory);
        JdbcServices jdbcServices = sessionFactory.getJdbcServices();
        JdbcEnvironment jdbcEnvironment = jdbcServices.getJdbcEnvironment();
        SqlAstTranslatorFactory sqlAstTranslatorFactory = jdbcEnvironment.getSqlAstTranslatorFactory();
        JdbcParameterBindingsImpl jdbcParameterBindings = new JdbcParameterBindingsImpl(jdbcParameters.size());
        int offset = jdbcParameterBindings.registerParametersForEachJdbcValue(ukValue, Clause.WHERE, this.uniqueKeyAttribute, jdbcParameters, session);
        assert (offset == jdbcParameters.size());
        JdbcSelect jdbcSelect = sqlAstTranslatorFactory.buildSelectTranslator(sessionFactory, sqlAst).translate(jdbcParameterBindings, QueryOptions.NONE);
        List<Object> list = sessionFactory.getJdbcServices().getJdbcSelectExecutor().list(jdbcSelect, jdbcParameterBindings, new ExecutionContext(){

            @Override
            public SharedSessionContractImplementor getSession() {
                return session;
            }

            @Override
            public QueryOptions getQueryOptions() {
                return QueryOptions.NONE;
            }

            @Override
            public QueryParameterBindings getQueryParameterBindings() {
                return QueryParameterBindings.NO_PARAM_BINDINGS;
            }

            @Override
            public Callback getCallback() {
                return afterLoadAction -> {};
            }
        }, row -> row[0], true);
        assert (list.size() == 1);
        return list.get(0);
    }
}

