/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.util.Map;
import java.util.function.Function;
import javax.persistence.EnumType;
import javax.persistence.TemporalType;
import org.hibernate.MappingException;
import org.hibernate.boot.model.TypeDefinition;
import org.hibernate.boot.model.TypeDefinitionRegistry;
import org.hibernate.boot.model.convert.internal.ClassBasedConverterDescriptor;
import org.hibernate.boot.model.convert.spi.ConverterDescriptor;
import org.hibernate.boot.model.convert.spi.JpaAttributeConverterCreationContext;
import org.hibernate.boot.model.process.internal.ConvertedBasicTypeResolution;
import org.hibernate.boot.model.process.internal.InferredBasicValueResolver;
import org.hibernate.boot.model.process.internal.NamedBasicTypeResolution;
import org.hibernate.boot.model.process.internal.NamedConverterResolution;
import org.hibernate.boot.model.process.internal.VersionResolution;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Formula;
import org.hibernate.mapping.Resolvable;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.model.convert.spi.BasicValueConverter;
import org.hibernate.metamodel.model.convert.spi.JpaAttributeConverter;
import org.hibernate.resource.beans.spi.ManagedBeanRegistry;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.BasicType;
import org.hibernate.type.ConvertedBasicType;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.java.BasicJavaDescriptor;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.jdbc.JdbcTypeDescriptor;
import org.hibernate.type.descriptor.jdbc.JdbcTypeDescriptorIndicators;
import org.hibernate.type.spi.TypeConfiguration;

public class BasicValue
extends SimpleValue
implements JdbcTypeDescriptorIndicators,
Resolvable {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(BasicValue.class);
    private final TypeConfiguration typeConfiguration;
    private final int preferredJdbcTypeCodeForBoolean;
    private String explicitTypeName;
    private Map explicitLocalTypeParams;
    private Function<TypeConfiguration, BasicJavaDescriptor> explicitJavaTypeAccess;
    private Function<TypeConfiguration, JdbcTypeDescriptor> explicitSqlTypeAccess;
    private Function<TypeConfiguration, MutabilityPlan> explicitMutabilityPlanAccess;
    private Function<TypeConfiguration, java.lang.reflect.Type> implicitJavaTypeAccess;
    private EnumType enumerationStyle;
    private TemporalType temporalPrecision;
    private java.lang.reflect.Type resolvedJavaType;
    private String ownerName;
    private String propertyName;
    private Resolution<?> resolution;

    public BasicValue(MetadataBuildingContext buildingContext) {
        this(buildingContext, null);
    }

    public BasicValue(MetadataBuildingContext buildingContext, Table table) {
        super(buildingContext, table);
        this.typeConfiguration = buildingContext.getBootstrapContext().getTypeConfiguration();
        this.preferredJdbcTypeCodeForBoolean = buildingContext.getPreferredSqlTypeCodeForBoolean();
        buildingContext.getMetadataCollector().registerValueMappingResolver(this::resolve);
    }

    @Override
    public void setTypeUsingReflection(String className, String propertyName) throws MappingException {
        if (this.resolution != null) {
            throw new IllegalStateException("BasicValue already resolved");
        }
        this.ownerName = className;
        this.propertyName = propertyName;
        super.setTypeUsingReflection(className, propertyName);
    }

    public void setEnumerationStyle(EnumType enumerationStyle) {
        this.enumerationStyle = enumerationStyle;
    }

    public EnumType getEnumerationStyle() {
        return this.enumerationStyle;
    }

    @Override
    public void setJpaAttributeConverterDescriptor(ConverterDescriptor descriptor) {
        this.setAttributeConverterDescriptor(descriptor);
        super.setJpaAttributeConverterDescriptor(descriptor);
    }

    public void setExplicitJavaTypeAccess(Function<TypeConfiguration, BasicJavaDescriptor> explicitJavaTypeAccess) {
        this.explicitJavaTypeAccess = explicitJavaTypeAccess;
    }

    public void setExplicitSqlTypeAccess(Function<TypeConfiguration, JdbcTypeDescriptor> sqlTypeAccess) {
        this.explicitSqlTypeAccess = sqlTypeAccess;
    }

    public void setExplicitMutabilityPlanAccess(Function<TypeConfiguration, MutabilityPlan> explicitMutabilityPlanAccess) {
        this.explicitMutabilityPlanAccess = explicitMutabilityPlanAccess;
    }

    public void setImplicitJavaTypeAccess(Function<TypeConfiguration, java.lang.reflect.Type> implicitJavaTypeAccess) {
        this.implicitJavaTypeAccess = implicitJavaTypeAccess;
    }

    public Selectable getColumn() {
        if (this.getColumnSpan() == 0) {
            return null;
        }
        return this.getColumn(0);
    }

    public java.lang.reflect.Type getResolvedJavaType() {
        return this.resolvedJavaType;
    }

    @Override
    public long getColumnLength() {
        Selectable column = this.getColumn();
        if (column != null && column instanceof Column) {
            Long length = ((Column)column).getLength();
            return length == null ? -1L : length;
        }
        return -1L;
    }

    @Override
    public void addColumn(Column incomingColumn) {
        super.addColumn(incomingColumn);
        this.checkSelectable(incomingColumn);
    }

    @Override
    public void copyTypeFrom(SimpleValue sourceValue) {
        super.copyTypeFrom(sourceValue);
        if (sourceValue instanceof BasicValue) {
            BasicValue basicValue = (BasicValue)sourceValue;
            this.resolution = basicValue.resolution;
            this.implicitJavaTypeAccess = typeConfiguration -> basicValue.implicitJavaTypeAccess.apply((TypeConfiguration)typeConfiguration);
        }
    }

    private void checkSelectable(Selectable incomingColumn) {
        if (incomingColumn == null) {
            throw new IllegalArgumentException("Incoming column was null");
        }
        Selectable column = this.getColumn();
        if (column == incomingColumn || column.getText().equals(incomingColumn.getText())) {
            log.debugf("Skipping column re-registration: %s.%s", this.getTable().getName(), column.getText());
            return;
        }
        if (column != null) {
            throw new IllegalStateException("BasicValue [" + this.ownerName + "." + this.propertyName + "] already had column associated: `" + column.getText() + "` -> `" + incomingColumn.getText() + "`");
        }
    }

    @Override
    public void addColumn(Column incomingColumn, boolean isInsertable, boolean isUpdatable) {
        super.addColumn(incomingColumn, isInsertable, isUpdatable);
        this.checkSelectable(incomingColumn);
    }

    @Override
    public void addFormula(Formula formula) {
        super.addFormula(formula);
        this.checkSelectable(formula);
    }

    @Override
    public Type getType() throws MappingException {
        this.resolve();
        assert (this.getResolution() != null);
        return this.getResolution().getLegacyResolvedBasicType();
    }

    public Resolution<?> getResolution() {
        return this.resolution;
    }

    @Override
    public boolean resolve(MetadataBuildingContext buildingContext) {
        this.resolve();
        return true;
    }

    @Override
    public Resolution<?> resolve() {
        if (this.resolution != null) {
            return this.resolution;
        }
        this.resolution = this.buildResolution();
        if (this.resolution == null) {
            throw new IllegalStateException("Unable to resolve BasicValue : " + this);
        }
        Selectable column = this.getColumn();
        if (column instanceof Column && this.resolution.getValueConverter() == null) {
            Column physicalColumn = (Column)column;
            if (physicalColumn.getSqlTypeCode() == null) {
                physicalColumn.setSqlTypeCode(this.resolution.getJdbcTypeDescriptor().getJdbcTypeCode());
            }
            BasicType<?> basicType = this.resolution.getLegacyResolvedBasicType();
            Dialect dialect = this.getServiceRegistry().getService(JdbcServices.class).getDialect();
            String checkConstraint = physicalColumn.getCheckConstraint();
            if (checkConstraint == null && dialect.supportsColumnCheck()) {
                physicalColumn.setCheckConstraint(basicType.getJavaTypeDescriptor().getCheckCondition(physicalColumn.getQuotedName(dialect), basicType.getJdbcTypeDescriptor(), dialect));
            }
        }
        return this.resolution;
    }

    protected Resolution<?> buildResolution() {
        TypeDefinitionRegistry typeDefinitionRegistry;
        TypeDefinition autoAppliedTypeDef;
        JavaTypeDescriptor reflectedJtd;
        java.lang.reflect.Type implicitJtd;
        BasicJavaDescriptor explicitJtd;
        if (this.explicitTypeName != null) {
            return BasicValue.interpretExplicitlyNamedType(this.explicitTypeName, this.enumerationStyle, this.implicitJavaTypeAccess, this.explicitJavaTypeAccess, this.explicitSqlTypeAccess, this.explicitMutabilityPlanAccess, this.getAttributeConverterDescriptor(), this.explicitLocalTypeParams, this, this.typeConfiguration, this.getBuildingContext());
        }
        if (this.isVersion()) {
            return VersionResolution.from(this.implicitJavaTypeAccess, this.explicitJavaTypeAccess, this.explicitSqlTypeAccess, this.typeConfiguration, this.getBuildingContext());
        }
        ConverterDescriptor attributeConverterDescriptor = this.getAttributeConverterDescriptor();
        if (attributeConverterDescriptor != null) {
            final ManagedBeanRegistry managedBeanRegistry = this.getBuildingContext().getBootstrapContext().getServiceRegistry().getService(ManagedBeanRegistry.class);
            JpaAttributeConverterCreationContext converterCreationContext = new JpaAttributeConverterCreationContext(){

                @Override
                public ManagedBeanRegistry getManagedBeanRegistry() {
                    return managedBeanRegistry;
                }

                @Override
                public TypeConfiguration getTypeConfiguration() {
                    return BasicValue.this.typeConfiguration;
                }
            };
            return NamedConverterResolution.from(attributeConverterDescriptor, this.explicitJavaTypeAccess, this.explicitSqlTypeAccess, this.explicitMutabilityPlanAccess, (JdbcTypeDescriptorIndicators)this, converterCreationContext, this.getBuildingContext());
        }
        JavaTypeDescriptor jtd = null;
        if (this.explicitJavaTypeAccess != null && (explicitJtd = this.explicitJavaTypeAccess.apply(this.typeConfiguration)) != null) {
            jtd = explicitJtd;
        }
        if (jtd == null && this.implicitJavaTypeAccess != null && (implicitJtd = this.implicitJavaTypeAccess.apply(this.typeConfiguration)) != null) {
            jtd = this.typeConfiguration.getJavaTypeDescriptorRegistry().getDescriptor(implicitJtd);
        }
        if (jtd == null && (reflectedJtd = this.determineReflectedJavaTypeDescriptor()) != null) {
            jtd = reflectedJtd;
        }
        if ((autoAppliedTypeDef = (typeDefinitionRegistry = this.getBuildingContext().getTypeDefinitionRegistry()).resolveAutoApplied((BasicJavaDescriptor<?>)jtd)) != null) {
            log.debug("BasicValue resolution matched auto-applied type-definition");
            return autoAppliedTypeDef.resolve(this.getTypeParameters(), null, this.getBuildingContext(), this);
        }
        return InferredBasicValueResolver.from(this.explicitJavaTypeAccess, this.explicitSqlTypeAccess, this::determineReflectedJavaTypeDescriptor, this, this.getTable(), this.getColumn(), this.ownerName, this.propertyName, this.typeConfiguration);
    }

    private JavaTypeDescriptor determineReflectedJavaTypeDescriptor() {
        java.lang.reflect.Type impliedJavaType;
        if (this.resolvedJavaType != null) {
            impliedJavaType = this.resolvedJavaType;
        } else if (this.implicitJavaTypeAccess != null) {
            impliedJavaType = this.implicitJavaTypeAccess.apply(this.typeConfiguration);
        } else if (this.ownerName != null && this.propertyName != null) {
            ServiceRegistry serviceRegistry = this.typeConfiguration.getServiceRegistry();
            ClassLoaderService classLoaderService = serviceRegistry.getService(ClassLoaderService.class);
            impliedJavaType = ReflectHelper.reflectedPropertyType(this.ownerName, this.propertyName, classLoaderService);
        } else {
            return null;
        }
        this.resolvedJavaType = impliedJavaType;
        return this.typeConfiguration.getJavaTypeDescriptorRegistry().resolveDescriptor(impliedJavaType);
    }

    private static Resolution interpretExplicitlyNamedType(String name, EnumType enumerationStyle, Function<TypeConfiguration, java.lang.reflect.Type> implicitJavaTypeAccess, Function<TypeConfiguration, BasicJavaDescriptor> explicitJtdAccess, Function<TypeConfiguration, JdbcTypeDescriptor> explicitStdAccess, Function<TypeConfiguration, MutabilityPlan> explicitMutabilityPlanAccess, ConverterDescriptor converterDescriptor, Map localTypeParams, JdbcTypeDescriptorIndicators stdIndicators, final TypeConfiguration typeConfiguration, MetadataBuildingContext context) {
        final ManagedBeanRegistry managedBeanRegistry = context.getBootstrapContext().getServiceRegistry().getService(ManagedBeanRegistry.class);
        JpaAttributeConverterCreationContext converterCreationContext = new JpaAttributeConverterCreationContext(){

            @Override
            public ManagedBeanRegistry getManagedBeanRegistry() {
                return managedBeanRegistry;
            }

            @Override
            public TypeConfiguration getTypeConfiguration() {
                return typeConfiguration;
            }
        };
        if (name.startsWith("converted::")) {
            return NamedConverterResolution.from(name, explicitJtdAccess, explicitStdAccess, explicitMutabilityPlanAccess, stdIndicators, converterCreationContext, context);
        }
        BasicType basicTypeByName = typeConfiguration.getBasicTypeRegistry().getRegisteredType(name);
        if (basicTypeByName != null) {
            JavaTypeDescriptor<Object> domainJtd;
            JpaAttributeConverter valueConverter;
            if (converterDescriptor != null) {
                valueConverter = converterDescriptor.createJpaAttributeConverter(converterCreationContext);
                domainJtd = valueConverter.getDomainJavaDescriptor();
            } else {
                if (basicTypeByName instanceof ConvertedBasicType) {
                    ConvertedBasicType convertedType = (ConvertedBasicType)basicTypeByName;
                    return new ConvertedBasicTypeResolution(convertedType, stdIndicators);
                }
                valueConverter = null;
                domainJtd = basicTypeByName.getJavaTypeDescriptor();
            }
            return new NamedBasicTypeResolution(domainJtd, basicTypeByName, valueConverter, explicitMutabilityPlanAccess, context);
        }
        TypeDefinition typeDefinition = context.getTypeDefinitionRegistry().resolve(name);
        if (typeDefinition != null) {
            return typeDefinition.resolve(localTypeParams, explicitMutabilityPlanAccess != null ? explicitMutabilityPlanAccess.apply(typeConfiguration) : null, context, stdIndicators);
        }
        ClassLoaderService cls = typeConfiguration.getServiceRegistry().getService(ClassLoaderService.class);
        try {
            Class typeNamedClass = cls.classForName(name);
            if (CollectionHelper.isEmpty(localTypeParams)) {
                TypeDefinition implicitDefinition = new TypeDefinition(name, typeNamedClass, null, null, typeConfiguration);
                context.getTypeDefinitionRegistry().register(implicitDefinition);
                return implicitDefinition.resolve(localTypeParams, explicitMutabilityPlanAccess != null ? explicitMutabilityPlanAccess.apply(typeConfiguration) : null, context, stdIndicators);
            }
            return TypeDefinition.createLocalResolution(name, typeNamedClass, explicitMutabilityPlanAccess != null ? explicitMutabilityPlanAccess.apply(typeConfiguration) : null, localTypeParams, context);
        }
        catch (ClassLoadingException e) {
            log.debugf("Could not resolve type-name [%s] as Java type : %s", name, (Object)e);
            throw new MappingException("Could not resolve named type : " + name);
        }
    }

    @Override
    public EnumType getEnumeratedType() {
        return this.getEnumerationStyle();
    }

    @Override
    public int getPreferredSqlTypeCodeForBoolean() {
        return this.preferredJdbcTypeCodeForBoolean;
    }

    @Override
    public TypeConfiguration getTypeConfiguration() {
        return this.typeConfiguration;
    }

    public void setExplicitTypeParams(Map explicitLocalTypeParams) {
        this.explicitLocalTypeParams = explicitLocalTypeParams;
    }

    public void setExplicitTypeName(String typeName) {
        this.explicitTypeName = typeName;
    }

    @Override
    public void setTypeName(String typeName) {
        if (StringHelper.isNotEmpty(typeName)) {
            if (typeName.startsWith("converted::")) {
                String converterClassName = typeName.substring("converted::".length());
                ClassLoaderService cls = this.getBuildingContext().getMetadataCollector().getMetadataBuildingOptions().getServiceRegistry().getService(ClassLoaderService.class);
                try {
                    Class converterClass = cls.classForName(converterClassName);
                    this.setAttributeConverterDescriptor(new ClassBasedConverterDescriptor(converterClass, false, this.getBuildingContext().getBootstrapContext().getClassmateContext()));
                    return;
                }
                catch (Exception e) {
                    log.logBadHbmAttributeConverterType(typeName, e.getMessage());
                }
            } else {
                this.setExplicitTypeName(typeName);
            }
        }
        super.setTypeName(typeName);
    }

    public void setTemporalPrecision(TemporalType temporalPrecision) {
        this.temporalPrecision = temporalPrecision;
    }

    @Override
    public TemporalType getTemporalPrecision() {
        return this.temporalPrecision;
    }

    public static interface Resolution<J> {
        public BasicType<J> getLegacyResolvedBasicType();

        public JdbcMapping getJdbcMapping();

        public JavaTypeDescriptor<J> getDomainJavaDescriptor();

        public JavaTypeDescriptor<?> getRelationalJavaDescriptor();

        public JdbcTypeDescriptor getJdbcTypeDescriptor();

        public BasicValueConverter getValueConverter();

        public MutabilityPlan<J> getMutabilityPlan();
    }
}

