/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel;

import java.util.Locale;
import org.hibernate.EntityMode;

public enum RepresentationMode {
    POJO("pojo", EntityMode.POJO),
    MAP("map", "dynamic-map", EntityMode.MAP);

    private final String externalName;
    private final String alternativeExternalName;
    private final EntityMode legacyEntityMode;

    private RepresentationMode(String externalName, EntityMode legacyEntityMode) {
        this(externalName, null, legacyEntityMode);
    }

    private RepresentationMode(String externalName, String alternativeExternalName, EntityMode legacyEntityMode) {
        this.externalName = externalName;
        this.alternativeExternalName = alternativeExternalName;
        this.legacyEntityMode = legacyEntityMode;
    }

    public String getExternalName() {
        return this.externalName;
    }

    @Deprecated
    public EntityMode getLegacyEntityMode() {
        return this.legacyEntityMode;
    }

    public static RepresentationMode fromExternalName(String externalName) {
        if (externalName == null) {
            return POJO;
        }
        if (RepresentationMode.MAP.externalName.equalsIgnoreCase(externalName) || RepresentationMode.MAP.alternativeExternalName.equalsIgnoreCase(externalName)) {
            return MAP;
        }
        if (RepresentationMode.POJO.externalName.equalsIgnoreCase(externalName)) {
            return POJO;
        }
        return RepresentationMode.valueOf(externalName.toUpperCase(Locale.ROOT));
    }
}

