/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.internal;

import java.util.Map;
import org.hibernate.internal.log.DeprecationLogger;
import org.hibernate.internal.util.config.ConfigurationHelper;

public enum JpaStaticMetaModelPopulationSetting {
    ENABLED,
    DISABLED,
    SKIP_UNSUPPORTED;


    public static JpaStaticMetaModelPopulationSetting parse(String setting) {
        if ("enabled".equalsIgnoreCase(setting)) {
            return ENABLED;
        }
        if ("disabled".equalsIgnoreCase(setting)) {
            return DISABLED;
        }
        return SKIP_UNSUPPORTED;
    }

    public static JpaStaticMetaModelPopulationSetting determineJpaMetaModelPopulationSetting(Map configurationValues) {
        return JpaStaticMetaModelPopulationSetting.parse(JpaStaticMetaModelPopulationSetting.determineSetting(configurationValues));
    }

    private static String determineSetting(Map configurationValues) {
        String setting = ConfigurationHelper.getString("hibernate.jpa.static_metamodel.population", configurationValues, null);
        if (setting != null) {
            return setting;
        }
        String legacySetting1 = ConfigurationHelper.getString("hibernate.ejb.metamodel.population", configurationValues, null);
        if (legacySetting1 != null) {
            DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("hibernate.ejb.metamodel.population", "hibernate.jpa.static_metamodel.population");
            return legacySetting1;
        }
        String legacySetting2 = ConfigurationHelper.getString("hibernate.ejb.metamodel.generation", configurationValues, null);
        if (legacySetting2 != null) {
            DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("hibernate.ejb.metamodel.generation", "hibernate.jpa.static_metamodel.population");
            return legacySetting1;
        }
        return null;
    }
}

