/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.internal;

import java.lang.reflect.Type;
import java.util.Map;
import org.hibernate.bytecode.spi.ReflectionOptimizer;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Property;
import org.hibernate.metamodel.RepresentationMode;
import org.hibernate.metamodel.internal.DynamicMapInstantiator;
import org.hibernate.metamodel.spi.EmbeddableRepresentationStrategy;
import org.hibernate.metamodel.spi.Instantiator;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.property.access.internal.PropertyAccessStrategyMapImpl;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

public class StandardMapEmbeddableRepresentationStrategy
implements EmbeddableRepresentationStrategy {
    private final JavaTypeDescriptor<?> mapJtd;
    private final DynamicMapInstantiator instantiator;

    public StandardMapEmbeddableRepresentationStrategy(Component bootDescriptor, RuntimeModelCreationContext creationContext) {
        this.mapJtd = creationContext.getTypeConfiguration().getJavaTypeDescriptorRegistry().getDescriptor((Type)((Object)Map.class));
        this.instantiator = new DynamicMapInstantiator(bootDescriptor);
    }

    @Override
    public RepresentationMode getMode() {
        return RepresentationMode.MAP;
    }

    @Override
    public ReflectionOptimizer getReflectionOptimizer() {
        return null;
    }

    @Override
    public JavaTypeDescriptor<?> getMappedJavaTypeDescriptor() {
        return this.mapJtd;
    }

    @Override
    public PropertyAccess resolvePropertyAccess(Property bootAttributeDescriptor) {
        return PropertyAccessStrategyMapImpl.INSTANCE.buildPropertyAccess(null, bootAttributeDescriptor.getName());
    }

    @Override
    public <J> Instantiator<J> getInstantiator() {
        return this.instantiator;
    }
}

