/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.ArrayList;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.EntityValuedModelPart;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.ordering.ast.DomainPath;
import org.hibernate.query.SortOrder;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SortSpecification;

public abstract class AbstractDomainPath
implements DomainPath {
    public static final String ELEMENT_TOKEN = "$element$";

    @Override
    public SqlAstNode resolve(QuerySpec ast, TableGroup tableGroup, String modelPartName, SqlAstCreationState creationState) {
        return this.resolve(this.getReferenceModelPart(), ast, tableGroup, modelPartName, creationState);
    }

    public Expression resolve(ModelPart referenceModelPart, QuerySpec ast, TableGroup tableGroup, String modelPartName, SqlAstCreationState creationState) {
        if (referenceModelPart instanceof BasicValuedModelPart) {
            BasicValuedModelPart selection = (BasicValuedModelPart)referenceModelPart;
            TableReference tableReference = tableGroup.resolveTableReference(this.getNavigablePath(), selection.getContainingTableExpression());
            return creationState.getSqlExpressionResolver().resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(selection.getContainingTableExpression(), selection.getSelectionExpression()), sqlAstProcessingState -> new ColumnReference(tableReference, (SelectableMapping)selection, creationState.getCreationContext().getSessionFactory()));
        }
        if (referenceModelPart instanceof EntityValuedModelPart) {
            ModelPart subPart = ELEMENT_TOKEN.equals(modelPartName) ? ((EntityValuedModelPart)referenceModelPart).getEntityMappingType().getIdentifierMapping() : ((EntityValuedModelPart)referenceModelPart).findSubPart(modelPartName);
            return this.resolve(subPart, ast, tableGroup, modelPartName, creationState);
        }
        if (referenceModelPart instanceof EmbeddableValuedModelPart) {
            EmbeddableValuedModelPart embeddableValuedModelPart = (EmbeddableValuedModelPart)referenceModelPart;
            if (embeddableValuedModelPart.getFetchableName().equals(modelPartName) || ELEMENT_TOKEN.equals(modelPartName)) {
                ArrayList expressions = new ArrayList(embeddableValuedModelPart.getNumberOfFetchables());
                embeddableValuedModelPart.visitFetchables(fetchable -> expressions.add(this.resolve((ModelPart)fetchable, ast, tableGroup, modelPartName, creationState)), null);
                return new SqlTuple(expressions, embeddableValuedModelPart);
            }
            ModelPart subPart = embeddableValuedModelPart.findSubPart(modelPartName, null);
            assert (subPart instanceof BasicValuedModelPart);
            return this.resolve(subPart, ast, tableGroup, modelPartName, creationState);
        }
        throw new NotYetImplementedFor6Exception("Ordering for " + referenceModelPart + " not supported");
    }

    @Override
    public void apply(QuerySpec ast, TableGroup tableGroup, String collation, String modelPartName, SortOrder sortOrder, SqlAstCreationState creationState) {
        this.apply(this.getReferenceModelPart(), ast, tableGroup, collation, modelPartName, sortOrder, creationState);
    }

    public void apply(ModelPart referenceModelPart, QuerySpec ast, TableGroup tableGroup, String collation, String modelPartName, SortOrder sortOrder, SqlAstCreationState creationState) {
        if (referenceModelPart instanceof BasicValuedModelPart) {
            this.addSortSpecification((BasicValuedModelPart)referenceModelPart, ast, tableGroup, collation, sortOrder, creationState);
        } else if (referenceModelPart instanceof EntityValuedModelPart) {
            ModelPart subPart = ELEMENT_TOKEN.equals(modelPartName) ? ((EntityValuedModelPart)referenceModelPart).getEntityMappingType().getIdentifierMapping() : ((EntityValuedModelPart)referenceModelPart).findSubPart(modelPartName);
            this.apply(subPart, ast, tableGroup, collation, modelPartName, sortOrder, creationState);
        } else if (referenceModelPart instanceof EmbeddableValuedModelPart) {
            this.addSortSpecification((EmbeddableValuedModelPart)referenceModelPart, ast, tableGroup, collation, modelPartName, sortOrder, creationState);
        } else {
            throw new NotYetImplementedFor6Exception("Ordering for " + this.getReferenceModelPart() + " not supported");
        }
    }

    private void addSortSpecification(EmbeddableValuedModelPart embeddableValuedModelPart, QuerySpec ast, TableGroup tableGroup, String collation, String modelPartName, SortOrder sortOrder, SqlAstCreationState creationState) {
        if (embeddableValuedModelPart.getFetchableName().equals(modelPartName) || ELEMENT_TOKEN.equals(modelPartName)) {
            embeddableValuedModelPart.forEachSelectable((columnIndex, selection) -> this.addSortSpecification(selection, ast, tableGroup, collation, sortOrder, creationState));
        } else {
            ModelPart subPart = embeddableValuedModelPart.findSubPart(modelPartName, null);
            assert (subPart instanceof BasicValuedModelPart);
            this.addSortSpecification((BasicValuedModelPart)subPart, ast, tableGroup, collation, sortOrder, creationState);
        }
    }

    private void addSortSpecification(SelectableMapping selection, QuerySpec ast, TableGroup tableGroup, String collation, SortOrder sortOrder, SqlAstCreationState creationState) {
        TableReference tableReference = tableGroup.resolveTableReference(this.getNavigablePath(), selection.getContainingTableExpression());
        Expression expression = creationState.getSqlExpressionResolver().resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(selection.getContainingTableExpression(), selection.getSelectionExpression()), sqlAstProcessingState -> new ColumnReference(tableReference, selection, creationState.getCreationContext().getSessionFactory()));
        if (ast.hasSortSpecifications()) {
            for (SortSpecification sortSpecification : ast.getSortSpecifications()) {
                if (sortSpecification.getSortExpression() != expression) continue;
                return;
            }
        }
        ast.addSortSpecification(new SortSpecification(expression, collation, sortOrder));
    }
}

