/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import org.hibernate.LockMode;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.FetchTiming;
import org.hibernate.metamodel.mapping.EntityDiscriminatorMapping;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.persister.entity.DiscriminatorType;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchOptions;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.basic.BasicFetch;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

public abstract class AbstractEntityDiscriminatorMapping
implements EntityDiscriminatorMapping,
FetchOptions {
    private final EntityPersister entityDescriptor;
    private final String tableExpression;
    private final String mappedColumnExpression;
    private final boolean isFormula;
    private final DiscriminatorType<?> mappingType;

    public AbstractEntityDiscriminatorMapping(EntityPersister entityDescriptor, String tableExpression, String mappedColumnExpression, boolean isFormula, DiscriminatorType<?> mappingType) {
        this.entityDescriptor = entityDescriptor;
        this.tableExpression = tableExpression;
        this.mappedColumnExpression = mappedColumnExpression;
        this.isFormula = isFormula;
        this.mappingType = mappingType;
    }

    public EntityPersister getEntityDescriptor() {
        return this.entityDescriptor;
    }

    @Override
    public String getContainingTableExpression() {
        return this.tableExpression;
    }

    @Override
    public String getSelectionExpression() {
        return this.mappedColumnExpression;
    }

    @Override
    public boolean isFormula() {
        return this.isFormula;
    }

    @Override
    public String getFetchableName() {
        return "{discriminator}";
    }

    @Override
    public FetchOptions getMappedFetchOptions() {
        return this;
    }

    @Override
    public FetchStyle getStyle() {
        return FetchStyle.JOIN;
    }

    @Override
    public FetchTiming getTiming() {
        return FetchTiming.IMMEDIATE;
    }

    @Override
    public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        SqlSelection sqlSelection = this.resolveSqlSelection(tableGroup, false, creationState);
        return new BasicResult(sqlSelection.getValuesArrayPosition(), resultVariable, this.getJavaTypeDescriptor(), navigablePath);
    }

    @Override
    public <T> DomainResult<T> createUnderlyingDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        SqlSelection sqlSelection = this.resolveSqlSelection(tableGroup, true, creationState);
        return new BasicResult(sqlSelection.getValuesArrayPosition(), resultVariable, this.mappingType.getUnderlyingType().getJavaTypeDescriptor(), navigablePath);
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState) {
        this.resolveSqlSelection(tableGroup, false, creationState);
    }

    @Override
    public Fetch generateFetch(FetchParent fetchParent, NavigablePath fetchablePath, FetchTiming fetchTiming, boolean selected, LockMode lockMode, String resultVariable, DomainResultCreationState creationState) {
        SqlAstCreationState sqlAstCreationState = creationState.getSqlAstCreationState();
        TableGroup tableGroup = sqlAstCreationState.getFromClauseAccess().getTableGroup(fetchParent.getNavigablePath());
        assert (tableGroup != null);
        SqlSelection sqlSelection = this.resolveSqlSelection(tableGroup, true, creationState);
        return new BasicFetch(sqlSelection.getValuesArrayPosition(), fetchParent, fetchablePath, this, false, null, fetchTiming, creationState);
    }

    @Override
    public JavaTypeDescriptor<?> getJavaTypeDescriptor() {
        return ((DiscriminatorType)this.getMappedType()).getMappedJavaTypeDescriptor();
    }

    @Override
    public DiscriminatorType<?> getMappedType() {
        return this.mappingType;
    }

    @Override
    public DiscriminatorType<?> getPartMappingType() {
        return this.mappingType;
    }

    @Override
    public JdbcMapping getJdbcMapping() {
        return this.mappingType.getJdbcMapping();
    }

    protected abstract SqlSelection resolveSqlSelection(TableGroup var1, boolean var2, DomainResultCreationState var3);
}

