/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.io.Serializable;
import org.hibernate.LockMode;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.mapping.IndexedConsumer;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.DiscriminatedAssociationModelPart;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.SelectableConsumer;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.spi.FromClauseAccess;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchOptions;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.basic.BasicFetch;
import org.hibernate.type.MetaType;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

public class AnyDiscriminatorPart
implements BasicValuedModelPart,
FetchOptions,
SelectableMapping {
    public static final String ROLE_NAME = "{discriminator}";
    private final NavigableRole navigableRole;
    private final DiscriminatedAssociationModelPart declaringType;
    private final String table;
    private final String column;
    private final boolean nullable;
    private final MetaType metaType;

    public AnyDiscriminatorPart(NavigableRole partRole, DiscriminatedAssociationModelPart declaringType, String table, String column, boolean nullable, MetaType metaType) {
        this.navigableRole = partRole;
        this.declaringType = declaringType;
        this.table = table;
        this.column = column;
        this.nullable = nullable;
        this.metaType = metaType;
    }

    public MetaType getMetaType() {
        return this.metaType;
    }

    public JdbcMapping jdbcMapping() {
        return (JdbcMapping)((Object)this.metaType.getBaseType());
    }

    @Override
    public String getContainingTableExpression() {
        return this.table;
    }

    @Override
    public String getSelectionExpression() {
        return this.column;
    }

    @Override
    public boolean isFormula() {
        return false;
    }

    @Override
    public String getCustomReadExpression() {
        return null;
    }

    @Override
    public String getCustomWriteExpression() {
        return null;
    }

    @Override
    public JdbcMapping getJdbcMapping() {
        return this.jdbcMapping();
    }

    @Override
    public JavaTypeDescriptor<?> getJavaTypeDescriptor() {
        return this.jdbcMapping().getMappedJavaTypeDescriptor();
    }

    @Override
    public String getPartName() {
        return ROLE_NAME;
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.navigableRole;
    }

    @Override
    public Object disassemble(Object value, SharedSessionContractImplementor session) {
        Serializable discriminator = this.metaType.disassemble(value, session, value);
        return discriminator;
    }

    @Override
    public void breakDownJdbcValues(Object domainValue, ModelPart.JdbcValueConsumer valueConsumer, SharedSessionContractImplementor session) {
        valueConsumer.consume(domainValue, this);
    }

    @Override
    public EntityMappingType findContainingEntityMapping() {
        return this.declaringType.findContainingEntityMapping();
    }

    @Override
    public MappingType getMappedType() {
        return null;
    }

    @Override
    public String getFetchableName() {
        return this.getPartName();
    }

    @Override
    public FetchOptions getMappedFetchOptions() {
        return this;
    }

    @Override
    public int forEachJdbcType(int offset, IndexedConsumer<JdbcMapping> action) {
        action.accept(offset, this.jdbcMapping());
        return this.getJdbcTypeCount();
    }

    @Override
    public int forEachSelectable(SelectableConsumer consumer) {
        return this.forEachSelectable(0, consumer);
    }

    @Override
    public int forEachSelectable(int offset, SelectableConsumer consumer) {
        consumer.accept(offset, this);
        return 1;
    }

    @Override
    public Fetch generateFetch(FetchParent fetchParent, NavigablePath fetchablePath, FetchTiming fetchTiming, boolean selected, LockMode lockMode, String resultVariable, DomainResultCreationState creationState) {
        SqlAstCreationState sqlAstCreationState = creationState.getSqlAstCreationState();
        SessionFactoryImplementor sessionFactory = sqlAstCreationState.getCreationContext().getSessionFactory();
        FromClauseAccess fromClauseAccess = sqlAstCreationState.getFromClauseAccess();
        SqlExpressionResolver sqlExpressionResolver = sqlAstCreationState.getSqlExpressionResolver();
        TableGroup tableGroup = fromClauseAccess.getTableGroup(fetchablePath.getParent().getParent());
        TableReference tableReference = tableGroup.getTableReference(fetchablePath, this.table);
        Expression columnReference = sqlExpressionResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableReference, this.column), processingState -> new ColumnReference(tableReference, this.column, false, null, null, this.jdbcMapping(), sessionFactory));
        SqlSelection sqlSelection = sqlExpressionResolver.resolveSqlSelection(columnReference, this.jdbcMapping().getMappedJavaTypeDescriptor(), sessionFactory.getTypeConfiguration());
        return new BasicFetch(sqlSelection.getValuesArrayPosition(), fetchParent, fetchablePath, this, this.nullable, null, fetchTiming, creationState);
    }

    @Override
    public FetchStyle getStyle() {
        return FetchStyle.JOIN;
    }

    @Override
    public FetchTiming getTiming() {
        return FetchTiming.IMMEDIATE;
    }
}

