/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.Collections;
import java.util.List;
import org.hibernate.LockMode;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.mapping.IndexedConsumer;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.DiscriminatedAssociationModelPart;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.SelectableConsumer;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.spi.FromClauseAccess;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchOptions;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.basic.BasicFetch;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

public class AnyKeyPart
implements BasicValuedModelPart,
FetchOptions {
    public static final String ROLE_NAME = "{key}";
    private final NavigableRole navigableRole;
    private final String table;
    private final String column;
    private final DiscriminatedAssociationModelPart anyPart;
    private final boolean nullable;
    private final JdbcMapping jdbcMapping;

    public AnyKeyPart(NavigableRole navigableRole, DiscriminatedAssociationModelPart anyPart, String table, String column, boolean nullable, JdbcMapping jdbcMapping) {
        this.navigableRole = navigableRole;
        this.table = table;
        this.column = column;
        this.anyPart = anyPart;
        this.nullable = nullable;
        this.jdbcMapping = jdbcMapping;
    }

    @Override
    public String getContainingTableExpression() {
        return this.table;
    }

    @Override
    public String getSelectionExpression() {
        return this.column;
    }

    @Override
    public boolean isFormula() {
        return false;
    }

    @Override
    public String getCustomReadExpression() {
        return null;
    }

    @Override
    public String getCustomWriteExpression() {
        return null;
    }

    @Override
    public JdbcMapping getJdbcMapping() {
        return this.jdbcMapping;
    }

    @Override
    public JavaTypeDescriptor<?> getJavaTypeDescriptor() {
        return this.jdbcMapping.getMappedJavaTypeDescriptor();
    }

    @Override
    public String getPartName() {
        return ROLE_NAME;
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.navigableRole;
    }

    @Override
    public EntityMappingType findContainingEntityMapping() {
        return this.anyPart.findContainingEntityMapping();
    }

    @Override
    public MappingType getMappedType() {
        return this.jdbcMapping;
    }

    @Override
    public String getFetchableName() {
        return this.getPartName();
    }

    @Override
    public FetchOptions getMappedFetchOptions() {
        return this;
    }

    @Override
    public Fetch generateFetch(FetchParent fetchParent, NavigablePath fetchablePath, FetchTiming fetchTiming, boolean selected, LockMode lockMode, String resultVariable, DomainResultCreationState creationState) {
        FromClauseAccess fromClauseAccess = creationState.getSqlAstCreationState().getFromClauseAccess();
        SqlExpressionResolver sqlExpressionResolver = creationState.getSqlAstCreationState().getSqlExpressionResolver();
        SessionFactoryImplementor sessionFactory = creationState.getSqlAstCreationState().getCreationContext().getSessionFactory();
        TableGroup tableGroup = fromClauseAccess.getTableGroup(fetchParent.getNavigablePath().getParent());
        TableReference tableReference = tableGroup.getTableReference(fetchablePath, this.table);
        Expression columnReference = sqlExpressionResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableReference, this.column), processingState -> new ColumnReference(tableReference, this.column, false, null, null, this.jdbcMapping, sessionFactory));
        SqlSelection sqlSelection = sqlExpressionResolver.resolveSqlSelection(columnReference, this.getJavaTypeDescriptor(), sessionFactory.getTypeConfiguration());
        return new BasicFetch(sqlSelection.getValuesArrayPosition(), fetchParent, fetchablePath, this, this.nullable, null, fetchTiming, creationState);
    }

    @Override
    public FetchStyle getStyle() {
        return FetchStyle.SELECT;
    }

    @Override
    public FetchTiming getTiming() {
        return FetchTiming.IMMEDIATE;
    }

    @Override
    public int forEachSelectable(int offset, SelectableConsumer consumer) {
        consumer.accept(offset, this);
        return this.getJdbcTypeCount();
    }

    @Override
    public void breakDownJdbcValues(Object domainValue, ModelPart.JdbcValueConsumer valueConsumer, SharedSessionContractImplementor session) {
        valueConsumer.consume(domainValue, this);
    }

    @Override
    public int forEachJdbcType(int offset, IndexedConsumer<JdbcMapping> action) {
        action.accept(offset, this.jdbcMapping);
        return this.getJdbcTypeCount();
    }

    @Override
    public int forEachJdbcValue(Object value, Clause clause, int offset, Bindable.JdbcValuesConsumer valuesConsumer, SharedSessionContractImplementor session) {
        valuesConsumer.consume(offset, value, this.jdbcMapping);
        return this.getJdbcTypeCount();
    }

    @Override
    public List<JdbcMapping> getJdbcMappings() {
        return Collections.singletonList(this.jdbcMapping);
    }
}

