/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.function.BiConsumer;
import org.hibernate.LockMode;
import org.hibernate.engine.FetchStrategy;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.mapping.IndexedConsumer;
import org.hibernate.metamodel.mapping.AttributeMetadataAccess;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.ConvertibleModelPart;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.ManagedMappingType;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.SelectableConsumer;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.SingularAttributeMapping;
import org.hibernate.metamodel.mapping.StateArrayContributorMetadataAccess;
import org.hibernate.metamodel.mapping.internal.AbstractSingularAttributeMapping;
import org.hibernate.metamodel.mapping.internal.SingleAttributeIdentifierMapping;
import org.hibernate.metamodel.model.convert.spi.BasicValueConverter;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.basic.BasicFetch;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

public class BasicAttributeMapping
extends AbstractSingularAttributeMapping
implements SingularAttributeMapping,
BasicValuedModelPart,
ConvertibleModelPart {
    private final NavigableRole navigableRole;
    private final String tableExpression;
    private final String mappedColumnExpression;
    private final boolean isFormula;
    private final String customReadExpression;
    private final String customWriteExpression;
    private final JdbcMapping jdbcMapping;
    private final BasicValueConverter valueConverter;
    private final JavaTypeDescriptor domainTypeDescriptor;

    public BasicAttributeMapping(String attributeName, NavigableRole navigableRole, int stateArrayPosition, StateArrayContributorMetadataAccess attributeMetadataAccess, FetchStrategy mappedFetchStrategy, String tableExpression, String mappedColumnExpression, boolean isFormula, String customReadExpression, String customWriteExpression, BasicValueConverter valueConverter, JdbcMapping jdbcMapping, ManagedMappingType declaringType, PropertyAccess propertyAccess) {
        super(attributeName, stateArrayPosition, attributeMetadataAccess, mappedFetchStrategy, declaringType, propertyAccess);
        this.navigableRole = navigableRole;
        this.tableExpression = tableExpression;
        this.mappedColumnExpression = mappedColumnExpression;
        this.isFormula = isFormula;
        this.valueConverter = valueConverter;
        this.jdbcMapping = jdbcMapping;
        this.domainTypeDescriptor = valueConverter == null ? jdbcMapping.getJavaTypeDescriptor() : valueConverter.getDomainJavaDescriptor();
        this.customReadExpression = customReadExpression;
        this.customWriteExpression = isFormula ? null : customWriteExpression;
    }

    public static BasicAttributeMapping withSelectableMapping(BasicValuedModelPart original, SelectableMapping selectableMapping) {
        String attributeName = null;
        int stateArrayPosition = 0;
        AttributeMetadataAccess attributeMetadataAccess = null;
        BasicValueConverter valueConverter = null;
        PropertyAccess propertyAccess = null;
        ManagedMappingType declaringType = null;
        if (original instanceof SingleAttributeIdentifierMapping) {
            SingleAttributeIdentifierMapping mapping = (SingleAttributeIdentifierMapping)((Object)original);
            attributeName = mapping.getAttributeName();
            attributeMetadataAccess = null;
            propertyAccess = mapping.getPropertyAccess();
            declaringType = mapping.findContainingEntityMapping();
        } else if (original instanceof SingularAttributeMapping) {
            SingularAttributeMapping mapping = (SingularAttributeMapping)((Object)original);
            attributeName = mapping.getAttributeName();
            stateArrayPosition = mapping.getStateArrayPosition();
            attributeMetadataAccess = mapping.getAttributeMetadataAccess();
            propertyAccess = mapping.getPropertyAccess();
            declaringType = mapping.getDeclaringType();
        }
        if (original instanceof ConvertibleModelPart) {
            valueConverter = ((ConvertibleModelPart)original).getValueConverter();
        }
        return new BasicAttributeMapping(attributeName, original.getNavigableRole(), stateArrayPosition, (StateArrayContributorMetadataAccess)attributeMetadataAccess, FetchStrategy.IMMEDIATE_JOIN, selectableMapping.getContainingTableExpression(), selectableMapping.getSelectionExpression(), selectableMapping.isFormula(), selectableMapping.getCustomReadExpression(), selectableMapping.getCustomWriteExpression(), valueConverter, selectableMapping.getJdbcMapping(), declaringType, propertyAccess);
    }

    @Override
    public JdbcMapping getJdbcMapping() {
        return this.jdbcMapping;
    }

    @Override
    public MappingType getMappedType() {
        return this.getJdbcMapping();
    }

    @Override
    public JavaTypeDescriptor<?> getJavaTypeDescriptor() {
        return this.domainTypeDescriptor;
    }

    @Override
    public String getSelectionExpression() {
        return this.mappedColumnExpression;
    }

    @Override
    public boolean isFormula() {
        return this.isFormula;
    }

    @Override
    public String getCustomReadExpression() {
        return this.customReadExpression;
    }

    @Override
    public String getCustomWriteExpression() {
        return this.customWriteExpression;
    }

    @Override
    public String getContainingTableExpression() {
        return this.tableExpression;
    }

    @Override
    public BasicValueConverter getValueConverter() {
        return this.valueConverter;
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.navigableRole;
    }

    public String toString() {
        return "BasicAttributeMapping(" + this.navigableRole + ")@" + System.identityHashCode(this);
    }

    @Override
    public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        SqlSelection sqlSelection = this.resolveSqlSelection(tableGroup, creationState);
        return new BasicResult(sqlSelection.getValuesArrayPosition(), resultVariable, this.getMappedType().getMappedJavaTypeDescriptor(), this.valueConverter, navigablePath);
    }

    private SqlSelection resolveSqlSelection(TableGroup tableGroup, DomainResultCreationState creationState) {
        SqlExpressionResolver expressionResolver = creationState.getSqlAstCreationState().getSqlExpressionResolver();
        TableReference tableReference = tableGroup.resolveTableReference(tableGroup.getNavigablePath().append(this.getNavigableRole().getNavigableName()), this.getContainingTableExpression());
        String tableAlias = tableReference.getIdentificationVariable();
        return expressionResolver.resolveSqlSelection(expressionResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableReference, this.mappedColumnExpression), sqlAstProcessingState -> new ColumnReference(tableAlias, (SelectableMapping)this, creationState.getSqlAstCreationState().getCreationContext().getSessionFactory())), this.valueConverter == null ? this.getMappedType().getMappedJavaTypeDescriptor() : this.valueConverter.getRelationalJavaDescriptor(), creationState.getSqlAstCreationState().getCreationContext().getDomainModel().getTypeConfiguration());
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState) {
        this.resolveSqlSelection(tableGroup, creationState);
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState, BiConsumer<SqlSelection, JdbcMapping> selectionConsumer) {
        selectionConsumer.accept(this.resolveSqlSelection(tableGroup, creationState), this.getJdbcMapping());
    }

    @Override
    public Fetch generateFetch(FetchParent fetchParent, NavigablePath fetchablePath, FetchTiming fetchTiming, boolean selected, LockMode lockMode, String resultVariable, DomainResultCreationState creationState) {
        SqlAstCreationState sqlAstCreationState = creationState.getSqlAstCreationState();
        TableGroup tableGroup = sqlAstCreationState.getFromClauseAccess().getTableGroup(fetchParent.getNavigablePath());
        assert (tableGroup != null);
        SqlSelection sqlSelection = this.resolveSqlSelection(tableGroup, creationState);
        return new BasicFetch(sqlSelection.getValuesArrayPosition(), fetchParent, fetchablePath, this, this.getAttributeMetadataAccess().resolveAttributeMetadata(null).isNullable(), this.getValueConverter(), fetchTiming, creationState);
    }

    @Override
    public Object disassemble(Object value, SharedSessionContractImplementor session) {
        if (this.valueConverter != null) {
            return this.valueConverter.toRelationalValue(value);
        }
        return value;
    }

    @Override
    public int forEachDisassembledJdbcValue(Object value, Clause clause, int offset, Bindable.JdbcValuesConsumer valuesConsumer, SharedSessionContractImplementor session) {
        valuesConsumer.consume(offset, value, this.getJdbcMapping());
        return this.getJdbcTypeCount();
    }

    @Override
    public int forEachJdbcType(int offset, IndexedConsumer<JdbcMapping> action) {
        action.accept(offset, this.jdbcMapping);
        return this.getJdbcTypeCount();
    }

    @Override
    public int forEachSelectable(int offset, SelectableConsumer consumer) {
        consumer.accept(offset, this);
        return this.getJdbcTypeCount();
    }

    @Override
    public void breakDownJdbcValues(Object domainValue, ModelPart.JdbcValueConsumer valueConsumer, SharedSessionContractImplementor session) {
        valueConsumer.consume(this.disassemble(domainValue, session), this);
    }
}

