/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.hibernate.LockMode;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.mapping.Any;
import org.hibernate.mapping.Selectable;
import org.hibernate.metamodel.RuntimeMetamodels;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.DiscriminatedAssociationModelPart;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.internal.AnyDiscriminatorPart;
import org.hibernate.metamodel.mapping.internal.AnyKeyPart;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.metamodel.mapping.internal.SingleAttributeIdentifierMapping;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.DomainResultGraphNode;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchOptions;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesSourceProcessingOptions;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;
import org.hibernate.type.AnyType;
import org.hibernate.type.BasicType;
import org.hibernate.type.MetaType;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

public class DiscriminatedAssociationMapping
implements MappingType,
FetchOptions {
    private final DiscriminatedAssociationModelPart modelPart;
    private final AnyDiscriminatorPart discriminatorPart;
    private final BasicValuedModelPart keyPart;
    private final JavaTypeDescriptor<?> baseAssociationJtd;
    private final FetchTiming fetchTiming;
    private final LinkedList<ValueMapping> discriminatorValueMappings = new LinkedList();

    public static DiscriminatedAssociationMapping from(NavigableRole containerRole, JavaTypeDescriptor<?> baseAssociationJtd, DiscriminatedAssociationModelPart declaringModelPart, AnyType anyType, Any bootValueMapping, MappingModelCreationProcess creationProcess) {
        SessionFactoryImplementor sessionFactory = creationProcess.getCreationContext().getSessionFactory();
        JdbcEnvironment jdbcEnvironment = sessionFactory.getJdbcServices().getJdbcEnvironment();
        String tableName = jdbcEnvironment.getQualifiedObjectNameFormatter().format(bootValueMapping.getTable().getQualifiedTableName(), jdbcEnvironment.getDialect());
        assert (bootValueMapping.getColumnSpan() == 2);
        Iterator<Selectable> columnIterator = bootValueMapping.getColumnIterator();
        assert (columnIterator.hasNext());
        Selectable metaColumn = columnIterator.next();
        assert (columnIterator.hasNext());
        Selectable keyColumn = columnIterator.next();
        assert (!columnIterator.hasNext());
        assert (!metaColumn.isFormula());
        assert (!keyColumn.isFormula());
        AnyDiscriminatorPart discriminatorPart = new AnyDiscriminatorPart(containerRole.append("{discriminator}"), declaringModelPart, tableName, metaColumn.getText(jdbcEnvironment.getDialect()), bootValueMapping.isNullable(), (MetaType)anyType.getDiscriminatorType());
        BasicType keyType = (BasicType)anyType.getIdentifierType();
        AnyKeyPart keyPart = new AnyKeyPart(containerRole.append("{key}"), declaringModelPart, tableName, keyColumn.getText(jdbcEnvironment.getDialect()), bootValueMapping.isNullable(), keyType);
        return new DiscriminatedAssociationMapping(declaringModelPart, discriminatorPart, keyPart, baseAssociationJtd, bootValueMapping.isLazy() ? FetchTiming.DELAYED : FetchTiming.IMMEDIATE, bootValueMapping.getMetaValues(), sessionFactory);
    }

    public DiscriminatedAssociationMapping(DiscriminatedAssociationModelPart modelPart, AnyDiscriminatorPart discriminatorPart, BasicValuedModelPart keyPart, JavaTypeDescriptor<?> baseAssociationJtd, FetchTiming fetchTiming, Map<Object, String> discriminatorValueMappings, SessionFactoryImplementor sessionFactory) {
        this.modelPart = modelPart;
        this.discriminatorPart = discriminatorPart;
        this.keyPart = keyPart;
        this.baseAssociationJtd = baseAssociationJtd;
        this.fetchTiming = fetchTiming;
        RuntimeMetamodels runtimeMetamodels = sessionFactory.getRuntimeMetamodels();
        discriminatorValueMappings.forEach((value, entityName) -> this.discriminatorValueMappings.add(new ValueMapping(value, runtimeMetamodels.getEntityMappingType((String)entityName))));
    }

    public DiscriminatedAssociationModelPart getModelPart() {
        return this.modelPart;
    }

    public BasicValuedModelPart getDiscriminatorPart() {
        return this.discriminatorPart;
    }

    public BasicValuedModelPart getKeyPart() {
        return this.keyPart;
    }

    public Object resolveDiscriminatorValueToEntityMapping(EntityMappingType entityMappingType) {
        for (int i = 0; i < this.discriminatorValueMappings.size(); ++i) {
            ValueMapping valueMapping = this.discriminatorValueMappings.get(i);
            if (!valueMapping.entityMapping.equals(entityMappingType)) continue;
            return valueMapping.discriminatorValue;
        }
        return null;
    }

    public EntityMappingType resolveDiscriminatorValueToEntityMapping(Object discriminatorValue) {
        for (int i = 0; i < this.discriminatorValueMappings.size(); ++i) {
            ValueMapping valueMapping = this.discriminatorValueMappings.get(i);
            if (!valueMapping.discriminatorValue.equals(discriminatorValue)) continue;
            return valueMapping.entityMapping;
        }
        return null;
    }

    public void forEachConcreteType(Consumer<EntityMappingType> consumer) {
        this.discriminatorValueMappings.forEach(valueMapping -> consumer.accept(((ValueMapping)valueMapping).entityMapping));
    }

    public EntityMappingType findConcrete(Function<EntityMappingType, EntityMappingType> matcher) {
        for (ValueMapping discriminatorValueMapping : this.discriminatorValueMappings) {
            EntityMappingType matched = matcher.apply(discriminatorValueMapping.entityMapping);
            if (matched == null) continue;
            return matched;
        }
        return null;
    }

    public <T> T fromConcrete(Function<EntityMappingType, T> matcher) {
        for (ValueMapping discriminatorValueMapping : this.discriminatorValueMappings) {
            T matched = matcher.apply(discriminatorValueMapping.entityMapping);
            if (matched == null) continue;
            return matched;
        }
        return null;
    }

    public ModelPart findSubPart(String name, EntityMappingType treatTarget) {
        if ("{discriminator}".equals(name)) {
            return this.getDiscriminatorPart();
        }
        if ("{key}".equals(name)) {
            return this.getKeyPart();
        }
        if (treatTarget != null) {
            this.ensureMapped(treatTarget);
            return this.resolveAssociatedSubPart(name, treatTarget);
        }
        for (ValueMapping discriminatorValueMapping : this.discriminatorValueMappings) {
            try {
                ModelPart subPart = this.resolveAssociatedSubPart(name, discriminatorValueMapping.entityMapping);
                if (subPart == null) continue;
                return subPart;
            }
            catch (Exception e) {
            }
        }
        return null;
    }

    private ModelPart resolveAssociatedSubPart(String name, EntityMappingType entityMapping) {
        String idAttrName;
        EntityIdentifierMapping identifierMapping = entityMapping.getIdentifierMapping();
        if (identifierMapping.getPartName().equals(name)) {
            return this.getKeyPart();
        }
        if (identifierMapping instanceof SingleAttributeIdentifierMapping && (idAttrName = ((SingleAttributeIdentifierMapping)identifierMapping).getAttributeName()).equals(name)) {
            return this.getKeyPart();
        }
        return entityMapping.findSubPart(name);
    }

    private void ensureMapped(EntityMappingType treatTarget) {
        assert (treatTarget != null);
        for (ValueMapping mapping : this.discriminatorValueMappings) {
            if (!mapping.entityMapping.equals(treatTarget)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "Treat-target [`%s`] is not not an entity mapped by ANY value : %s", treatTarget.getEntityName(), this.modelPart.getNavigableRole()));
    }

    public MappingType getPartMappingType() {
        return this;
    }

    public JavaTypeDescriptor<?> getJavaTypeDescriptor() {
        return this.baseAssociationJtd;
    }

    @Override
    public JavaTypeDescriptor<?> getMappedJavaTypeDescriptor() {
        return this.baseAssociationJtd;
    }

    @Override
    public FetchStyle getStyle() {
        return FetchStyle.SELECT;
    }

    @Override
    public FetchTiming getTiming() {
        return this.fetchTiming;
    }

    public Fetch generateFetch(FetchParent fetchParent, NavigablePath fetchablePath, FetchTiming fetchTiming, boolean selected, LockMode lockMode, String resultVariable, DomainResultCreationState creationState) {
        return new AnyValuedFetch(fetchablePath, this.baseAssociationJtd, this.modelPart, fetchTiming, fetchParent, creationState);
    }

    public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        return new AnyValuedResult(navigablePath, this.baseAssociationJtd, this.modelPart, resultVariable);
    }

    private static class AnyResultAssembler<T>
    implements DomainResultAssembler<T> {
        private final NavigablePath fetchedPath;
        private final DiscriminatedAssociationModelPart fetchedPart;
        private final boolean eager;
        private final DomainResultAssembler<?> discriminatorValueAssembler;
        private final DomainResultAssembler<?> keyValueAssembler;

        public AnyResultAssembler(NavigablePath fetchedPath, DiscriminatedAssociationModelPart fetchedPart, boolean eager, DomainResultAssembler<?> discriminatorValueAssembler, DomainResultAssembler<?> keyValueAssembler) {
            this.fetchedPath = fetchedPath;
            this.fetchedPart = fetchedPart;
            this.eager = eager;
            this.discriminatorValueAssembler = discriminatorValueAssembler;
            this.keyValueAssembler = keyValueAssembler;
        }

        @Override
        public T assemble(RowProcessingState rowProcessingState, JdbcValuesSourceProcessingOptions options) {
            Object discriminatorValue = this.discriminatorValueAssembler.assemble(rowProcessingState, options);
            if (discriminatorValue == null) {
                assert (this.keyValueAssembler.assemble(rowProcessingState, options) == null);
                return null;
            }
            EntityMappingType entityMapping = this.fetchedPart.resolveDiscriminatorValue(discriminatorValue);
            Object keyValue = this.keyValueAssembler.assemble(rowProcessingState, options);
            SharedSessionContractImplementor session = rowProcessingState.getJdbcValuesSourceProcessingState().getSession();
            return (T)session.internalLoad(entityMapping.getEntityName(), keyValue, this.eager, false);
        }

        @Override
        public JavaTypeDescriptor<T> getAssembledJavaTypeDescriptor() {
            return this.fetchedPart.getJavaTypeDescriptor();
        }

        public String toString() {
            return "AnyResultAssembler( `" + this.fetchedPath + "` )";
        }
    }

    private static class AnyValuedFetch
    extends AnyValuedResultGraphNode
    implements Fetch {
        private final FetchTiming fetchTiming;
        private final FetchParent fetchParent;

        public AnyValuedFetch(NavigablePath navigablePath, JavaTypeDescriptor<?> baseAssociationJtd, DiscriminatedAssociationModelPart fetchedPart, FetchTiming fetchTiming, FetchParent fetchParent, DomainResultCreationState creationState) {
            super(navigablePath, fetchedPart, baseAssociationJtd);
            this.fetchTiming = fetchTiming;
            this.fetchParent = fetchParent;
            this.afterInitialize(creationState);
        }

        @Override
        public FetchParent getFetchParent() {
            return this.fetchParent;
        }

        @Override
        public DiscriminatedAssociationModelPart getFetchedMapping() {
            return this.getReferencedMappingContainer();
        }

        @Override
        public FetchTiming getTiming() {
            return this.fetchTiming;
        }

        @Override
        public boolean hasTableGroup() {
            return false;
        }

        @Override
        public DomainResult<?> asResult(DomainResultCreationState creationState) {
            throw new UnsupportedOperationException();
        }

        @Override
        public DomainResultAssembler<?> createAssembler(FetchParentAccess parentAccess, AssemblerCreationState creationState) {
            return new AnyResultAssembler(this.getNavigablePath(), this.getFetchedMapping(), this.fetchTiming == FetchTiming.IMMEDIATE, this.getDiscriminatorValueFetch().createAssembler(parentAccess, creationState), this.getKeyValueFetch().createAssembler(parentAccess, creationState));
        }
    }

    private static class AnyValuedResult<T>
    extends AnyValuedResultGraphNode
    implements DomainResult<T> {
        private final String resultVariable;

        public AnyValuedResult(NavigablePath navigablePath, JavaTypeDescriptor<?> baseAssociationJtd, DiscriminatedAssociationModelPart fetchedPart, String resultVariable) {
            super(navigablePath, fetchedPart, baseAssociationJtd);
            this.resultVariable = resultVariable;
        }

        @Override
        public String getResultVariable() {
            return this.resultVariable;
        }

        @Override
        public DomainResultAssembler<T> createResultAssembler(AssemblerCreationState creationState) {
            return new AnyResultAssembler(this.getNavigablePath(), this.getReferencedMappingContainer(), true, this.getDiscriminatorValueFetch().createAssembler(null, creationState), this.getKeyValueFetch().createAssembler(null, creationState));
        }
    }

    private static abstract class AnyValuedResultGraphNode
    implements DomainResultGraphNode,
    FetchParent {
        private final NavigablePath navigablePath;
        private final DiscriminatedAssociationModelPart graphedPart;
        private final JavaTypeDescriptor<?> baseAssociationJtd;
        private Fetch discriminatorValueFetch;
        private Fetch keyValueFetch;

        public AnyValuedResultGraphNode(NavigablePath navigablePath, DiscriminatedAssociationModelPart graphedPart, JavaTypeDescriptor<?> baseAssociationJtd) {
            this.navigablePath = navigablePath;
            this.graphedPart = graphedPart;
            this.baseAssociationJtd = baseAssociationJtd;
        }

        protected void afterInitialize(DomainResultCreationState creationState) {
            List<Fetch> fetches = creationState.visitFetches(this);
            assert (fetches.size() == 2);
            this.discriminatorValueFetch = fetches.get(0);
            this.keyValueFetch = fetches.get(1);
        }

        public Fetch getDiscriminatorValueFetch() {
            return this.discriminatorValueFetch;
        }

        public Fetch getKeyValueFetch() {
            return this.keyValueFetch;
        }

        public JavaTypeDescriptor<?> getBaseAssociationJtd() {
            return this.baseAssociationJtd;
        }

        @Override
        public NavigablePath getNavigablePath() {
            return this.navigablePath;
        }

        @Override
        public JavaTypeDescriptor<?> getResultJavaTypeDescriptor() {
            return this.baseAssociationJtd;
        }

        @Override
        public boolean containsAnyNonScalarResults() {
            return true;
        }

        @Override
        public DiscriminatedAssociationModelPart getReferencedMappingContainer() {
            return this.graphedPart;
        }

        @Override
        public DiscriminatedAssociationModelPart getReferencedMappingType() {
            return this.graphedPart;
        }

        @Override
        public List<Fetch> getFetches() {
            return Arrays.asList(this.discriminatorValueFetch, this.keyValueFetch);
        }

        @Override
        public Fetch findFetch(Fetchable fetchable) {
            assert (this.graphedPart.getDiscriminatorPart() == fetchable || this.graphedPart.getKeyPart() == fetchable);
            if (this.graphedPart.getDiscriminatorPart() == fetchable) {
                return this.discriminatorValueFetch;
            }
            if (this.graphedPart.getKeyPart() == fetchable) {
                return this.keyValueFetch;
            }
            throw new IllegalArgumentException("Given Fetchable [" + fetchable + "] did not match either discriminator nor key mapping");
        }
    }

    private static class ValueMapping {
        private final Object discriminatorValue;
        private final EntityMappingType entityMapping;

        public ValueMapping(Object discriminatorValue, EntityMappingType entityMapping) {
            this.discriminatorValue = discriminatorValue;
            this.entityMapping = entityMapping;
        }
    }
}

