/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.function.Consumer;
import org.hibernate.LockMode;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.mapping.Any;
import org.hibernate.mapping.IndexedConsumer;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.DiscriminatedAssociationModelPart;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.internal.DiscriminatedAssociationMapping;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchOptions;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.type.AnyType;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

public class DiscriminatedCollectionPart
implements DiscriminatedAssociationModelPart,
CollectionPart {
    private final CollectionPart.Nature nature;
    private final NavigableRole partRole;
    private final DiscriminatedAssociationMapping discriminatorMapping;

    public DiscriminatedCollectionPart(CollectionPart.Nature nature, NavigableRole collectionRole, JavaTypeDescriptor<Object> baseAssociationJtd, Any bootValueMapping, AnyType anyType, MappingModelCreationProcess creationProcess) {
        this.nature = nature;
        this.partRole = collectionRole.append(nature.getName());
        this.discriminatorMapping = DiscriminatedAssociationMapping.from(this.partRole, baseAssociationJtd, this, anyType, bootValueMapping, creationProcess);
    }

    @Override
    public CollectionPart.Nature getNature() {
        return this.nature;
    }

    @Override
    public BasicValuedModelPart getDiscriminatorPart() {
        return this.discriminatorMapping.getDiscriminatorPart();
    }

    @Override
    public BasicValuedModelPart getKeyPart() {
        return this.discriminatorMapping.getKeyPart();
    }

    @Override
    public EntityMappingType resolveDiscriminatorValue(Object discriminatorValue) {
        return this.discriminatorMapping.resolveDiscriminatorValueToEntityMapping(discriminatorValue);
    }

    @Override
    public Object resolveDiscriminatorForEntityType(EntityMappingType entityMappingType) {
        return this.discriminatorMapping.resolveDiscriminatorValueToEntityMapping(entityMappingType);
    }

    @Override
    public String getFetchableName() {
        return this.nature.getName();
    }

    @Override
    public FetchOptions getMappedFetchOptions() {
        return this.discriminatorMapping;
    }

    public String toString() {
        return "DiscriminatedCollectionPart(" + this.getNavigableRole() + ")@" + System.identityHashCode(this);
    }

    @Override
    public Fetch generateFetch(FetchParent fetchParent, NavigablePath fetchablePath, FetchTiming fetchTiming, boolean selected, LockMode lockMode, String resultVariable, DomainResultCreationState creationState) {
        return this.discriminatorMapping.generateFetch(fetchParent, fetchablePath, fetchTiming, selected, lockMode, resultVariable, creationState);
    }

    @Override
    public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        return this.discriminatorMapping.createDomainResult(navigablePath, tableGroup, resultVariable, creationState);
    }

    @Override
    public MappingType getPartMappingType() {
        return this.discriminatorMapping;
    }

    @Override
    public JavaTypeDescriptor<?> getJavaTypeDescriptor() {
        return this.discriminatorMapping.getJavaTypeDescriptor();
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.partRole;
    }

    @Override
    public EntityMappingType findContainingEntityMapping() {
        return this.discriminatorMapping.getModelPart().findContainingEntityMapping();
    }

    @Override
    public ModelPart findSubPart(String name, EntityMappingType treatTargetType) {
        return this.discriminatorMapping.findSubPart(name, treatTargetType);
    }

    @Override
    public void visitSubParts(Consumer<ModelPart> consumer, EntityMappingType treatTargetType) {
        consumer.accept(this.getDiscriminatorPart());
        consumer.accept(this.getKeyPart());
    }

    @Override
    public int getNumberOfFetchables() {
        return 2;
    }

    @Override
    public int getJdbcTypeCount() {
        return this.getDiscriminatorPart().getJdbcTypeCount() + this.getKeyPart().getJdbcTypeCount();
    }

    @Override
    public void breakDownJdbcValues(Object domainValue, ModelPart.JdbcValueConsumer valueConsumer, SharedSessionContractImplementor session) {
        this.discriminatorMapping.getDiscriminatorPart().breakDownJdbcValues(domainValue, valueConsumer, session);
    }

    @Override
    public int forEachJdbcType(int offset, IndexedConsumer<JdbcMapping> action) {
        int span = this.getDiscriminatorPart().forEachJdbcType(offset, action);
        return span + this.getKeyPart().forEachJdbcType(offset + span, action);
    }
}

