/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.ArrayList;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.hibernate.LockMode;
import org.hibernate.engine.FetchStrategy;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.ManagedMappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.SelectableConsumer;
import org.hibernate.metamodel.mapping.SelectableMappings;
import org.hibernate.metamodel.mapping.StateArrayContributorMetadataAccess;
import org.hibernate.metamodel.mapping.internal.AbstractSingularAttributeMapping;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.property.access.internal.PropertyAccessStrategyBasicImpl;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.spi.SqlAliasBaseGenerator;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.from.CompositeTableGroup;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.graph.embeddable.EmbeddableValuedFetchable;
import org.hibernate.sql.results.graph.embeddable.internal.EmbeddableFetchImpl;
import org.hibernate.sql.results.graph.embeddable.internal.EmbeddableResultImpl;

public class EmbeddedAttributeMapping
extends AbstractSingularAttributeMapping
implements EmbeddableValuedFetchable,
Fetchable {
    private final NavigableRole navigableRole;
    private final String tableExpression;
    private final EmbeddableMappingType embeddableMappingType;
    private final PropertyAccess parentInjectionAttributePropertyAccess;

    public EmbeddedAttributeMapping(String name, NavigableRole navigableRole, int stateArrayPosition, String tableExpression, StateArrayContributorMetadataAccess attributeMetadataAccess, String parentInjectionAttributeName, FetchStrategy mappedFetchStrategy, EmbeddableMappingType embeddableMappingType, ManagedMappingType declaringType, PropertyAccess propertyAccess) {
        super(name, stateArrayPosition, attributeMetadataAccess, mappedFetchStrategy, declaringType, propertyAccess);
        this.navigableRole = navigableRole;
        this.parentInjectionAttributePropertyAccess = parentInjectionAttributeName != null ? PropertyAccessStrategyBasicImpl.INSTANCE.buildPropertyAccess(embeddableMappingType.getMappedJavaTypeDescriptor().getJavaTypeClass(), parentInjectionAttributeName) : null;
        this.tableExpression = tableExpression;
        this.embeddableMappingType = embeddableMappingType;
    }

    private EmbeddedAttributeMapping(SelectableMappings selectableMappings, EmbeddableValuedModelPart inverseModelPart, MappingModelCreationProcess creationProcess) {
        super(inverseModelPart.getFetchableName(), -1, null, inverseModelPart.getMappedFetchOptions(), null, null);
        this.navigableRole = inverseModelPart.getNavigableRole().getParent().append(inverseModelPart.getFetchableName());
        this.tableExpression = selectableMappings.getSelectable(0).getContainingTableExpression();
        this.embeddableMappingType = inverseModelPart.getEmbeddableTypeDescriptor().createInverseMappingType(this, selectableMappings, creationProcess);
        this.parentInjectionAttributePropertyAccess = null;
    }

    public static EmbeddableValuedModelPart createInverseModelPart(EmbeddableValuedModelPart modelPart, SelectableMappings selectableMappings, MappingModelCreationProcess creationProcess) {
        return new EmbeddedAttributeMapping(selectableMappings, modelPart, creationProcess);
    }

    @Override
    public EmbeddableMappingType getMappedType() {
        return this.getEmbeddableTypeDescriptor();
    }

    @Override
    public EmbeddableMappingType getEmbeddableTypeDescriptor() {
        return this.embeddableMappingType;
    }

    @Override
    public String getContainingTableExpression() {
        return this.tableExpression;
    }

    @Override
    public PropertyAccess getParentInjectionAttributePropertyAccess() {
        return this.parentInjectionAttributePropertyAccess;
    }

    @Override
    public int forEachSelectable(int offset, SelectableConsumer consumer) {
        return this.getEmbeddableTypeDescriptor().forEachSelectable(offset, consumer);
    }

    @Override
    public void breakDownJdbcValues(Object domainValue, ModelPart.JdbcValueConsumer valueConsumer, SharedSessionContractImplementor session) {
        this.getEmbeddableTypeDescriptor().breakDownJdbcValues(domainValue, valueConsumer, session);
    }

    @Override
    public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        return new EmbeddableResultImpl(navigablePath, this, resultVariable, creationState);
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState) {
        this.embeddableMappingType.applySqlSelections(navigablePath, tableGroup, creationState);
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState, BiConsumer<SqlSelection, JdbcMapping> selectionConsumer) {
        this.embeddableMappingType.applySqlSelections(navigablePath, tableGroup, creationState, selectionConsumer);
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.navigableRole;
    }

    @Override
    public Fetch resolveCircularFetch(NavigablePath fetchablePath, FetchParent fetchParent, DomainResultCreationState creationState) {
        return null;
    }

    @Override
    public Fetch generateFetch(FetchParent fetchParent, NavigablePath fetchablePath, FetchTiming fetchTiming, boolean selected, LockMode lockMode, String resultVariable, DomainResultCreationState creationState) {
        return new EmbeddableFetchImpl(fetchablePath, this, fetchParent, fetchTiming, selected, this.getAttributeMetadataAccess().resolveAttributeMetadata(null).isNullable(), creationState);
    }

    @Override
    public SqlTuple toSqlExpression(TableGroup tableGroup, Clause clause, SqmToSqlAstConverter walker, SqlAstCreationState sqlAstCreationState) {
        ArrayList columnReferences = CollectionHelper.arrayList(this.embeddableMappingType.getJdbcTypeCount());
        NavigablePath navigablePath = tableGroup.getNavigablePath().append(this.getNavigableRole().getNavigableName());
        TableReference defaultTableReference = tableGroup.resolveTableReference(navigablePath, this.getContainingTableExpression());
        this.getEmbeddableTypeDescriptor().forEachSelectable((columnIndex, selection) -> {
            TableReference tableReference = selection.getContainingTableExpression().equals(defaultTableReference.getTableExpression()) ? defaultTableReference : tableGroup.resolveTableReference(navigablePath, selection.getContainingTableExpression());
            Expression columnReference = sqlAstCreationState.getSqlExpressionResolver().resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableReference, selection.getSelectionExpression()), sqlAstProcessingState -> new ColumnReference(tableReference.getIdentificationVariable(), selection, sqlAstCreationState.getCreationContext().getSessionFactory()));
            columnReferences.add(columnReference.unwrap(ColumnReference.class));
        });
        return new SqlTuple(columnReferences, this);
    }

    @Override
    public ModelPart findSubPart(String name, EntityMappingType treatTargetType) {
        return this.getMappedType().findSubPart(name, treatTargetType);
    }

    @Override
    public void visitSubParts(Consumer<ModelPart> consumer, EntityMappingType treatTargetType) {
        this.getMappedType().visitSubParts(consumer, treatTargetType);
    }

    @Override
    public TableGroupJoin createTableGroupJoin(NavigablePath navigablePath, TableGroup lhs, String explicitSourceAlias, SqlAstJoinType sqlAstJoinType, boolean fetched, LockMode lockMode, SqlAliasBaseGenerator aliasBaseGenerator, SqlExpressionResolver sqlExpressionResolver, SqlAstCreationContext creationContext) {
        CompositeTableGroup compositeTableGroup = new CompositeTableGroup(navigablePath, this, lhs);
        TableGroupJoin tableGroupJoin = new TableGroupJoin(navigablePath, sqlAstJoinType, compositeTableGroup);
        lhs.addTableGroupJoin(tableGroupJoin);
        return tableGroupJoin;
    }

    @Override
    public String getSqlAliasStem() {
        return this.getAttributeName();
    }

    @Override
    public int getNumberOfFetchables() {
        return this.getEmbeddableTypeDescriptor().getNumberOfAttributeMappings();
    }

    public String toString() {
        return "EmbeddedAttributeMapping(" + this.navigableRole + ")@" + System.identityHashCode(this);
    }
}

