/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.List;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.internal.AbstractCompositeIdentifierMapping;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.SingularAttributeMapping;
import org.hibernate.metamodel.mapping.StateArrayContributorMetadataAccess;
import org.hibernate.metamodel.mapping.internal.SingleAttributeIdentifierMapping;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.sql.ast.Clause;

public class EmbeddedIdentifierMappingImpl
extends AbstractCompositeIdentifierMapping
implements SingleAttributeIdentifierMapping {
    private final String name;
    private final PropertyAccess propertyAccess;

    public EmbeddedIdentifierMappingImpl(EntityMappingType entityMapping, String name, EmbeddableMappingType embeddableDescriptor, StateArrayContributorMetadataAccess attributeMetadataAccess, PropertyAccess propertyAccess, String tableExpression, SessionFactoryImplementor sessionFactory) {
        super(attributeMetadataAccess, embeddableDescriptor, entityMapping, tableExpression, sessionFactory);
        this.name = name;
        this.propertyAccess = propertyAccess;
    }

    @Override
    public String getPartName() {
        return this.name;
    }

    @Override
    public Object getIdentifier(Object entity, SharedSessionContractImplementor session) {
        if (entity instanceof HibernateProxy) {
            return ((HibernateProxy)entity).getHibernateLazyInitializer().getIdentifier();
        }
        return this.propertyAccess.getGetter().get(entity);
    }

    @Override
    public void setIdentifier(Object entity, Object id, SharedSessionContractImplementor session) {
        this.propertyAccess.getSetter().set(entity, id, session.getFactory());
    }

    @Override
    public String getSqlAliasStem() {
        return this.name;
    }

    @Override
    public String getFetchableName() {
        return this.name;
    }

    @Override
    public int getNumberOfFetchables() {
        return this.getEmbeddableTypeDescriptor().getNumberOfAttributeMappings();
    }

    @Override
    public int getAttributeCount() {
        return this.getEmbeddableTypeDescriptor().getNumberOfAttributeMappings();
    }

    @Override
    public List<SingularAttributeMapping> getAttributes() {
        return this.getEmbeddableTypeDescriptor().getAttributeMappings();
    }

    @Override
    public PropertyAccess getPropertyAccess() {
        return this.propertyAccess;
    }

    @Override
    public String getAttributeName() {
        return this.name;
    }

    @Override
    public void breakDownJdbcValues(Object domainValue, ModelPart.JdbcValueConsumer valueConsumer, SharedSessionContractImplementor session) {
        this.getEmbeddableTypeDescriptor().breakDownJdbcValues(domainValue, valueConsumer, session);
    }

    @Override
    public int forEachDisassembledJdbcValue(Object value, Clause clause, int offset, Bindable.JdbcValuesConsumer valuesConsumer, SharedSessionContractImplementor session) {
        return this.getEmbeddableTypeDescriptor().forEachDisassembledJdbcValue(value, clause, offset, valuesConsumer, session);
    }

    @Override
    public Object disassemble(Object value, SharedSessionContractImplementor session) {
        Object[] result = new Object[this.getAttributeCount()];
        this.forEachAttribute((i, mapping) -> {
            Object o = mapping.getPropertyAccess().getGetter().get(value);
            result[i] = mapping.disassemble(o, session);
        });
        return result;
    }
}

