/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.function.BiConsumer;
import org.hibernate.LockMode;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Value;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.EntityAssociationMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.SelectableConsumer;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.spi.FromClauseAccess;
import org.hibernate.sql.ast.spi.SqlAliasBaseGenerator;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchOptions;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.collection.internal.EntityCollectionPartTableGroup;
import org.hibernate.sql.results.graph.entity.EntityFetch;
import org.hibernate.sql.results.graph.entity.EntityValuedFetchable;
import org.hibernate.sql.results.graph.entity.internal.EntityFetchJoinedImpl;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

public class EntityCollectionPart
implements CollectionPart,
EntityAssociationMapping,
EntityValuedFetchable,
FetchOptions {
    private final NavigableRole navigableRole;
    private final CollectionPersister collectionDescriptor;
    private final CollectionPart.Nature nature;
    private final EntityMappingType entityMappingType;
    private ModelPart fkTargetModelPart;

    public EntityCollectionPart(CollectionPersister collectionDescriptor, CollectionPart.Nature nature, Value bootModelValue, EntityMappingType entityMappingType, MappingModelCreationProcess creationProcess) {
        this.navigableRole = collectionDescriptor.getNavigableRole().appendContainer(nature.getName());
        this.collectionDescriptor = collectionDescriptor;
        this.nature = nature;
        this.entityMappingType = entityMappingType;
    }

    public void finishInitialization(CollectionPersister collectionDescriptor, Collection bootValueMapping, String fkTargetModelPartName, MappingModelCreationProcess creationProcess) {
        this.fkTargetModelPart = fkTargetModelPartName == null ? this.entityMappingType.getIdentifierMapping() : this.entityMappingType.findSubPart(fkTargetModelPartName, null);
    }

    @Override
    public CollectionPart.Nature getNature() {
        return this.nature;
    }

    @Override
    public MappingType getPartMappingType() {
        return this.getEntityMappingType();
    }

    @Override
    public EntityMappingType getEntityMappingType() {
        return this.entityMappingType;
    }

    @Override
    public EntityMappingType getAssociatedEntityMappingType() {
        return this.getEntityMappingType();
    }

    @Override
    public ModelPart getKeyTargetMatchPart() {
        return this.fkTargetModelPart;
    }

    @Override
    public JavaTypeDescriptor<?> getJavaTypeDescriptor() {
        return this.getEntityMappingType().getJavaTypeDescriptor();
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.navigableRole;
    }

    @Override
    public String getFetchableName() {
        return this.nature.getName();
    }

    @Override
    public FetchOptions getMappedFetchOptions() {
        return this;
    }

    @Override
    public Fetch resolveCircularFetch(NavigablePath fetchablePath, FetchParent fetchParent, DomainResultCreationState creationState) {
        return null;
    }

    @Override
    public EntityFetch generateFetch(FetchParent fetchParent, NavigablePath fetchablePath, FetchTiming fetchTiming, boolean selected, LockMode lockMode, String resultVariable, DomainResultCreationState creationState) {
        FromClauseAccess fromClauseAccess = creationState.getSqlAstCreationState().getFromClauseAccess();
        creationState.registerVisitedAssociationKey(this.getForeignKeyDescriptor().getAssociationKey());
        TableGroup tableGroup = fromClauseAccess.resolveTableGroup(fetchablePath, np -> {
            TableGroup collectionTableGroup = fromClauseAccess.getTableGroup(fetchParent.getNavigablePath());
            assert (collectionTableGroup != null);
            return new EntityCollectionPartTableGroup(fetchablePath, collectionTableGroup, this);
        });
        return new EntityFetchJoinedImpl(fetchParent, this, tableGroup, lockMode, selected, fetchablePath, creationState);
    }

    @Override
    public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        return this.fkTargetModelPart.createDomainResult(navigablePath, tableGroup, resultVariable, creationState);
    }

    @Override
    public int forEachSelectable(int offset, SelectableConsumer consumer) {
        return this.entityMappingType.forEachSelectable(offset, consumer);
    }

    @Override
    public void breakDownJdbcValues(Object domainValue, ModelPart.JdbcValueConsumer valueConsumer, SharedSessionContractImplementor session) {
        this.fkTargetModelPart.breakDownJdbcValues(domainValue, valueConsumer, session);
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState) {
        this.entityMappingType.applySqlSelections(navigablePath, tableGroup, creationState);
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState, BiConsumer<SqlSelection, JdbcMapping> selectionConsumer) {
        this.entityMappingType.applySqlSelections(navigablePath, tableGroup, creationState, selectionConsumer);
    }

    @Override
    public EntityMappingType findContainingEntityMapping() {
        return this.collectionDescriptor.getAttributeMapping().findContainingEntityMapping();
    }

    @Override
    public int getNumberOfFetchables() {
        return this.entityMappingType.getNumberOfFetchables();
    }

    public String getMappedBy() {
        return this.collectionDescriptor.getMappedByProperty();
    }

    public String toString() {
        return "EntityCollectionPart(" + this.navigableRole + ")@" + System.identityHashCode(this);
    }

    @Override
    public ForeignKeyDescriptor getForeignKeyDescriptor() {
        return this.collectionDescriptor.getAttributeMapping().getKeyDescriptor();
    }

    @Override
    public ForeignKeyDescriptor.Nature getSideNature() {
        return ForeignKeyDescriptor.Nature.TARGET;
    }

    @Override
    public FetchStyle getStyle() {
        return FetchStyle.JOIN;
    }

    @Override
    public FetchTiming getTiming() {
        return FetchTiming.IMMEDIATE;
    }

    @Override
    public TableGroupJoin createTableGroupJoin(NavigablePath navigablePath, TableGroup lhs, String explicitSourceAlias, SqlAstJoinType sqlAstJoinType, boolean fetched, LockMode lockMode, SqlAliasBaseGenerator aliasBaseGenerator, SqlExpressionResolver sqlExpressionResolver, SqlAstCreationContext creationContext) {
        return this.collectionDescriptor.getAttributeMapping().createTableGroupJoin(navigablePath, lhs, explicitSourceAlias, sqlAstJoinType, fetched, lockMode, aliasBaseGenerator, sqlExpressionResolver, creationContext);
    }

    @Override
    public String getSqlAliasStem() {
        return this.collectionDescriptor.getAttributeMapping().getSqlAliasStem();
    }

    @Override
    public boolean containsTableReference(String tableExpression) {
        return this.collectionDescriptor.getAttributeMapping().containsTableReference(tableExpression);
    }
}

