/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.mapping.IndexedConsumer;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.internal.AbstractEntityDiscriminatorMapping;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.persister.entity.DiscriminatorType;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.type.BasicType;

public class EntityDiscriminatorMappingImpl
extends AbstractEntityDiscriminatorMapping {
    private final NavigableRole navigableRole;

    public EntityDiscriminatorMappingImpl(EntityPersister entityDescriptor, String tableExpression, String mappedColumnExpression, boolean isFormula, DiscriminatorType<?> mappingType) {
        super(entityDescriptor, tableExpression, mappedColumnExpression, isFormula, mappingType);
        this.navigableRole = entityDescriptor.getNavigableRole().append("{discriminator}");
    }

    @Override
    protected SqlSelection resolveSqlSelection(TableGroup tableGroup, boolean underlyingType, DomainResultCreationState creationState) {
        SqlExpressionResolver expressionResolver = creationState.getSqlAstCreationState().getSqlExpressionResolver();
        TableReference tableReference = tableGroup.resolveTableReference(tableGroup.getNavigablePath().append(this.getNavigableRole().getNavigableName()), this.getContainingTableExpression());
        BasicType<?> type = underlyingType ? ((DiscriminatorType)this.getMappedType()).getUnderlyingType() : this.getMappedType();
        return expressionResolver.resolveSqlSelection(expressionResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableReference, this.getSelectionExpression()), sqlAstProcessingState -> new ColumnReference(tableReference.getIdentificationVariable(), this, (JdbcMapping)type, creationState.getSqlAstCreationState().getCreationContext().getSessionFactory())), type.getMappedJavaTypeDescriptor(), creationState.getSqlAstCreationState().getCreationContext().getDomainModel().getTypeConfiguration());
    }

    @Override
    public int forEachDisassembledJdbcValue(Object value, Clause clause, int offset, Bindable.JdbcValuesConsumer valuesConsumer, SharedSessionContractImplementor session) {
        valuesConsumer.consume(offset, value, this.getJdbcMapping());
        return this.getJdbcTypeCount();
    }

    @Override
    public int forEachJdbcType(int offset, IndexedConsumer<JdbcMapping> action) {
        action.accept(offset, this.getJdbcMapping());
        return this.getJdbcTypeCount();
    }

    @Override
    public Object disassemble(Object value, SharedSessionContractImplementor session) {
        return value;
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.navigableRole;
    }

    @Override
    public void breakDownJdbcValues(Object domainValue, ModelPart.JdbcValueConsumer valueConsumer, SharedSessionContractImplementor session) {
        valueConsumer.consume(domainValue, this);
    }

    @Override
    public EntityMappingType findContainingEntityMapping() {
        return this.getEntityDescriptor();
    }

    @Override
    public String getCustomReadExpression() {
        return null;
    }

    @Override
    public String getCustomWriteExpression() {
        return null;
    }
}

