/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.function.BiConsumer;
import org.hibernate.FetchMode;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.SharedSessionContract;
import org.hibernate.boot.model.source.internal.hbm.MappingDocument;
import org.hibernate.collection.internal.StandardArraySemantics;
import org.hibernate.collection.internal.StandardBagSemantics;
import org.hibernate.collection.internal.StandardIdentifierBagSemantics;
import org.hibernate.collection.internal.StandardListSemantics;
import org.hibernate.collection.spi.CollectionSemantics;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.FetchStrategy;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.spi.CascadeStyle;
import org.hibernate.engine.spi.CascadeStyles;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Any;
import org.hibernate.mapping.BasicValue;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.IndexedCollection;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.OneToOne;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Resolvable;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.Value;
import org.hibernate.metamodel.CollectionClassification;
import org.hibernate.metamodel.MappingMetamodel;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.CollectionMappingType;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.CompositeIdentifierMapping;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.ManagedMappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.NonTransientException;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.PropertyBasedMapping;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.SelectableMappings;
import org.hibernate.metamodel.mapping.SingularAttributeMapping;
import org.hibernate.metamodel.mapping.StateArrayContributorMetadata;
import org.hibernate.metamodel.mapping.StateArrayContributorMetadataAccess;
import org.hibernate.metamodel.mapping.internal.AbstractAttributeMapping;
import org.hibernate.metamodel.mapping.internal.AbstractSingularAttributeMapping;
import org.hibernate.metamodel.mapping.internal.BasicAttributeMapping;
import org.hibernate.metamodel.mapping.internal.BasicValuedCollectionPart;
import org.hibernate.metamodel.mapping.internal.CollectionIdentifierDescriptorImpl;
import org.hibernate.metamodel.mapping.internal.DiscriminatedCollectionPart;
import org.hibernate.metamodel.mapping.internal.EmbeddedAttributeMapping;
import org.hibernate.metamodel.mapping.internal.EmbeddedCollectionPart;
import org.hibernate.metamodel.mapping.internal.EmbeddedForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.internal.EmbeddedIdentifierMappingImpl;
import org.hibernate.metamodel.mapping.internal.EntityCollectionPart;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.metamodel.mapping.internal.NonAggregatedIdentifierMappingImpl;
import org.hibernate.metamodel.mapping.internal.PluralAttributeMappingImpl;
import org.hibernate.metamodel.mapping.internal.SelectableMappingImpl;
import org.hibernate.metamodel.mapping.internal.SelectableMappingsImpl;
import org.hibernate.metamodel.mapping.internal.SimpleForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.metamodel.model.convert.spi.BasicValueConverter;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.collection.SQLLoadableCollection;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.persister.walking.internal.FetchStrategyHelper;
import org.hibernate.property.access.internal.PropertyAccessStrategyMapImpl;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.sql.ast.spi.SqlAliasStemHelper;
import org.hibernate.type.AnyType;
import org.hibernate.type.AssociationType;
import org.hibernate.type.BasicType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.ComponentType;
import org.hibernate.type.CompositeType;
import org.hibernate.type.EntityType;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.java.ImmutableMutabilityPlan;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptorRegistry;
import org.hibernate.type.spi.TypeConfiguration;

public class MappingModelCreationHelper {
    private MappingModelCreationHelper() {
    }

    public static EntityIdentifierMapping buildEncapsulatedCompositeIdentifierMapping(EntityPersister entityPersister, Property bootProperty, String attributeName, String rootTableName, String[] rootTableKeyColumnNames, CompositeType cidType, MappingModelCreationProcess creationProcess) {
        PersistentClass bootEntityDescriptor = creationProcess.getCreationContext().getBootModel().getEntityBinding(entityPersister.getEntityName());
        PropertyAccess propertyAccess = entityPersister.getRepresentationStrategy().resolvePropertyAccess(bootEntityDescriptor.getIdentifierProperty());
        StateArrayContributorMetadataAccess attributeMetadataAccess = MappingModelCreationHelper.getStateArrayContributorMetadataAccess(propertyAccess);
        EmbeddableMappingType embeddableMappingType = EmbeddableMappingType.from((Component)bootProperty.getValue(), cidType, rootTableName, rootTableKeyColumnNames, embeddable -> new EmbeddedIdentifierMappingImpl(entityPersister, attributeName, (EmbeddableMappingType)embeddable, attributeMetadataAccess, propertyAccess, rootTableName, creationProcess.getCreationContext().getSessionFactory()), creationProcess);
        return (EmbeddedIdentifierMappingImpl)embeddableMappingType.getEmbeddedValueMapping();
    }

    public static CompositeIdentifierMapping buildNonEncapsulatedCompositeIdentifierMapping(EntityPersister entityPersister, String rootTableName, String[] rootTableKeyColumnNames, CompositeType cidType, PersistentClass bootEntityDescriptor, BiConsumer<String, SingularAttributeMapping> idSubAttributeConsumer, MappingModelCreationProcess creationProcess) {
        Component bootIdClassComponent = (Component)bootEntityDescriptor.getIdentifier();
        EmbeddableMappingType embeddableMappingType = EmbeddableMappingType.from(bootIdClassComponent, cidType, rootTableName, rootTableKeyColumnNames, attributeMappingType -> {
            SessionFactoryImplementor sessionFactory = creationProcess.getCreationContext().getSessionFactory();
            PropertyAccess propertyAccess = PropertyAccessStrategyMapImpl.INSTANCE.buildPropertyAccess(null, "{id}");
            StateArrayContributorMetadataAccess attributeMetadataAccess = MappingModelCreationHelper.getStateArrayContributorMetadataAccess(propertyAccess);
            Component bootComponentDescriptor = bootEntityDescriptor.getIdentifierMapper();
            if (bootComponentDescriptor == null) {
                bootComponentDescriptor = bootIdClassComponent;
            }
            ArrayList<SingularAttributeMapping> idAttributeMappings = new ArrayList<SingularAttributeMapping>(bootComponentDescriptor.getPropertySpan());
            Iterator<Property> bootIdSubPropertyItr = bootComponentDescriptor.getPropertyIterator();
            int columnsConsumedSoFar = 0;
            while (bootIdSubPropertyItr.hasNext()) {
                AbstractSingularAttributeMapping idSubAttribute;
                Property bootIdSubProperty = bootIdSubPropertyItr.next();
                Type idSubPropertyType = bootIdSubProperty.getType();
                if (idSubPropertyType instanceof AnyType) {
                    throw new HibernateException("AnyType property `" + bootEntityDescriptor.getEntityName() + "#" + bootIdSubProperty.getName() + "` cannot be used as part of entity identifier ");
                }
                if (idSubPropertyType instanceof CollectionType) {
                    throw new HibernateException("Plural property `" + bootEntityDescriptor.getEntityName() + "#" + bootIdSubProperty.getName() + "` cannot be used as part of entity identifier ");
                }
                if (idSubPropertyType instanceof BasicType) {
                    idSubAttribute = MappingModelCreationHelper.buildBasicAttributeMapping(bootIdSubProperty.getName(), entityPersister.getNavigableRole().append(bootIdSubProperty.getName()), idAttributeMappings.size(), bootIdSubProperty, attributeMappingType, (BasicType)idSubPropertyType, rootTableName, rootTableKeyColumnNames[columnsConsumedSoFar], false, null, null, entityPersister.getRepresentationStrategy().resolvePropertyAccess(bootIdSubProperty), CascadeStyles.ALL, creationProcess);
                    ++columnsConsumedSoFar;
                } else {
                    if (idSubPropertyType instanceof CompositeType) {
                        throw new NotYetImplementedFor6Exception();
                    }
                    if (idSubPropertyType instanceof EntityType) {
                        EntityType keyManyToOnePropertyType = (EntityType)idSubPropertyType;
                        idSubAttribute = MappingModelCreationHelper.buildSingularAssociationAttributeMapping(bootIdSubProperty.getName(), entityPersister.getNavigableRole().append("{id}"), idAttributeMappings.size(), bootIdSubProperty, attributeMappingType, entityPersister, keyManyToOnePropertyType, entityPersister.getRepresentationStrategy().resolvePropertyAccess(bootIdSubProperty), CascadeStyles.ALL, creationProcess);
                        columnsConsumedSoFar += keyManyToOnePropertyType.getColumnSpan(sessionFactory);
                    } else {
                        throw new UnsupportedOperationException();
                    }
                }
                idAttributeMappings.add(idSubAttribute);
                if (bootComponentDescriptor != null) continue;
                idSubAttributeConsumer.accept(idSubAttribute.getAttributeName(), idSubAttribute);
            }
            return new NonAggregatedIdentifierMappingImpl((EmbeddableMappingType)attributeMappingType, entityPersister, (List<SingularAttributeMapping>)idAttributeMappings, attributeMetadataAccess, rootTableName, bootIdClassComponent, bootComponentDescriptor, creationProcess);
        }, creationProcess);
        return (CompositeIdentifierMapping)((Object)embeddableMappingType.getEmbeddedValueMapping());
    }

    public static BasicAttributeMapping buildBasicAttributeMapping(String attrName, NavigableRole navigableRole, int stateArrayPosition, final Property bootProperty, ManagedMappingType declaringType, BasicType attrType, String tableExpression, String attrColumnName, boolean isAttrFormula, String readExpr, String writeExpr, final PropertyAccess propertyAccess, final CascadeStyle cascadeStyle, MappingModelCreationProcess creationProcess) {
        FetchStrategy fetchStrategy;
        final Value value = bootProperty.getValue();
        final BasicValue.Resolution<?> resolution = ((Resolvable)((Object)value)).resolve();
        BasicValueConverter valueConverter = resolution.getValueConverter();
        StateArrayContributorMetadataAccess attributeMetadataAccess = entityMappingType -> new StateArrayContributorMetadata(){
            private final MutabilityPlan mutabilityPlan;
            private final boolean nullable;
            private final boolean insertable;
            private final boolean updateable;
            private final boolean includeInOptimisticLocking;
            {
                this.mutabilityPlan = resolution.getMutabilityPlan();
                this.nullable = value.isNullable();
                this.insertable = bootProperty.isInsertable();
                this.updateable = bootProperty.isUpdateable();
                this.includeInOptimisticLocking = bootProperty.isOptimisticLocked();
            }

            @Override
            public PropertyAccess getPropertyAccess() {
                return propertyAccess;
            }

            @Override
            public MutabilityPlan getMutabilityPlan() {
                return this.mutabilityPlan;
            }

            @Override
            public boolean isNullable() {
                return this.nullable;
            }

            @Override
            public boolean isInsertable() {
                return this.insertable;
            }

            @Override
            public boolean isUpdatable() {
                return this.updateable;
            }

            @Override
            public boolean isIncludedInDirtyChecking() {
                return this.updateable;
            }

            @Override
            public boolean isIncludedInOptimisticLocking() {
                return this.includeInOptimisticLocking;
            }

            @Override
            public CascadeStyle getCascadeStyle() {
                return cascadeStyle;
            }
        };
        FetchStrategy fetchStrategy2 = fetchStrategy = bootProperty.isLazy() ? new FetchStrategy(FetchTiming.DELAYED, FetchStyle.SELECT) : FetchStrategy.IMMEDIATE_JOIN;
        if (valueConverter != null) {
            if (isAttrFormula) {
                throw new MappingException(String.format("Value converter should not be set for column [%s] annotated with @Formula [%s]", attrName, attrColumnName));
            }
            assert (valueConverter.getRelationalJavaDescriptor() == resolution.getRelationalJavaDescriptor());
            BasicType mappingBasicType = creationProcess.getCreationContext().getDomainModel().getTypeConfiguration().getBasicTypeRegistry().resolve(valueConverter.getRelationalJavaDescriptor(), resolution.getJdbcTypeDescriptor());
            return new BasicAttributeMapping(attrName, navigableRole, stateArrayPosition, attributeMetadataAccess, fetchStrategy, tableExpression, attrColumnName, false, null, null, valueConverter, mappingBasicType.getJdbcMapping(), declaringType, propertyAccess);
        }
        return new BasicAttributeMapping(attrName, navigableRole, stateArrayPosition, attributeMetadataAccess, fetchStrategy, tableExpression, attrColumnName, isAttrFormula, readExpr, writeExpr, null, attrType, declaringType, propertyAccess);
    }

    public static EmbeddedAttributeMapping buildEmbeddedAttributeMapping(String attrName, int stateArrayPosition, Property bootProperty, ManagedMappingType declaringType, CompositeType attrType, String tableExpression, String[] rootTableKeyColumnNames, PropertyAccess propertyAccess, CascadeStyle cascadeStyle, MappingModelCreationProcess creationProcess) {
        StateArrayContributorMetadataAccess attributeMetadataAccess = MappingModelCreationHelper.getStateArrayContributorMetadataAccess(bootProperty, attrType, propertyAccess, cascadeStyle, creationProcess);
        Component component = (Component)bootProperty.getValue();
        EmbeddableMappingType embeddableMappingType = EmbeddableMappingType.from(component, attrType, tableExpression, rootTableKeyColumnNames, attributeMappingType -> new EmbeddedAttributeMapping(attrName, declaringType.getNavigableRole().append(attrName), stateArrayPosition, tableExpression, attributeMetadataAccess, component.getParentProperty(), FetchStrategy.IMMEDIATE_JOIN, (EmbeddableMappingType)attributeMappingType, declaringType, propertyAccess), creationProcess);
        return (EmbeddedAttributeMapping)embeddableMappingType.getEmbeddedValueMapping();
    }

    protected static StateArrayContributorMetadataAccess getStateArrayContributorMetadataAccess(final Property bootProperty, final Type attrType, final PropertyAccess propertyAccess, final CascadeStyle cascadeStyle, final MappingModelCreationProcess creationProcess) {
        return entityMappingType -> new StateArrayContributorMetadata(){
            private final boolean nullable;
            private final boolean insertable;
            private final boolean updateable;
            private final boolean includeInOptimisticLocking;
            private final MutabilityPlan mutabilityPlan;
            {
                this.nullable = bootProperty.getValue().isNullable();
                this.insertable = bootProperty.isInsertable();
                this.updateable = bootProperty.isUpdateable();
                this.includeInOptimisticLocking = bootProperty.isOptimisticLocked();
                this.mutabilityPlan = this.updateable ? new MutabilityPlan(){

                    @Override
                    public boolean isMutable() {
                        return true;
                    }

                    public Object deepCopy(Object value) {
                        if (value == null) {
                            return null;
                        }
                        return attrType.deepCopy(value, creationProcess.getCreationContext().getSessionFactory());
                    }

                    public Serializable disassemble(Object value, SharedSessionContract session) {
                        throw new NotYetImplementedFor6Exception(this.getClass());
                    }

                    public Object assemble(Serializable cached, SharedSessionContract session) {
                        throw new NotYetImplementedFor6Exception(this.getClass());
                    }
                } : ImmutableMutabilityPlan.INSTANCE;
            }

            @Override
            public PropertyAccess getPropertyAccess() {
                return propertyAccess;
            }

            @Override
            public MutabilityPlan getMutabilityPlan() {
                return this.mutabilityPlan;
            }

            @Override
            public boolean isNullable() {
                return this.nullable;
            }

            @Override
            public boolean isInsertable() {
                return this.insertable;
            }

            @Override
            public boolean isUpdatable() {
                return this.updateable;
            }

            @Override
            public boolean isIncludedInDirtyChecking() {
                return this.updateable;
            }

            @Override
            public boolean isIncludedInOptimisticLocking() {
                return this.includeInOptimisticLocking;
            }

            @Override
            public CascadeStyle getCascadeStyle() {
                return cascadeStyle;
            }
        };
    }

    protected static StateArrayContributorMetadataAccess getStateArrayContributorMetadataAccess(final PropertyAccess propertyAccess) {
        return entityMappingType -> new StateArrayContributorMetadata(){
            private final MutabilityPlan mutabilityPlan = ImmutableMutabilityPlan.INSTANCE;

            @Override
            public PropertyAccess getPropertyAccess() {
                return propertyAccess;
            }

            @Override
            public MutabilityPlan getMutabilityPlan() {
                return this.mutabilityPlan;
            }

            @Override
            public boolean isNullable() {
                return false;
            }

            @Override
            public boolean isInsertable() {
                return true;
            }

            @Override
            public boolean isUpdatable() {
                return false;
            }

            @Override
            public boolean isIncludedInDirtyChecking() {
                return false;
            }

            @Override
            public boolean isIncludedInOptimisticLocking() {
                return true;
            }

            @Override
            public CascadeStyle getCascadeStyle() {
                return null;
            }
        };
    }

    public static PluralAttributeMapping buildPluralAttributeMapping(String attrName, int stateArrayPosition, final Property bootProperty, ManagedMappingType declaringType, final PropertyAccess propertyAccess, final CascadeStyle cascadeStyle, FetchMode fetchMode, MappingModelCreationProcess creationProcess) {
        CollectionPart indexDescriptor;
        CollectionMappingTypeImpl collectionMappingType;
        org.hibernate.mapping.Collection bootValueMapping = (org.hibernate.mapping.Collection)bootProperty.getValue();
        RuntimeModelCreationContext creationContext = creationProcess.getCreationContext();
        SessionFactoryImplementor sessionFactory = creationContext.getSessionFactory();
        Dialect dialect = sessionFactory.getJdbcServices().getJdbcEnvironment().getDialect();
        MappingMetamodel domainModel = creationContext.getDomainModel();
        CollectionPersister collectionDescriptor = domainModel.findCollectionDescriptor(bootValueMapping.getRole());
        assert (collectionDescriptor != null);
        String tableExpression = ((Joinable)((Object)collectionDescriptor)).getTableName();
        String sqlAliasStem = SqlAliasStemHelper.INSTANCE.generateStemFromAttributeName(bootProperty.getName());
        JavaTypeDescriptorRegistry jtdRegistry = creationContext.getJavaTypeDescriptorRegistry();
        CollectionPart elementDescriptor = MappingModelCreationHelper.interpretElement(bootValueMapping, tableExpression, collectionDescriptor, sqlAliasStem, dialect, creationProcess);
        CollectionIdentifierDescriptorImpl identifierDescriptor = null;
        CollectionSemantics collectionSemantics = collectionDescriptor.getCollectionSemantics();
        switch (collectionSemantics.getCollectionClassification()) {
            case ARRAY: {
                collectionMappingType = new CollectionMappingTypeImpl(jtdRegistry.getDescriptor((java.lang.reflect.Type)((Object)Object[].class)), StandardArraySemantics.INSTANCE);
                BasicValue index = (BasicValue)((IndexedCollection)bootValueMapping).getIndex();
                SelectableMapping selectableMapping = SelectableMappingImpl.from(tableExpression, index.getColumnIterator().next(), creationContext.getTypeConfiguration().getBasicTypeForJavaType(Integer.class), dialect, creationProcess.getSqmFunctionRegistry());
                indexDescriptor = new BasicValuedCollectionPart(collectionDescriptor, CollectionPart.Nature.INDEX, null, selectableMapping);
                break;
            }
            case BAG: {
                collectionMappingType = new CollectionMappingTypeImpl(jtdRegistry.getDescriptor((java.lang.reflect.Type)((Object)Collection.class)), StandardBagSemantics.INSTANCE);
                indexDescriptor = null;
                break;
            }
            case IDBAG: {
                collectionMappingType = new CollectionMappingTypeImpl(jtdRegistry.getDescriptor((java.lang.reflect.Type)((Object)Collection.class)), StandardIdentifierBagSemantics.INSTANCE);
                indexDescriptor = null;
                assert (collectionDescriptor instanceof SQLLoadableCollection);
                SQLLoadableCollection loadableCollection = (SQLLoadableCollection)collectionDescriptor;
                String identifierColumnName = loadableCollection.getIdentifierColumnName();
                assert (identifierColumnName != null);
                identifierDescriptor = new CollectionIdentifierDescriptorImpl(collectionDescriptor, tableExpression, identifierColumnName, (BasicType)loadableCollection.getIdentifierType());
                break;
            }
            case LIST: {
                BasicValue index = (BasicValue)((IndexedCollection)bootValueMapping).getIndex();
                SelectableMapping selectableMapping = SelectableMappingImpl.from(tableExpression, index.getColumnIterator().next(), creationContext.getTypeConfiguration().getBasicTypeForJavaType(Integer.class), dialect, creationProcess.getSqmFunctionRegistry());
                indexDescriptor = new BasicValuedCollectionPart(collectionDescriptor, CollectionPart.Nature.INDEX, null, selectableMapping);
                collectionMappingType = new CollectionMappingTypeImpl(jtdRegistry.getDescriptor((java.lang.reflect.Type)((Object)List.class)), StandardListSemantics.INSTANCE);
                break;
            }
            case MAP: 
            case ORDERED_MAP: 
            case SORTED_MAP: {
                Class mapJavaType = collectionSemantics.getCollectionClassification() == CollectionClassification.SORTED_MAP ? SortedMap.class : Map.class;
                collectionMappingType = new CollectionMappingTypeImpl(jtdRegistry.getDescriptor((java.lang.reflect.Type)((Object)mapJavaType)), collectionSemantics);
                indexDescriptor = MappingModelCreationHelper.interpretMapKey(bootValueMapping, collectionDescriptor, tableExpression, sqlAliasStem, dialect, creationProcess);
                break;
            }
            case SET: 
            case ORDERED_SET: 
            case SORTED_SET: {
                Class setJavaType = collectionSemantics.getCollectionClassification() == CollectionClassification.SORTED_MAP ? SortedSet.class : Set.class;
                collectionMappingType = new CollectionMappingTypeImpl(jtdRegistry.getDescriptor((java.lang.reflect.Type)((Object)setJavaType)), collectionSemantics);
                indexDescriptor = null;
                break;
            }
            default: {
                throw new MappingException("Unexpected CollectionClassification : " + (Object)((Object)collectionSemantics.getCollectionClassification()));
            }
        }
        StateArrayContributorMetadata contributorMetadata = new StateArrayContributorMetadata(){

            @Override
            public PropertyAccess getPropertyAccess() {
                return propertyAccess;
            }

            @Override
            public MutabilityPlan getMutabilityPlan() {
                return ImmutableMutabilityPlan.instance();
            }

            @Override
            public boolean isNullable() {
                return bootProperty.isOptional();
            }

            @Override
            public boolean isInsertable() {
                return bootProperty.isInsertable();
            }

            @Override
            public boolean isUpdatable() {
                return bootProperty.isUpdateable();
            }

            @Override
            public boolean isIncludedInDirtyChecking() {
                return false;
            }

            @Override
            public boolean isIncludedInOptimisticLocking() {
                return bootProperty.isOptimisticLocked();
            }

            @Override
            public CascadeStyle getCascadeStyle() {
                return cascadeStyle;
            }
        };
        FetchStyle style = FetchStrategyHelper.determineFetchStyleByMetadata(fetchMode, collectionDescriptor.getCollectionType(), sessionFactory);
        PluralAttributeMappingImpl pluralAttributeMapping = new PluralAttributeMappingImpl(attrName, bootValueMapping, propertyAccess, entityMappingType -> contributorMetadata, collectionMappingType, stateArrayPosition, elementDescriptor, indexDescriptor, identifierDescriptor, new FetchStrategy(FetchStrategyHelper.determineFetchTiming(style, collectionDescriptor.getCollectionType(), sessionFactory), style), cascadeStyle, declaringType, collectionDescriptor);
        creationProcess.registerInitializationCallback("PluralAttributeMapping(" + bootValueMapping.getRole() + ")#finishInitialization", () -> {
            try {
                pluralAttributeMapping.finishInitialization(bootProperty, bootValueMapping, creationProcess);
                return true;
            }
            catch (NotYetImplementedFor6Exception nye) {
                throw nye;
            }
            catch (Exception e) {
                if (e instanceof NonTransientException) {
                    throw e;
                }
                return false;
            }
        });
        creationProcess.registerInitializationCallback("PluralAttributeMapping(" + bootValueMapping.getRole() + ") - key descriptor", () -> {
            MappingModelCreationHelper.interpretPluralAttributeMappingKeyDescriptor(pluralAttributeMapping, bootValueMapping, collectionDescriptor, declaringType, dialect, creationProcess);
            return true;
        });
        return pluralAttributeMapping;
    }

    private static void interpretPluralAttributeMappingKeyDescriptor(PluralAttributeMappingImpl attributeMapping, org.hibernate.mapping.Collection bootValueMapping, CollectionPersister collectionDescriptor, ManagedMappingType declaringType, Dialect dialect, MappingModelCreationProcess creationProcess) {
        ModelPart attributeMappingSubPart = null;
        if (!StringHelper.isEmpty(collectionDescriptor.getMappedByProperty())) {
            attributeMappingSubPart = attributeMapping.findSubPart(collectionDescriptor.getMappedByProperty(), null);
        }
        if (attributeMappingSubPart instanceof ToOneAttributeMapping) {
            ToOneAttributeMapping referencedAttributeMapping = (ToOneAttributeMapping)attributeMappingSubPart;
            MappingModelCreationHelper.setReferencedAttributeForeignKeyDescriptor(attributeMapping, referencedAttributeMapping, (EntityPersister)referencedAttributeMapping.getDeclaringType(), collectionDescriptor.getMappedByProperty(), dialect, creationProcess);
            return;
        }
        KeyValue bootValueMappingKey = bootValueMapping.getKey();
        Type keyType = bootValueMappingKey.getType();
        String lhsPropertyName = collectionDescriptor.getCollectionType().getLHSPropertyName();
        boolean isReferenceToPrimaryKey = lhsPropertyName == null;
        ModelPart fkTarget = isReferenceToPrimaryKey ? collectionDescriptor.getOwnerEntityPersister().getIdentifierMapping() : declaringType.findAttributeMapping(lhsPropertyName);
        if (keyType instanceof BasicType) {
            assert (bootValueMappingKey.getColumnSpan() == 1);
            assert (fkTarget instanceof BasicValuedModelPart);
            BasicValuedModelPart simpleFkTarget = (BasicValuedModelPart)fkTarget;
            String tableExpression = MappingModelCreationHelper.getTableIdentifierExpression(bootValueMappingKey.getTable(), creationProcess);
            SelectableMapping keySelectableMapping = SelectableMappingImpl.from(tableExpression, bootValueMappingKey.getColumnIterator().next(), (JdbcMapping)((Object)keyType), dialect, creationProcess.getSqmFunctionRegistry());
            attributeMapping.setForeignKeyDescriptor(new SimpleForeignKeyDescriptor(keySelectableMapping, simpleFkTarget, owner -> ((PropertyBasedMapping)((Object)simpleFkTarget)).getPropertyAccess().getGetter().get(owner), isReferenceToPrimaryKey));
        } else if (fkTarget instanceof EmbeddableValuedModelPart) {
            EmbeddedForeignKeyDescriptor embeddedForeignKeyDescriptor = MappingModelCreationHelper.buildEmbeddableForeignKeyDescriptor((EmbeddableValuedModelPart)fkTarget, bootValueMapping, dialect, creationProcess);
            attributeMapping.setForeignKeyDescriptor(embeddedForeignKeyDescriptor);
        } else {
            throw new NotYetImplementedFor6Exception("Support for " + fkTarget.getClass() + " foreign keys not yet implemented: " + bootValueMapping.getRole());
        }
    }

    public static void interpretToOneKeyDescriptor(ToOneAttributeMapping attributeMapping, Property bootProperty, ToOne bootValueMapping, Dialect dialect, MappingModelCreationProcess creationProcess) {
        String referencedPropertyName;
        if (attributeMapping.getForeignKeyDescriptor() != null) {
            return;
        }
        String tableName = MappingModelCreationHelper.getTableIdentifierExpression(bootValueMapping.getTable(), creationProcess);
        attributeMapping.setIdentifyingColumnsTableExpression(tableName);
        EntityPersister referencedEntityDescriptor = creationProcess.getEntityPersister(bootValueMapping.getReferencedEntityName());
        boolean swapDirection = false;
        if (bootValueMapping instanceof OneToOne) {
            OneToOne oneToOne = (OneToOne)bootValueMapping;
            swapDirection = oneToOne.getForeignKeyType() == ForeignKeyDirection.TO_PARENT;
            referencedPropertyName = oneToOne.getMappedByProperty();
            if (referencedPropertyName == null) {
                referencedPropertyName = oneToOne.getReferencedPropertyName();
            }
        } else {
            referencedPropertyName = null;
        }
        if (referencedPropertyName != null) {
            ModelPart modelPart = referencedEntityDescriptor.findSubPart(referencedPropertyName);
            if (modelPart instanceof ToOneAttributeMapping) {
                MappingModelCreationHelper.setReferencedAttributeForeignKeyDescriptor(attributeMapping, (ToOneAttributeMapping)modelPart, referencedEntityDescriptor, referencedPropertyName, dialect, creationProcess);
            } else if (modelPart instanceof EmbeddableValuedModelPart) {
                EmbeddedForeignKeyDescriptor embeddedForeignKeyDescriptor = MappingModelCreationHelper.buildEmbeddableForeignKeyDescriptor((EmbeddableValuedModelPart)modelPart, bootValueMapping, true, dialect, creationProcess);
                attributeMapping.setForeignKeyDescriptor(embeddedForeignKeyDescriptor);
            } else {
                throw new NotYetImplementedFor6Exception("Support for foreign-keys based on `" + modelPart + "` not yet implemented: " + bootProperty.getPersistentClass().getEntityName() + " -> " + bootProperty.getName());
            }
            return;
        }
        if (!bootValueMapping.isReferenceToPrimaryKey()) {
            throw new NotYetImplementedFor6Exception("Support for non-pk foreign-keys not yet implemented: " + bootProperty.getPersistentClass().getEntityName() + " -> " + bootProperty.getName());
        }
        EntityIdentifierMapping fkTarget = referencedEntityDescriptor.getIdentifierMapping();
        if (fkTarget instanceof BasicValuedModelPart) {
            BasicValuedModelPart simpleFkTarget = (BasicValuedModelPart)((Object)fkTarget);
            Iterator<Selectable> columnIterator = bootValueMapping.getColumnIterator();
            Table table = bootValueMapping.getTable();
            String tableExpression = MappingModelCreationHelper.getTableIdentifierExpression(table, creationProcess);
            SelectableMapping keySelectableMapping = columnIterator.hasNext() ? SelectableMappingImpl.from(tableExpression, columnIterator.next(), simpleFkTarget.getJdbcMapping(), dialect, creationProcess.getSqmFunctionRegistry()) : SelectableMappingImpl.from(tableExpression, table.getColumn(0), simpleFkTarget.getJdbcMapping(), dialect, creationProcess.getSqmFunctionRegistry());
            SimpleForeignKeyDescriptor foreignKeyDescriptor = new SimpleForeignKeyDescriptor(keySelectableMapping, simpleFkTarget, owner -> ((PropertyBasedMapping)((Object)simpleFkTarget)).getPropertyAccess().getGetter().get(owner), bootValueMapping.isReferenceToPrimaryKey(), swapDirection);
            attributeMapping.setForeignKeyDescriptor(foreignKeyDescriptor);
        } else if (fkTarget instanceof EmbeddableValuedModelPart) {
            EmbeddedForeignKeyDescriptor embeddedForeignKeyDescriptor = MappingModelCreationHelper.buildEmbeddableForeignKeyDescriptor((EmbeddableValuedModelPart)((Object)fkTarget), bootValueMapping, swapDirection, dialect, creationProcess);
            attributeMapping.setForeignKeyDescriptor(embeddedForeignKeyDescriptor);
        } else {
            throw new NotYetImplementedFor6Exception("Support for " + fkTarget.getClass() + " foreign-keys not yet implemented: " + bootProperty.getPersistentClass().getEntityName() + " -> " + bootProperty.getName());
        }
    }

    public static EmbeddedForeignKeyDescriptor buildEmbeddableForeignKeyDescriptor(EmbeddableValuedModelPart embeddableValuedModelPart, Value bootValueMapping, Dialect dialect, MappingModelCreationProcess creationProcess) {
        return MappingModelCreationHelper.buildEmbeddableForeignKeyDescriptor(embeddableValuedModelPart, bootValueMapping, false, dialect, creationProcess);
    }

    private static EmbeddedForeignKeyDescriptor buildEmbeddableForeignKeyDescriptor(EmbeddableValuedModelPart embeddableValuedModelPart, Value bootValueMapping, boolean inverse, Dialect dialect, MappingModelCreationProcess creationProcess) {
        SelectableMappings keySelectableMappings;
        String keyTableExpression;
        if (bootValueMapping instanceof org.hibernate.mapping.Collection) {
            org.hibernate.mapping.Collection collectionBootValueMapping = (org.hibernate.mapping.Collection)bootValueMapping;
            keyTableExpression = MappingModelCreationHelper.getTableIdentifierExpression(collectionBootValueMapping.getCollectionTable(), creationProcess);
            keySelectableMappings = SelectableMappingsImpl.from(keyTableExpression, collectionBootValueMapping.getKey(), MappingModelCreationHelper.getPropertyOrder(bootValueMapping, creationProcess), creationProcess.getCreationContext().getSessionFactory(), dialect, creationProcess.getSqmFunctionRegistry());
        } else {
            keyTableExpression = MappingModelCreationHelper.getTableIdentifierExpression(bootValueMapping.getTable(), creationProcess);
            keySelectableMappings = SelectableMappingsImpl.from(keyTableExpression, bootValueMapping, MappingModelCreationHelper.getPropertyOrder(bootValueMapping, creationProcess), creationProcess.getCreationContext().getSessionFactory(), dialect, creationProcess.getSqmFunctionRegistry());
        }
        if (inverse) {
            return new EmbeddedForeignKeyDescriptor(embeddableValuedModelPart, EmbeddedAttributeMapping.createInverseModelPart(embeddableValuedModelPart, keySelectableMappings, creationProcess), embeddableValuedModelPart.getContainingTableExpression(), embeddableValuedModelPart.getEmbeddableTypeDescriptor(), keyTableExpression, keySelectableMappings, creationProcess);
        }
        return new EmbeddedForeignKeyDescriptor(EmbeddedAttributeMapping.createInverseModelPart(embeddableValuedModelPart, keySelectableMappings, creationProcess), embeddableValuedModelPart, keyTableExpression, keySelectableMappings, embeddableValuedModelPart.getContainingTableExpression(), embeddableValuedModelPart.getEmbeddableTypeDescriptor(), creationProcess);
    }

    private static int[] getPropertyOrder(Value bootValueMapping, MappingModelCreationProcess creationProcess) {
        ComponentType componentType;
        boolean fromXml;
        if (bootValueMapping instanceof org.hibernate.mapping.Collection) {
            org.hibernate.mapping.Collection collectionBootValueMapping = (org.hibernate.mapping.Collection)bootValueMapping;
            fromXml = collectionBootValueMapping.getBuildingContext() instanceof MappingDocument;
            componentType = (ComponentType)collectionBootValueMapping.getKey().getType();
        } else {
            fromXml = bootValueMapping instanceof OneToMany ? ((OneToMany)bootValueMapping).getBuildingContext() instanceof MappingDocument : ((SimpleValue)bootValueMapping).getBuildingContext() instanceof MappingDocument;
            EntityType entityType = (EntityType)bootValueMapping.getType();
            Type identifierOrUniqueKeyType = entityType.getIdentifierOrUniqueKeyType(creationProcess.getCreationContext().getSessionFactory());
            componentType = (ComponentType)identifierOrUniqueKeyType;
        }
        if (fromXml) {
            return componentType.getOriginalPropertyOrder();
        }
        int[] propertyReordering = new int[componentType.getSubtypes().length];
        for (int i = 0; i < propertyReordering.length; ++i) {
            propertyReordering[i] = i;
        }
        return propertyReordering;
    }

    private static void setReferencedAttributeForeignKeyDescriptor(AbstractAttributeMapping attributeMapping, ToOneAttributeMapping referencedAttributeMapping, EntityPersister referencedEntityDescriptor, String referencedPropertyName, Dialect dialect, MappingModelCreationProcess creationProcess) {
        ForeignKeyDescriptor foreignKeyDescriptor = referencedAttributeMapping.getForeignKeyDescriptor();
        if (foreignKeyDescriptor == null) {
            PersistentClass entityBinding = creationProcess.getCreationContext().getBootModel().getEntityBinding(referencedEntityDescriptor.getEntityName());
            Property property = entityBinding.getProperty(referencedPropertyName);
            MappingModelCreationHelper.interpretToOneKeyDescriptor(referencedAttributeMapping, property, (ToOne)property.getValue(), dialect, creationProcess);
            attributeMapping.setForeignKeyDescriptor(referencedAttributeMapping.getForeignKeyDescriptor());
        } else {
            attributeMapping.setForeignKeyDescriptor(foreignKeyDescriptor);
        }
    }

    private static String getTableIdentifierExpression(Table table, MappingModelCreationProcess creationProcess) {
        JdbcEnvironment jdbcEnvironment = creationProcess.getCreationContext().getMetadata().getDatabase().getJdbcEnvironment();
        return jdbcEnvironment.getQualifiedObjectNameFormatter().format(table.getQualifiedTableName(), jdbcEnvironment.getDialect());
    }

    private static CollectionPart interpretMapKey(org.hibernate.mapping.Collection bootValueMapping, CollectionPersister collectionDescriptor, String tableExpression, String sqlAliasStem, Dialect dialect, MappingModelCreationProcess creationProcess) {
        assert (bootValueMapping instanceof IndexedCollection);
        IndexedCollection indexedCollection = (IndexedCollection)bootValueMapping;
        Value bootMapKeyDescriptor = indexedCollection.getIndex();
        if (bootMapKeyDescriptor instanceof BasicValue) {
            BasicValue basicValue = (BasicValue)bootMapKeyDescriptor;
            SelectableMapping selectableMapping = SelectableMappingImpl.from(tableExpression, basicValue.getColumnIterator().next(), basicValue.resolve().getJdbcMapping(), dialect, creationProcess.getSqmFunctionRegistry());
            return new BasicValuedCollectionPart(collectionDescriptor, CollectionPart.Nature.INDEX, basicValue.resolve().getValueConverter(), selectableMapping);
        }
        if (bootMapKeyDescriptor instanceof Component) {
            Component component = (Component)bootMapKeyDescriptor;
            CompositeType compositeType = (CompositeType)component.getType();
            EmbeddableMappingType mappingType = EmbeddableMappingType.from(component, compositeType, inflightDescriptor -> new EmbeddedCollectionPart(collectionDescriptor, CollectionPart.Nature.INDEX, (EmbeddableMappingType)inflightDescriptor, component.getParentProperty(), tableExpression, sqlAliasStem), creationProcess);
            return (CollectionPart)((Object)mappingType.getEmbeddedValueMapping());
        }
        if (bootMapKeyDescriptor instanceof OneToMany || bootMapKeyDescriptor instanceof ToOne) {
            EntityType indexEntityType = (EntityType)collectionDescriptor.getIndexType();
            EntityPersister associatedEntity = creationProcess.getEntityPersister(indexEntityType.getAssociatedEntityName());
            EntityCollectionPart indexDescriptor = new EntityCollectionPart(collectionDescriptor, CollectionPart.Nature.INDEX, bootMapKeyDescriptor, associatedEntity, creationProcess);
            creationProcess.registerInitializationCallback("PluralAttributeMapping( " + bootValueMapping.getRole() + ") - index descriptor", () -> {
                try {
                    indexDescriptor.finishInitialization(collectionDescriptor, bootValueMapping, indexEntityType.getRHSUniqueKeyPropertyName(), creationProcess);
                    return true;
                }
                catch (NotYetImplementedFor6Exception nye) {
                    throw nye;
                }
                catch (Exception wait) {
                    return false;
                }
            });
            return indexDescriptor;
        }
        throw new NotYetImplementedFor6Exception("Support for plural attributes with index type [" + bootMapKeyDescriptor + "] not yet implemented");
    }

    private static CollectionPart interpretElement(org.hibernate.mapping.Collection bootDescriptor, String tableExpression, CollectionPersister collectionDescriptor, String sqlAliasStem, Dialect dialect, MappingModelCreationProcess creationProcess) {
        Value element = bootDescriptor.getElement();
        if (element instanceof BasicValue) {
            BasicValue basicElement = (BasicValue)element;
            SelectableMapping selectableMapping = SelectableMappingImpl.from(tableExpression, basicElement.getColumnIterator().next(), basicElement.resolve().getJdbcMapping(), dialect, creationProcess.getSqmFunctionRegistry());
            return new BasicValuedCollectionPart(collectionDescriptor, CollectionPart.Nature.ELEMENT, basicElement.resolve().getValueConverter(), selectableMapping);
        }
        if (element instanceof Component) {
            Component component = (Component)element;
            CompositeType compositeType = (CompositeType)collectionDescriptor.getElementType();
            EmbeddableMappingType mappingType = EmbeddableMappingType.from(component, compositeType, embeddableMappingType -> new EmbeddedCollectionPart(collectionDescriptor, CollectionPart.Nature.ELEMENT, (EmbeddableMappingType)embeddableMappingType, component.getParentProperty(), tableExpression, sqlAliasStem), creationProcess);
            return (CollectionPart)((Object)mappingType.getEmbeddedValueMapping());
        }
        if (element instanceof Any) {
            Any anyBootMapping = (Any)element;
            SessionFactoryImplementor sessionFactory = creationProcess.getCreationContext().getSessionFactory();
            TypeConfiguration typeConfiguration = sessionFactory.getTypeConfiguration();
            JavaTypeDescriptorRegistry jtdRegistry = typeConfiguration.getJavaTypeDescriptorRegistry();
            JavaTypeDescriptor<Object> baseJtd = jtdRegistry.getDescriptor((java.lang.reflect.Type)((Object)Object.class));
            return new DiscriminatedCollectionPart(CollectionPart.Nature.ELEMENT, collectionDescriptor.getNavigableRole(), baseJtd, anyBootMapping, anyBootMapping.getType(), creationProcess);
        }
        if (element instanceof OneToMany || element instanceof ToOne) {
            EntityType elementEntityType = (EntityType)collectionDescriptor.getElementType();
            EntityPersister associatedEntity = creationProcess.getEntityPersister(elementEntityType.getAssociatedEntityName());
            EntityCollectionPart elementDescriptor = new EntityCollectionPart(collectionDescriptor, CollectionPart.Nature.ELEMENT, bootDescriptor.getElement(), associatedEntity, creationProcess);
            creationProcess.registerInitializationCallback("PluralAttributeMapping( " + elementDescriptor.getNavigableRole() + ") - index descriptor", () -> {
                try {
                    elementDescriptor.finishInitialization(collectionDescriptor, bootDescriptor, elementEntityType.getRHSUniqueKeyPropertyName(), creationProcess);
                    return true;
                }
                catch (NotYetImplementedFor6Exception nye) {
                    throw nye;
                }
                catch (Exception wait) {
                    return false;
                }
            });
            return elementDescriptor;
        }
        throw new NotYetImplementedFor6Exception("Support for plural attributes with element type [" + element + "] not yet implemented");
    }

    public static ToOneAttributeMapping buildSingularAssociationAttributeMapping(String attrName, NavigableRole navigableRole, int stateArrayPosition, Property bootProperty, ManagedMappingType declaringType, EntityPersister declaringEntityPersister, EntityType attrType, PropertyAccess propertyAccess, CascadeStyle cascadeStyle, MappingModelCreationProcess creationProcess) {
        if (bootProperty.getValue() instanceof ToOne) {
            ToOne value = (ToOne)bootProperty.getValue();
            EntityPersister entityPersister = creationProcess.getEntityPersister(value.getReferencedEntityName());
            StateArrayContributorMetadataAccess stateArrayContributorMetadataAccess = MappingModelCreationHelper.getStateArrayContributorMetadataAccess(bootProperty, attrType, propertyAccess, cascadeStyle, creationProcess);
            SessionFactoryImplementor sessionFactory = creationProcess.getCreationContext().getSessionFactory();
            AssociationType type = (AssociationType)bootProperty.getType();
            FetchStyle fetchStyle = FetchStrategyHelper.determineFetchStyleByMetadata(bootProperty.getValue().getFetchMode(), type, sessionFactory);
            FetchTiming fetchTiming = fetchStyle == FetchStyle.JOIN || value instanceof OneToOne && value.isNullable() || !value.isLazy() ? FetchTiming.IMMEDIATE : FetchStrategyHelper.determineFetchTiming(fetchStyle, type, sessionFactory);
            FetchStrategy fetchStrategy = new FetchStrategy(fetchTiming, fetchStyle);
            ToOneAttributeMapping attributeMapping = new ToOneAttributeMapping(attrName, navigableRole, stateArrayPosition, (ToOne)bootProperty.getValue(), stateArrayContributorMetadataAccess, fetchStrategy, entityPersister, declaringType, declaringEntityPersister, propertyAccess);
            creationProcess.registerForeignKeyPostInitCallbacks("To-one key - " + navigableRole, () -> {
                Dialect dialect = creationProcess.getCreationContext().getSessionFactory().getJdbcServices().getDialect();
                MappingModelCreationHelper.interpretToOneKeyDescriptor(attributeMapping, bootProperty, (ToOne)bootProperty.getValue(), dialect, creationProcess);
                return true;
            });
            return attributeMapping;
        }
        throw new NotYetImplementedFor6Exception("AnyType support has not yet been implemented");
    }

    private static class CollectionMappingTypeImpl
    implements CollectionMappingType {
        private final JavaTypeDescriptor collectionJtd;
        private final CollectionSemantics semantics;

        public CollectionMappingTypeImpl(JavaTypeDescriptor collectionJtd, CollectionSemantics semantics) {
            this.collectionJtd = collectionJtd;
            this.semantics = semantics;
        }

        public CollectionSemantics getCollectionSemantics() {
            return this.semantics;
        }

        public JavaTypeDescriptor getMappedJavaTypeDescriptor() {
            return this.collectionJtd;
        }
    }
}

