/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.io.Serializable;
import java.util.List;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.Property;
import org.hibernate.metamodel.internal.AbstractCompositeIdentifierMapping;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.SingularAttributeMapping;
import org.hibernate.metamodel.mapping.StateArrayContributorMetadataAccess;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.ComponentType;

public class NonAggregatedIdentifierMappingImpl
extends AbstractCompositeIdentifierMapping {
    private final List<SingularAttributeMapping> idAttributeMappings;
    private final Component bootCidDescriptor;
    private final Component bootIdClassDescriptor;

    public NonAggregatedIdentifierMappingImpl(EmbeddableMappingType embeddableDescriptor, EntityMappingType entityMapping, List<SingularAttributeMapping> idAttributeMappings, StateArrayContributorMetadataAccess attributeMetadataAccess, String rootTableName, Component bootIdClassDescriptor, Component bootCidDescriptor, MappingModelCreationProcess creationProcess) {
        super(attributeMetadataAccess, embeddableDescriptor, entityMapping, rootTableName, creationProcess.getCreationContext().getSessionFactory());
        this.idAttributeMappings = idAttributeMappings;
        this.bootCidDescriptor = bootCidDescriptor;
        this.bootIdClassDescriptor = bootIdClassDescriptor;
    }

    @Override
    public int getAttributeCount() {
        return this.idAttributeMappings.size();
    }

    @Override
    public List<SingularAttributeMapping> getAttributes() {
        return this.idAttributeMappings;
    }

    @Override
    public Object getIdentifier(Object entity, SharedSessionContractImplementor session) {
        if (this.hasContainingClass()) {
            Serializable disassemble = this.bootCidDescriptor.getType().disassemble(entity, session, null);
            return this.bootIdClassDescriptor.getType().assemble(disassemble, session, null);
        }
        return entity;
    }

    @Override
    public void setIdentifier(Object entity, Object id, SharedSessionContractImplementor session) {
        SessionFactoryImplementor factory = session.getFactory();
        Object[] propertyValues = ((ComponentType)this.bootIdClassDescriptor.getType()).getPropertyValues(id, session);
        this.forEachAttribute((position, attribute) -> {
            Object propertyValue = propertyValues[position];
            Property property = this.bootIdClassDescriptor.getProperty(position);
            if (attribute instanceof ToOneAttributeMapping && !(property.getValue() instanceof ManyToOne)) {
                ToOneAttributeMapping toOneAttributeMapping = (ToOneAttributeMapping)attribute;
                EntityPersister entityPersister = toOneAttributeMapping.getEntityMappingType().getEntityPersister();
                EntityKey entityKey = session.generateEntityKey(propertyValue, entityPersister);
                PersistenceContext persistenceContext = session.getPersistenceContext();
                propertyValue = persistenceContext.getProxy(entityKey);
                if (propertyValue == null && (propertyValue = persistenceContext.getEntity(entityKey)) == null) {
                    propertyValue = factory.getMetamodel().findEntityDescriptor(entity.getClass()).getPropertyValue(entity, toOneAttributeMapping.getAttributeName());
                }
            }
            attribute.getPropertyAccess().getSetter().set(entity, propertyValue, factory);
        });
    }

    @Override
    public void breakDownJdbcValues(Object domainValue, ModelPart.JdbcValueConsumer valueConsumer, SharedSessionContractImplementor session) {
        assert (domainValue instanceof Object[]);
        Object[] values = (Object[])domainValue;
        assert (values.length == this.idAttributeMappings.size());
        for (int i = 0; i < this.idAttributeMappings.size(); ++i) {
            SingularAttributeMapping attribute = this.idAttributeMappings.get(i);
            attribute.breakDownJdbcValues(values[i], valueConsumer, session);
        }
    }

    @Override
    public String getSqlAliasStem() {
        return "id";
    }

    @Override
    public String getFetchableName() {
        return "id";
    }

    @Override
    public int getNumberOfFetchables() {
        return this.idAttributeMappings.size();
    }

    @Override
    public boolean hasContainingClass() {
        return this.bootIdClassDescriptor != this.bootCidDescriptor;
    }
}

